package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 标题:UocApproveMoveServiceReqBo
 * 说明:
 * 时间:2022/3/10 13:32
 * 作者:田桂银
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocApproveMoveServiceReqBo extends BaseReqBo {

    private static final long serialVersionUID = -6064478888374168978L;

//    审批单id
//    private Long auditOrderId;

    /**
     * 对象id，例如销售单id，发货单id"
     */
    private Long objId;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 流程实例id
     */
    private String procInstId;

    /**
     * 审批结果 1通过 0驳回
     */
    private Integer finalResult;

    /**
     * 审批是否结束
     */
    private Boolean finished;

    /**
     * 旧任务实例id
     */
    private String oldTaskInstId;

    /**
     * 审批对象类型：1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单  8验收单
     */
    private Integer objType;

    /**
     * 审批对象业务类型：1调价 2.订单审批
     */
    private Integer objBusiType;

    /**
     * 审批任务列表
     */
    private List<UocApproveMoveServiceReqTaskBo> taskBoList;

    /**
     * 处理原因
     */
    private String dealReason;

    /**
     * 处理描述
     */
    private String dealDesc;

    /**
     * 处理人岗位id
     */
    private String dealPostId;

    /**
     * 处理人岗位名称
     */
    private String dealPostName;

    /**
     * 附件
     */
    private List<UocApproveMoveServiceReqAccessoryBo> accessoryBos;

    private Long userId;
    private String name;
    private Long orgId;

    /**
     * 租户id
     */
    private Long sysTenantId;
    private String sysTenantName;

}


