package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题：UocShouldPayCalculateShouldBO
 * 说明：
 * 时间：2022/4/6 20:28
 * 作者： 周中贤
 */
@Data
public class UocShouldPayCalculateShouldBO implements Serializable {
    private static final long serialVersionUID = -7839661842851828475L;

    /**
     * 付款方式
     */
    private Integer payType;
    /**
     * 应付类型1：账期应付：2：预付款应付；3：成交服务费应付；4：平台使用费应付；5：到货款应付；6：验收款应付；7：质保金应付
     */
    private Integer shouldPayType;
    /**
     * 单据ID
     */
    private Long objectId;
    /**
     * 单据编码
     */
    private String objectNo;
    /**
     * 订单ID
     */
    private Long orderId;
    /**
     * 对象类型，1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单  8验收单  9审批单 10变更单   99.其他
     */
    private Integer objectType;
    /**
     * 返回单据类型 1：采购订单 2：通用结算单 3：成交服务费结算单  4：平台使用费结算单 5：销售订单 6：验收单7：发货单
     */
    private Integer objectTypeReturn;
    /**
     * 应付金额
     */
    private BigDecimal shouldPayAmount;
    /**
     * 应付日期
     */
    private Date shouldPayDate;
    /**
     * 付款方ID
     */
    private Long payerId;

    /**
     * 付款方名称
     */
    private String payerName;

    /**
     * 收款方ID
     */
    private Long payeeId;

    /**
     * 收款方名称
     */
    private String payeeName;
    /**
     * 合同id
     */
    private String contractId;

    /**
     * 合同编号
     */
    private String contractNo;

    /**
     * 违约金比例
     */
    private BigDecimal penaltyRatio;

    /**
     * 入参单据类型 1订单 2.销售单 3.执行单 4.发货单 5.收货单 6.售后服务单 7.支付单 8验收单 9审批单 10变更单
     */
    private Integer objType;

    /**
     * 使用类型：1：采购方；2：平台方
     */
    private Integer userType;

    /**
     * 销售单ID
     */
    private Long saleOrderId;

    /**
     * 租户id
     */
    private Long sysTenantId;
    private String sysTenantName;

}
