package com.tydic.dyc.oc.service.shiporder.bo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class UocShipOrderItemBo implements Serializable {
    private static final long serialVersionUID = -2109465253223335260L;
    
    @DocField(value = "发货明细id")
    private Long shipOrderItemId;
    
    @DocField(value = "订单id")
    private Long orderId;
    
    @DocField(value = "销售单id")
    private Long saleOrderId;
    
    @DocField(value = "执行明细id")
    private Long implOrderItemId;
    
    @DocField(value = "销售明细id")
    private Long saleOrderItemId;
    
    
    @DocField(value = "发货单id")
    private Long shipOrderId;
    
    @DocField(value = "明细状态")
    private String shipItemState;
    
    @DocField(value = "计量单位")
    private String unitName;
    
    @DocField(value = "发货数量")
    private BigDecimal sendCount;
    
    @DocField(value = "到货数量             供应商到货登记时预留字段")
    private BigDecimal arriveCount;
    
    @DocField(value = "拒收数量")
    private BigDecimal refuseCount;
    
    @DocField(value = "退货数量")
    private BigDecimal returnCount;
    
    @DocField(value = "验收数量")
    private BigDecimal inspCount;
    
    @DocField(value = "异常变更在途数量，表示异常供应商确认之前的记录数量")
    private BigDecimal chngingCount;
    
    @DocField(value = "售后在途数量")
    private BigDecimal afterServingCount;
    
    @DocField(value = "创建时间")
    private Date createTime;
    
    @DocField(value = "创建工号")
    private String createOperId;
    
    @DocField(value = "更新时间")
    private Date updateTime;
    
    @DocField(value = "更新工号")
    private String updateOperId;
    
    @DocField(value = "备注")
    private String remark;
    
    @DocField(value = "发货单明细ID List")
    private List<Long> shipOrderItemIdList;
    
    @DocField(value = "超验数量")
    private BigDecimal inspSuperCount;
    
    @DocField("到货金额")
    private BigDecimal arrivePrice;
    
    @DocField("拒收金额")
    private BigDecimal rejectPrice;
}
