package com.tydic.dyc.oc.model.sysdictionary;


import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;

import java.util.List;
import java.util.Map;

/**
 * 标题:IUocSycDictionaryModel
 * 说明:字典领域方法服务
 * 时间:2022/3/9 14:20
 * 作者:tiankunlin
 */
public interface IUocSysDictionaryModel {

    /**
     * 描述: 查字典列表
     *
     * @param reqBO 入参对象
     * @return java.util.List<UocSycDictionaryDo></>
     */
    List<UocSysDictionaryDo> qryDicList(UocSysDictionaryQryBo reqBO);

    /**
     * 描述: 批量查字典
     *
     * @param pCodes 入参对象
     * @return java.util.List<UocSycDictionaryDo></>
     */
    List<UocSysDictionaryDo> qryDicListByPCodes(List<String> pCodes);

    /**
     * 描述: 批量查字典获取map对象
     *
     * @param pCodes 入参对象
     * @return java.util.Map<String,java.util.Map<String,UocSycDictionaryDo>>
     */
    Map<String, Map<String, String>> getDictionaryMap(List<String> pCodes);

    /**
     * 描述: 查字典列表
     *
     * @param reqBO 入参对象
     * @return UocSycDictionaryDo
     */
    UocSysDictionaryDo getModelBy(UocSysDictionaryQryBo reqBO);

    /**
     * 创建字典值
     *
     * @param uocSysDictionaryDo 入参对象
     * @return UocSycDictionaryDo
     */
    UocSysDictionaryDo createDic(UocSysDictionaryDo uocSysDictionaryDo);

    /**
     * 修改字典值
     *
     * @param uocSysDictionaryDo 入参对象
     * @return UocSycDictionaryDo
     */
    UocSysDictionaryDo updateDic(UocSysDictionaryDo uocSysDictionaryDo);

    /**
     * 删除字典值
     *
     * @param reqBO 入参对象
     * @return UocSysDictionaryQryBo
     */
    UocSysDictionaryQryBo deleteDic(UocSysDictionaryQryBo reqBO);
}
