package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocResoveEsPreOrderServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocResoveEsPreOrderServiceReqSkuBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocResoveEsPreOrderServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocResoveEsPreOrderServiceImpl
 * 说明:
 * 时间:2022/4/12 21:05
 * 作者:田桂银
 */
@HTServiceImpl
@Slf4j
public class UocResoveEsPreOrderServiceImpl implements UocResoveEsPreOrderService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocResoveEsPreOrderServiceRspBo dealEsPreOrder(UocResoveEsPreOrderServiceReqBo reqBo) {
        UocResoveEsPreOrderServiceRspBo rspBo = UocRu.success(UocResoveEsPreOrderServiceRspBo.class);

        if(UocConstant.CREATED_RESULT.FAILED.equals(reqBo.getCreatedResult())){
            UocSaleOrderDo updateExtOrderIdDo = new UocSaleOrderDo();
            updateExtOrderIdDo.setOrderId(reqBo.getOrderId());
            updateExtOrderIdDo.setSaleOrderId(reqBo.getSaleOrderId());
            updateExtOrderIdDo.setCreatedResult(reqBo.getCreatedResult());
            updateExtOrderIdDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_XD_SB);
            updateExtOrderIdDo.setCancelReason(reqBo.getCancelReason());
            iUocSaleOrderModel.modifySaleOrderMain(updateExtOrderIdDo);

            //同时需要把整单的状态改为取消
            UocOrderDo updateBo = new UocOrderDo();
            updateBo.setOrderId(reqBo.getOrderId());
            updateBo.setOrderState(UocStateConstants.Order.ZD_SP_QX);
            iUocOrderModel.updateOrderState(updateBo);
            return rspBo;
        }

        // 更新销售单item裸价，税率，税金
        UocSaleOrderDo updatSaleItemBo = assembleUpdateDo(reqBo);
        iUocSaleOrderModel.updateSaleItemWithOutSkuId(updatSaleItemBo);

        // 更新销售单表外部订单id
        UocSaleOrderDo updateExtOrderIdDo = new UocSaleOrderDo();
        updateExtOrderIdDo.setOrderId(reqBo.getOrderId());
        updateExtOrderIdDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateExtOrderIdDo.setSaleOrderNoExt(reqBo.getOutOrderId());
        updateExtOrderIdDo.setCreatedResult(reqBo.getCreatedResult());
        iUocSaleOrderModel.modifySaleOrderMain(updateExtOrderIdDo);

        // 保存外部订单id和内部订单关系
        UocOrderQueryIndex index = new UocOrderQueryIndex();
        index.setId(IdUtil.nextId());
        index.setOrderId(reqBo.getOrderId());
        index.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        index.setObjId(reqBo.getSaleOrderId());
        index.setOutObjId(reqBo.getOutOrderId());
        iUocCommonModel.saveOrderQueryIndex(index);

        //出参
        rspBo.setOrderId(reqBo.getOrderId());
        rspBo.setSaleOrderId(reqBo.getSaleOrderId());
        rspBo.setOutOrderId(reqBo.getOutOrderId());

        return rspBo;
    }

    private UocSaleOrderDo assembleUpdateDo(UocResoveEsPreOrderServiceReqBo reqBo) {
        UocSaleOrderDo updateSaleItemBo = new UocSaleOrderDo();
        updateSaleItemBo.setOrderId(reqBo.getOrderId());
        updateSaleItemBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocResoveEsPreOrderServiceReqSkuBo> sku = reqBo.getSku();
        List<UocSaleOrderItem> saleItemList = new ArrayList<>();
        updateSaleItemBo.setSaleOrderItems(saleItemList);
        for (UocResoveEsPreOrderServiceReqSkuBo skuBo : sku) {
            UocSaleOrderItem item = new UocSaleOrderItem();
            item.setSkuExtSkuId(skuBo.getSkuId());
            item.setOrderId(reqBo.getOrderId());
            item.setSaleOrderId(reqBo.getSaleOrderId());

            item.setTax(new BigDecimal(skuBo.getTax()));
            item.setTaxPrice(skuBo.getTaxPrice());
            item.setNakedPrice(skuBo.getNakedPrice());
            saleItemList.add(item);
        }
        return updateSaleItemBo;
    }
}


