package com.tydic.dyc.oc.service.waitdone;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.waitdone.IUocWaitDoneModel;
import com.tydic.dyc.oc.model.waitdone.UocWaitDoneConfigDo;
import com.tydic.dyc.oc.model.waitdone.qrybo.UocWaitDoneConfigQryBo;
import com.tydic.dyc.oc.service.waitdone.bo.UocWaitDoneConfigBo;
import com.tydic.dyc.oc.service.waitdone.bo.UocWaitDoneQryReqBo;
import com.tydic.dyc.oc.service.waitdone.bo.UocWaitDoneQryRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题：类名称:UocWaitDoneQryServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/5/19 19:57
 * 作者 @author 尹栋梁
 */
@Slf4j
@HTServiceImpl
public class UocWaitDoneQryServiceImpl implements UocWaitDoneQryService{
    @Autowired
    private IUocWaitDoneModel iUocWaitDoneModel;

    @Autowired
    private IUocSaleOrderModel saleOrderModel;

    @Autowired
    private IUocOrderModel orderModel;

    @Override
    public UocWaitDoneQryRspBo qryWaitDoneList(UocWaitDoneQryReqBo uocWaitDoneQryReqBo) {
        UocWaitDoneQryRspBo rspBo = new UocWaitDoneQryRspBo();
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        List<UocWaitDoneConfigDo> uocWaitDoneConfigDos = iUocWaitDoneModel.qryWaitDoneList(UocRu.js(uocWaitDoneQryReqBo, UocWaitDoneConfigQryBo.class));
        if (CollectionUtil.isEmpty(uocWaitDoneConfigDos)) {
            return rspBo;
        }
        List<UocWaitDoneConfigBo> waitDoneConfigBoList = UocRu.jsl(uocWaitDoneConfigDos, UocWaitDoneConfigBo.class);
        List<UocSaleStakeholder> stakeholder = new ArrayList<>();
        String busiObjType = uocWaitDoneQryReqBo.getBusiObjType();
        if ("2".equals(busiObjType)) {
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setSaleOrderId(Long.valueOf(uocWaitDoneQryReqBo.getBusiObjId()));
            UocSaleOrderDo saleOrderMain = saleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
            stakeholder.add(saleOrderMain.getStakeholder());
            rspBo.setOrderNo(saleOrderMain.getSaleOrderNo());
        } else if ("1".equals(busiObjType)) {
            UocSaleOrderDo uocSaleOrderQryBo = new UocSaleOrderDo();
            uocSaleOrderQryBo.setOrderId(Long.valueOf(uocWaitDoneQryReqBo.getBusiObjId()));
            List<UocSaleOrderDo> uocSaleOrderDos = saleOrderModel.qrySaleOrderList(uocSaleOrderQryBo);
            stakeholder.addAll(uocSaleOrderDos.stream().map(UocSaleOrderDo::getStakeholder).collect(Collectors.toList()));
            UocOrderDo uocOrderDo = new UocOrderDo();
            uocOrderDo.setOrderId(Long.valueOf(uocWaitDoneQryReqBo.getBusiObjId()));
            UocOrderDo uocOrderDo1 = orderModel.qryOrderBy(uocOrderDo);
            rspBo.setOrderNo(uocOrderDo1.getOrderNo());
        }
        if (CollectionUtil.isNotEmpty(stakeholder)) {
            for (UocSaleStakeholder uocSaleStakeholder : stakeholder) {
                UocSaleStakeholder finalStakeholder = uocSaleStakeholder;
                waitDoneConfigBoList.forEach(uocWaitDoneConfigBo -> {
                    ArrayList<String> orgIds = new ArrayList<>();
                    Integer proFlag = uocWaitDoneConfigBo.getProFlag();
                    Integer purFlag = uocWaitDoneConfigBo.getPurFlag();
                    Integer supFlag = uocWaitDoneConfigBo.getSupFlag();
                    if (UocConstant.WATITDONE_FLAG.ON.equals(proFlag)) {
                        orgIds.add(finalStakeholder.getProId());
                    }
                    if (UocConstant.WATITDONE_FLAG.ON.equals(purFlag)) {
                        orgIds.add(finalStakeholder.getPurCompanyId());
                    }
                    if (UocConstant.WATITDONE_FLAG.ON.equals(supFlag)) {
                        orgIds.add(finalStakeholder.getSupId());
                    }
                    uocWaitDoneConfigBo.getOrgIds().addAll(orgIds);
                });
            }

        }
        rspBo.setWaitDoneConfigBoList(waitDoneConfigBoList);
        return rspBo;
    }
}
