/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.service.domainservice.UocDealAfOrderShopAddressService;
import com.tydic.dyc.oc.service.domainservice.bo.UocDealAfOrderShopAddressReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocDealAfOrderShopAddressRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocDealAfOrderShopAddressService"})
public class UocDealAfOrderShopAddressServiceImpl
implements UocDealAfOrderShopAddressService {
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    public static final Integer PICKWARE_TYPE = 40;

    @PostMapping(value={"dealAfOrderShopAddress"})
    public UocDealAfOrderShopAddressRspBo dealAfOrderShopAddress(@RequestBody UocDealAfOrderShopAddressReqBo reqBo) {
        UocDealAfOrderShopAddressRspBo rspBo = UocRu.success(UocDealAfOrderShopAddressRspBo.class);
        boolean pickwareTypeFlag = this.validataArg(reqBo);
        if (pickwareTypeFlag) {
            return rspBo;
        }
        List<UocAfOrder> afOrderList = this.getAfOrderList(reqBo);
        if (ObjectUtil.isEmpty(afOrderList)) {
            throw new BaseBusinessException("100001", "\u6839\u636e\u670d\u52a1\u5355ID\u67e5\u8be2\u552e\u540e\u5355\u4e3a\u7a7a");
        }
        Date now = new Date();
        UocOrdLogisticsRela logisticsRela = this.insertLogisticsRela(reqBo, afOrderList.get(0), now);
        this.updateAfOrderRela(afOrderList.get(0), logisticsRela, now);
        return rspBo;
    }

    private void updateAfOrderRela(UocAfOrder afOrder, UocOrdLogisticsRela logisticsRela, Date now) {
        UocAfOrderDo afOrderDo = new UocAfOrderDo();
        afOrderDo.setAfOrderId(afOrder.getAfOrderId());
        afOrderDo.setExtField1(logisticsRela.getContactId().toString());
        afOrderDo.setUpdateTime(now);
        this.iUocAfOrderModel.updateAfOrderMain(afOrderDo);
    }

    private List<UocAfOrder> getAfOrderList(UocDealAfOrderShopAddressReqBo reqBo) {
        UocAfOrderQryBo afOrderQryBo = new UocAfOrderQryBo();
        afOrderQryBo.setExtAfId(reqBo.getServiceId());
        return this.iUocAfOrderModel.getAfOrderList(afOrderQryBo);
    }

    private UocOrdLogisticsRela insertLogisticsRela(UocDealAfOrderShopAddressReqBo reqBo, UocAfOrder afOrder, Date now) {
        UocOrdLogisticsRela logisticsRela = new UocOrdLogisticsRela();
        logisticsRela.setContactId(IdUtil.nextId());
        logisticsRela.setOrderId(afOrder.getOrderId());
        logisticsRela.setContactAddress(reqBo.getReturnAdress());
        logisticsRela.setContactName(reqBo.getLinkedMan());
        logisticsRela.setContactMobile(reqBo.getLinkedMobile());
        logisticsRela.setCreateTime(now);
        return this.iUocOrderModel.createOrderLogisticsRela(logisticsRela);
    }

    private boolean validataArg(UocDealAfOrderShopAddressReqBo reqBo) {
        if (ObjectUtil.isNull((Object)reqBo)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getServiceId())) {
            throw new BaseBusinessException("100001", "\u552e\u540e\u5546\u5bb6\u6536\u4ef6\u5730\u5740\u5165\u5e93\u5931\u8d25\uff1a\u670d\u52a1\u5355\u53f7[serviceId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPickwareType())) {
            throw new BaseBusinessException("100001", "\u552e\u540e\u5546\u5bb6\u6536\u4ef6\u5730\u5740\u5165\u5e93\u5931\u8d25\uff1a\u5bc4\u4ef6\u65b9\u5f0f[pickwareType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.notEqual((Object)reqBo.getPickwareType(), (Object)PICKWARE_TYPE)) {
            return true;
        }
        if (ObjectUtil.equal((Object)reqBo.getPickwareType(), (Object)PICKWARE_TYPE) && ObjectUtil.isEmpty((Object)reqBo.getReturnAdress())) {
            throw new BaseBusinessException("100001", "\u552e\u540e\u5546\u5bb6\u6536\u4ef6\u5730\u5740\u5165\u5e93\u5931\u8d25\uff1a\u5bc4\u4ef6\u65b9\u5f0f\u4e3a\u5ba2\u6237\u53d1\u8d27\u65f6\u5bc4\u4ef6\u5730\u5740[returnAdress]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return false;
    }
}

