/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.order;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderCancelAdvanceOrderTask;
import com.tydic.dyc.oc.service.order.UocOrderCancelAdvanceOrderTaskUpdateService;
import com.tydic.dyc.oc.service.order.bo.UocCancelAdvanceOrderTaskBO;
import com.tydic.dyc.oc.service.order.bo.UocOrderCancelAdvanceOrderTaskUpdateReqBO;
import com.tydic.dyc.oc.service.order.bo.UocOrderCancelAdvanceOrderTaskUpdateRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.order.UocOrderCancelAdvanceOrderTaskUpdateService"})
public class UocOrderCancelAdvanceOrderTaskUpdateServiceImpl
implements UocOrderCancelAdvanceOrderTaskUpdateService {
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @PostMapping(value={"updateCancelAdvanceOrderTask"})
    public UocOrderCancelAdvanceOrderTaskUpdateRspBO updateCancelAdvanceOrderTask(@RequestBody UocOrderCancelAdvanceOrderTaskUpdateReqBO reqBO) {
        this.validateParam(reqBO);
        UocOrderCancelAdvanceOrderTaskUpdateRspBO rspBO = UocRu.success(UocOrderCancelAdvanceOrderTaskUpdateRspBO.class);
        Date now = new Date();
        if (ObjectUtil.isNotEmpty((Object)reqBO.getCancelAdvanceOrderTaskUpdateBOList())) {
            reqBO.getCancelAdvanceOrderTaskUpdateBOList().forEach(each -> {
                each.setDealTime(now);
                this.iUocOrderModel.updateCancelTaskStatus(UocRu.js(each, UocOrderCancelAdvanceOrderTask.class));
            });
        }
        if (ObjectUtil.isNotNull((Object)reqBO.getCancelAdvanceOrderTaskUpdateBO())) {
            UocCancelAdvanceOrderTaskBO bo = reqBO.getCancelAdvanceOrderTaskUpdateBO();
            bo.setDealTime(now);
            this.iUocOrderModel.updateCancelTaskStatus(UocRu.js(bo, UocOrderCancelAdvanceOrderTask.class));
        }
        return rspBO;
    }

    private void validateParam(UocOrderCancelAdvanceOrderTaskUpdateReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e0d\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCancelAdvanceOrderTaskUpdateBOList()) && ObjectUtil.isNull((Object)reqBO.getCancelAdvanceOrderTaskUpdateBO())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u53d6\u6d88\u4efb\u52a1\u5217\u8868\u548c\u53d6\u6d88\u4efb\u52a1\u5b9e\u4f53\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }
}

