package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocEvaluateQryBo;
import com.tydic.dyc.oc.model.order.sub.UocEvaluate;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEvaluateDealServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEvaluateDealServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题:UocEvaluateDealService
 * 说明:
 * 时间:2022/4/11 16:29
 *
 * @author 童垣杰
 */
@Slf4j
@HTServiceImpl
public class UocEvaluateDealServiceImpl implements UocEvaluateDealService {

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocEvaluateDealServiceRspBo dealEvaluate(UocEvaluateDealServiceReqBo reqBo) {
        //入参校验
        val(reqBo);

        Long objId = null;
        Long orderId = null;

        if ( StringUtils.isNotBlank(reqBo.getSaleOrderNo()) ) {
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setSaleOrderNo(reqBo.getSaleOrderNo());
            uocSaleOrderDo = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
            objId = uocSaleOrderDo.getSaleOrderId();
            orderId = uocSaleOrderDo.getOrderId();
        } else {
            objId = reqBo.getSaleOrderId();
            orderId = reqBo.getOrderId();
        }

        //查询是否存在
        UocEvaluateQryBo uocEvaluateQryBo = new UocEvaluateQryBo();
        uocEvaluateQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocEvaluateQryBo.setObjId(objId);
        uocEvaluateQryBo.setOrderId(orderId);
        List<UocEvaluate> uocEvaluates = iUocOrderModel.qryOrderEvaluateList(uocEvaluateQryBo);

        // 如果存在就修改状态，如果不存在就新增
        if (CollectionUtils.isNotEmpty(uocEvaluates)) {
            for (UocEvaluate uocEvaluate : uocEvaluates) {
                UocEvaluate uocEva = new UocEvaluate();
                uocEva.setId(uocEvaluate.getId());
                uocEva.setEvaluateState(reqBo.getEvaluateState());
                iUocOrderModel.updateOrderEvaluate(uocEva);
            }
            UocEvaluateDealServiceRspBo success = UocRu.success(UocEvaluateDealServiceRspBo.class);
            success.setOrderId(orderId);
            success.setSaleOrderId(objId);
            return success;
        }

        //如果不存在就新增
        //同步数据，创建时间会自动同步
        UocEvaluate uocEvaluate = new UocEvaluate();

        uocEvaluate.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocEvaluate.setId(IdUtil.nextId());

        uocEvaluate.setOrderId(orderId);
        uocEvaluate.setCreateOperId(reqBo.getUserId().toString());
        uocEvaluate.setEvaluateState(reqBo.getEvaluateState());
        uocEvaluate.setObjId(objId);

        iUocOrderModel.insertOrderEvaluate(uocEvaluate);

        return UocRu.success(UocEvaluateDealServiceRspBo.class);
    }

    private void val(UocEvaluateDealServiceReqBo reqBo){
        if (ObjectUtil.isNull(reqBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参不能为空");
        }
        if (StringUtils.isBlank(reqBo.getSaleOrderNo())) {
            if (reqBo.getOrderId() == null) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单ID不能为空");
            }
            if (reqBo.getSaleOrderId() == null) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单ID不能为空");
            }
        }
        if (reqBo.getEvaluateState() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "评价状态不能为空");
        }
    }
}
