package com.tydic.dyc.oc.service.order;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderCancelAdvanceOrderTask;
import com.tydic.dyc.oc.service.order.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@HTServiceImpl
public class UocOrderCancelAdvanceOrderTaskQryServiceImpl implements UocOrderCancelAdvanceOrderTaskQryService {

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocOrderCancelAdvanceOrderTaskQryRspBO qryCancelAdvanceOrderTask(UocOrderCancelAdvanceOrderTaskQryReqBO reqBO) {
        UocOrderCancelAdvanceOrderTaskQryRspBO rspBO = UocRu.success(UocOrderCancelAdvanceOrderTaskQryRspBO.class);
        UocOrderCancelAdvanceOrderTask advanceOrderTask = UocRu.js(reqBO, UocOrderCancelAdvanceOrderTask.class);
        advanceOrderTask.setStatusList(Arrays.asList(1, 3));
        List<UocOrderCancelAdvanceOrderTask> cancelAdvanceOrderTaskList = iUocOrderModel.getCancelAdvanceOrderTaskList(advanceOrderTask);
        if (ObjectUtil.isNotEmpty(cancelAdvanceOrderTaskList)) {
            cancelAdvanceOrderTaskList.forEach(each -> {
                UocOrderStakeholderQryBo qryBo = new UocOrderStakeholderQryBo();
                qryBo.setOrderId(each.getOrderId());
                List<UocOrderStakeholderQryBo> stakeholderQryBos = iUocOrderModel.qryStakeholderList(qryBo);
                if (ObjectUtil.isNotEmpty(stakeholderQryBos)) {
                    Map<Long, UocOrderStakeholderQryBo> stakeholderMap = stakeholderQryBos.stream().collect(Collectors.toMap(UocOrderStakeholderQryBo::getOrderId, o -> o, (k1, k2) -> k2));
                    each.setSupplierId(stakeholderMap.get(each.getOrderId()).getSupId());
                }
            });
        }
        rspBO.setCancelAdvanceOrderTaskBOList(UocRu.jsl(cancelAdvanceOrderTaskList, UocCancelAdvanceOrderTaskBO.class));
        return rspBO;
    }
}
