package com.tydic.dyc.oc.service.order;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderRelQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.service.order.bo.UocOrderRelUpdateReqBo;
import com.tydic.dyc.oc.service.order.bo.UocOrderRelUpdateRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题：UocOrderRelUpdateServiceImpl
 * 说明：订单关联更新API
 * 时间：2022/4/1 14:57
 *
 * @author 文乐
 */
@HTServiceImpl
public class UocOrderRelUpdateServiceImpl implements UocOrderRelUpdateService {

    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private UocEsSyncManager uocEsSyncManager;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocOrderRelUpdateRspBo dealRelUpdate(UocOrderRelUpdateReqBo reqBo) {
        // 参数校验
        validateArg(reqBo);
        // 查询是否已存在
        UocOrderRelQryBo uocOrderRelQryBo = new UocOrderRelQryBo();
        uocOrderRelQryBo.setObjId(reqBo.getObjId());
        uocOrderRelQryBo.setObjType(reqBo.getObjType());
//        uocOrderRelQryBo.setOrderId(reqBo.getOrderId());
        uocOrderRelQryBo.setRelType(reqBo.getRelType());
        UocOrderRel qryRelInfo = iUocOrderModel.qryRelInfo(uocOrderRelQryBo);

        UocOrderRel uocOrderRel = new UocOrderRel();
        if ( null != qryRelInfo ) {
            // 更新
            uocOrderRel.setId(qryRelInfo.getId());
            uocOrderRel.setRelStatus(reqBo.getRelState());
            uocOrderRel.setRelId(reqBo.getRelId());
            iUocOrderModel.dealRelUpdate(uocOrderRel);
        } else {
            // 创建
            uocOrderRel = UocRu.js(reqBo, UocOrderRel.class);
            uocOrderRel.setRelStatus(reqBo.getRelState());
            uocOrderRel.setId(IdUtil.nextId());
            iUocOrderModel.createRelInfo(uocOrderRel);
        }
        uocOrderRel.setRelType(reqBo.getRelType());
        uocOrderRel.setObjId(reqBo.getObjId());
        uocOrderRel.setObjType(reqBo.getObjType());
        syncEs(uocOrderRel, reqBo);
        return UocRu.success(UocOrderRelUpdateRspBo.class);
    }

    private void validateArg(UocOrderRelUpdateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能不为空");
        }
        if (null == reqBo.getObjId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "ObjId不能为空");
        }
        if (null == reqBo.getObjType()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "ObjType不能为空");
        }
        if (null == reqBo.getRelState()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "relState不能为空");
        }
        if (null == reqBo.getRelType()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "relType不能为空");
        }
    }

    private Map<String, Map<String, String>> getDic(Long sysTenantId) {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocDicConstant.REL_TYPE.P_CODE);
        pCodes.add(UocDicConstant.REL_STATUS.P_CODE);
        UocSysDictionaryQryBo reqBO = new UocSysDictionaryQryBo();
        reqBO.setPCodes(pCodes);
        reqBO.setSysTenantId(sysTenantId);
        return iUocSysDictionaryModel.getDictionaryMap(reqBO);
    }

    private void syncEs(UocOrderRel uocOrderRel, UocOrderRelUpdateReqBo reqBo) {
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        uocEsSyncManagerSaveDataReqBo.setObjId(uocOrderRel.getObjId());
        if (UocDicConstant.REL_TYPE.SERVICE_CHARGE.equals(uocOrderRel.getRelType())) {
            calTransactionRel(uocOrderRel, uocEsSyncManagerSaveDataReqBo);
        } else {
            List<UocOrderRel> uocOrderRelList = getUocRelInfo(reqBo);
            calOrderBillRel(uocOrderRelList, uocEsSyncManagerSaveDataReqBo, reqBo);
        }
        Boolean updateREsult = uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
        if (!updateREsult) {
            if (UocDicConstant.OBJ_TYPE.SALE.equals(reqBo.getObjType())) {
                //查询验收单
                List<UocInspOrderDo> uocInspOrderDoList = getUocInspOrderDo(reqBo);
                if (ObjectUtil.isNotEmpty(uocInspOrderDoList)) {
                    uocEsSyncManagerSaveDataReqBo.setObjId(uocInspOrderDoList.get(0).getInspOrderId());
                }
            }else if (UocDicConstant.OBJ_TYPE.INSPECTION.equals(reqBo.getObjType())) {
                uocEsSyncManagerSaveDataReqBo.setObjId(reqBo.getOrderId());
            }
            uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
        }
    }

    private List<UocInspOrderDo> getUocInspOrderDo(UocOrderRelUpdateReqBo reqBo) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setSaleOrderId(reqBo.getObjId());
        return iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
    }

    private void calOrderBillRel(List<UocOrderRel> uocOrderRelList, UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo, UocOrderRelUpdateReqBo reqBo) {

        if (uocOrderRelList.size() == 1) {
            if (UocDicConstant.REL_TYPE.UP_INVOICE.equals(uocOrderRelList.get(0).getRelType())
                    || UocDicConstant.REL_TYPE.COMMON_INVOICE.equals(uocOrderRelList.get(0).getRelType())) {
                UocOrderRel uocOrderRel = new UocOrderRel();
                uocOrderRel.setOrderId(reqBo.getOrderId());
                uocOrderRel.setRelType(UocDicConstant.REL_TYPE.UP_INVOICE.equals(uocOrderRelList.get(0).getRelType()) ? UocDicConstant.REL_TYPE.COMMON_INVOICE : UocDicConstant.REL_TYPE.UP_INVOICE);
                uocOrderRel.setObjId(reqBo.getObjId());
                uocOrderRel.setObjType(reqBo.getObjType());
                uocOrderRel.setRelStatus(UocDicConstant.REL_STATUS.UN_SUBMITTED);
                uocOrderRelList.add(uocOrderRel);
            }
        }

        JSONObject jsonObj = new JSONObject();
        List<Integer> relTypes = new ArrayList<>();
        List<String> relInfo = new ArrayList<>();
        List<String> relIds = new ArrayList<>();
        Map<String, Map<String, String>> dic = getDic(reqBo.getSysTenantId());
        Map<String, String> relTypeMap = dic.get(UocDicConstant.REL_TYPE.P_CODE);
        Map<String, String> relStatusMap = dic.get(UocDicConstant.REL_STATUS.P_CODE);
        for (UocOrderRel uocOrderRel : uocOrderRelList) {
            if (!StringUtils.isBlank(uocOrderRel.getRelId())) {
                relIds.add(uocOrderRel.getRelId());
            }
            relTypes.add(uocOrderRel.getRelType());
            relInfo.add(uocOrderRel.getRelStatus() + "," + uocOrderRel.getRelType());
            uocOrderRel.setRelStatusStr(relStatusMap.get(Convert.toStr(uocOrderRel.getRelStatus())));
            uocOrderRel.setRelTypeStr(relTypeMap.get(Convert.toStr(uocOrderRel.getRelType())));
        }
        jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_TYPE, relTypes);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_INFO, relInfo);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_ID, relIds);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.FSC_REL_INFO_BOS, uocOrderRelList);
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getInspOrderIndex());
    }

    private void calTransactionRel(UocOrderRel uocOrderRel, UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_TYPE, uocOrderRel.getRelType());
        jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_STATUS, uocOrderRel.getRelStatus());
        jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_INFO, uocOrderRel.getRelStatus() + "," + uocOrderRel.getRelType());
        jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_ID, uocOrderRel.getRelId());
        Map<String, Map<String, String>> dic = getDic(uocEsSyncManagerSaveDataReqBo.getSysTenantId());
        Map<String, String> relTypeMap = dic.get(UocDicConstant.REL_TYPE.P_CODE);
        Map<String, String> relStatusMap = dic.get(UocDicConstant.REL_STATUS.P_CODE);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_STATUS_STR, relStatusMap.get(Convert.toStr(uocOrderRel.getRelStatus())));
        jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_TYPE_STR, relTypeMap.get(Convert.toStr(uocOrderRel.getRelType())));
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getTransactionIndex());
    }

    private List<UocOrderRel> getUocRelInfo(UocOrderRelUpdateReqBo reqBo) {
        UocOrderRelQryBo qryBo = new UocOrderRelQryBo();
//        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setObjId(reqBo.getObjId());
        qryBo.setObjType(reqBo.getObjType());
        List<Integer> relType = new ArrayList<>();
        relType.add(UocDicConstant.REL_TYPE.UP_INVOICE);
        relType.add(UocDicConstant.REL_TYPE.COMMON_INVOICE);
        relType.add(UocDicConstant.REL_TYPE.CH_INVOICE);
        qryBo.setRelTypeList(relType);
        List<UocOrderRel> uocOrderRels = iUocOrderModel.qryListRelInfo(qryBo);
        if (CollectionUtils.isEmpty(uocOrderRels)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "获取结算订单关联关系为空");
        }
        return uocOrderRels;
    }
}
