package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.config.UocInitConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述: 〈领域服务-销售单任务提交 实现〉
 * @author : yuhao
 * @date : 2022/8/1 11:05
 */
@HTServiceImpl
public class UocCreateSaleProcInsUpdateStatusDomainServiceImpl implements UocCreateSaleProcInsUpdateStatusDomainService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private UocInitConfig uocInitConfig;


    @Override
    public UocCreateSaleProcInsUpdateStatusDomainServiceRspBo createSaleProcIns(UocCreateSaleProcInsUpdateStatusDomainServiceReqBo reqBo) {
       /* validateArg(reqBo);

        //根据流程id查询流程是否存在，不存在创建
        if (ObjectUtil.isNotEmpty(reqBo.getProcInstId())) {
            UocOrderProcInst qryInst = new UocOrderProcInst();
            qryInst.setProcInstId(reqBo.getProcInstId());
            qryInst.setOrderId(reqBo.getOrderId());
            List<UocOrderProcInst> uocOrderProcInsts = iUocSaleOrderModel.qryProcInsList(qryInst);
            if (ObjectUtil.isEmpty(uocOrderProcInsts)) {
                UocOrderProcInst createSaleProcIns = new UocOrderProcInst();
                createSaleProcIns.setProcInstId(reqBo.getProcInstId());
                createSaleProcIns.setOrderId(reqBo.getOrderId());
                createSaleProcIns.setObjId(reqBo.getSaleOrderId());
                createSaleProcIns.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                createSaleProcIns.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                iUocSaleOrderModel.createProInst(createSaleProcIns);
            }

        }

        //传了旧任务id，置为已办
        String oldTaskInstId = reqBo.getOldTaskInstId();
        if (ObjectUtil.isNotEmpty(oldTaskInstId)) {
            //判断当前状态，是否为未办理
            UocOrderTaskInst qryInst = new UocOrderTaskInst();
            qryInst.setOrderId(reqBo.getOrderId());
            qryInst.setTaskInstId(oldTaskInstId);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(qryInst);
            //不存在，报错
            if (ObjectUtil.isEmpty(uocOrderTaskInsts)) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "任务实例id(" + oldTaskInstId + ")不存在");
            }
            //已办，报错
            if (UocDicConstant.PROC_TASK_FINISHED.FINISHED.equals(uocOrderTaskInsts.get(0).getFinishTag())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "任务实例id(" + oldTaskInstId + ")已完结");
            }

            List<UocOrderTaskInst> updateList = new ArrayList<>();
            UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
            updateList.add(uocOrderTaskInst);
            uocOrderTaskInst.setOrderId(reqBo.getOrderId());
            uocOrderTaskInst.setTaskInstId(oldTaskInstId);
            //设置为已办
            iUocSaleOrderModel.updateProcTaskInstToFinished(updateList);
        }

        //保存新任务数据
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> nextTaskInfos = reqBo.getNextTaskInfos();
        if (ObjectUtil.isNotEmpty(nextTaskInfos)) {
            List<UocOrderTaskDeal> saveDealList = new ArrayList<>();
            List<UocOrderTaskInst> saveList = new ArrayList<>();
            for (UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo : nextTaskInfos) {
                UocOrderTaskInst taskBo = new UocOrderTaskInst();
                taskBo.setId(IdUtil.nextId());
                taskBo.setOrderId(reqBo.getOrderId());
                taskBo.setTaskInstId(nextTaskInfo.getTaskInstId());
                taskBo.setObjId(reqBo.getSaleOrderId());
                taskBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                taskBo.setProcState(nextTaskInfo.getTacheCode());
                taskBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                saveList.add(taskBo);

                String assignee = nextTaskInfo.getAssignee();
                List<String> candidates = nextTaskInfo.getCandidates();
                //处理人和候选人
                if (ObjectUtil.isNotEmpty(assignee)) {
                    UocOrderTaskDeal deal = assembleTaskDealObj(reqBo, nextTaskInfo);
                    deal.setDealId(assignee);
                    deal.setDealClass(UocDicConstant.TASK_DEAL_CLASS.ASSIGNEE);
                    saveDealList.add(deal);
                } else if (ObjectUtil.isNotEmpty(candidates)) {
                    for (String candidate : candidates) {
                        UocOrderTaskDeal deal = assembleTaskDealObj(reqBo, nextTaskInfo);
                        deal.setDealId(candidate);
                        deal.setDealClass(UocDicConstant.TASK_DEAL_CLASS.CANDIDATE);
                        saveDealList.add(deal);
                    }
                }

                String saleState = uocInitConfig.getStateByTachecode(nextTaskInfo.getTacheCode(), UocDicConstant.OBJ_TYPE.SALE);
                //环节，可能不变更状态，所以需要配置了状态才更新
                if(ObjectUtil.isNotEmpty(saleState)){
                    //更新销售单状态和环节编码
                    UocSaleOrderDo updateSaleDo = new UocSaleOrderDo();
                    updateSaleDo.setUpdateOperId(reqBo.getUserId().toString());
                    updateSaleDo.setOrderId(reqBo.getOrderId());
                    updateSaleDo.setSaleOrderId(reqBo.getSaleOrderId());
                    updateSaleDo.setSaleOrderState(saleState);
                    iUocSaleOrderModel.updateSaleStatusAndProCode(updateSaleDo);
                }
            }

            if (ObjectUtil.isNotEmpty(saveDealList)) {
                iUocSaleOrderModel.saveOrderTaskDealList(saveDealList);
            }
            iUocSaleOrderModel.saveProcTaskInst(saveList);
        }*/
        UocCreateSaleProcInsUpdateStatusDomainServiceRspBo success = UocRu.success(UocCreateSaleProcInsUpdateStatusDomainServiceRspBo.class);
        success.setSysTenantId(reqBo.getSysTenantId());
        return success;
    }

}


