package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocConfInspection;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.service.order.bo.UocInspectionConfigQryAbilityCommodityBo;
import com.tydic.dyc.oc.service.order.bo.UocQryInspectionConfigReqBo;
import com.tydic.dyc.oc.service.order.bo.UocQryInspectionConfigRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题:UocQryInspectionConfigServiceImpl
 * 说明:TODO
 * 时间:2022/4/11 11:21
 * 作者:代愿愿
 */
@HTServiceImpl
public class UocQryInspectionConfigServiceImpl implements UocQryInspectionConfigService {
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Override
    public UocQryInspectionConfigRspBo qryInspectionConfig(UocQryInspectionConfigReqBo reqBo) {
        UocConfInspection uocConfInspection = UocRu.js(reqBo,UocConfInspection.class);
        List<UocConfInspection> uocConfInspections = iUocOrderModel.qryInspectionConfigList(uocConfInspection);
        UocQryInspectionConfigRspBo rspBo =  UocRu.success(UocQryInspectionConfigRspBo.class);
        if(!CollectionUtils.isEmpty(uocConfInspections)) {
            // 转义
            List<String> pCodeList = new ArrayList<>();
            pCodeList.add(UocConstant.INSPECTION_BUSI_TYPE);
            pCodeList.add(UocConstant.INSPECTION_TYPE);
            UocSysDictionaryQryBo qryBo = new UocSysDictionaryQryBo();
            qryBo.setPCodes(pCodeList);
            qryBo.setSysTenantId(reqBo.getSysTenantId());
            Map<String, Map<String, String>> dictionaryMap = iUocSysDictionaryModel.getDictionaryMap(qryBo);
            Map<String, String> inspBusiType = dictionaryMap.get(UocConstant.INSPECTION_BUSI_TYPE);
            Map<String, String> inspType = dictionaryMap.get(UocConstant.INSPECTION_TYPE);
            //全品类
            if (UocConstant.INSPECTION_TYPE_ALL.equals(reqBo.getInspectionType())) {
                rspBo.setAllExcessPercent(uocConfInspections.get(0).getExcessPercent());
            } else {
                List<UocInspectionConfigQryAbilityCommodityBo> commodityDatas = UocRu.jsl(uocConfInspections,UocInspectionConfigQryAbilityCommodityBo.class);
                rspBo.setCommodityDatas(commodityDatas);
            }
            rspBo.setBusiTypeName(inspBusiType.get(reqBo.getBusiType().toString()));
            rspBo.setInspectionTypeName(inspType.get(reqBo.getInspectionType().toString()));
            rspBo.setInspectionType(reqBo.getInspectionType());
            rspBo.setBusiType(reqBo.getBusiType());
        }
        return rspBo;
    }
}
