/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocStateChngOrderCreateService;
import com.tydic.dyc.oc.service.domainservice.bo.UocStateChngOrderCreateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocStateChngOrderCreateReqShipBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocStateChngOrderCreateRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocStateChngOrderCreateService"})
public class UocStateChngOrderCreateServiceImpl
implements UocStateChngOrderCreateService {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel shipOrderModel;

    @PostMapping(value={"createStateChng"})
    public UocStateChngOrderCreateRspBo createStateChng(@RequestBody UocStateChngOrderCreateReqBo reqBo) {
        this.val(reqBo);
        UocStateChngOrderCreateRspBo rspBo = new UocStateChngOrderCreateRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        UocSaleOrderDo uocSaleOrderDo = this.getUocSaleOrderDo(reqBo);
        List<UocShipOrderItem> shipOrderItemList = this.getShipOrderItemList(reqBo);
        List<UocSaleOrderItem> uocSaleOrderItem = this.getUocSaleOrderItem(shipOrderItemList);
        Map<Long, UocSaleOrderItem> itemMap = uocSaleOrderItem.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        Map<Long, List<UocShipOrderItem>> shipOrderItemMap = shipOrderItemList.stream().collect(Collectors.groupingBy(UocShipOrderItem::getShipOrderId));
        this.checkEnableStateChngOrder(shipOrderItemMap, reqBo, itemMap);
        UocChngOrderDo uocChngOrderDo = this.convertChngOrderDo(reqBo, new Date(), uocSaleOrderDo, shipOrderItemMap, itemMap);
        this.iUocChngOrderModel.createChngOrder(uocChngOrderDo);
        Date now = new Date();
        Map<Long, UocShipOrderItem> uocShipOrderItemMap = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        uocChngOrderDo.getUocChngOrderObjList().forEach(x -> this.modifyShipAndOrderItemChngCount(reqBo, (UocChngOrderObj)x, now, uocShipOrderItemMap));
        rspBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
        rspBo.setShipOrderIdList(reqBo.getChngList().stream().map(UocStateChngOrderCreateReqShipBo::getShipOrderId).collect(Collectors.toList()));
        rspBo.setChngOrderNo(uocChngOrderDo.getChngOrderNo());
        rspBo.setSysTenantId(reqBo.getSysTenantId());
        return rspBo;
    }

    private void modifyShipAndOrderItemChngCount(UocStateChngOrderCreateReqBo reqBo, UocChngOrderObj uocChngOrderObj, Date now, Map<Long, UocShipOrderItem> uocShipOrderItemMap) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderId(reqBo.getOrderId());
        uocShipOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderDo.setShipOrderId(uocChngOrderObj.getShipOrderId());
        uocShipOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        uocShipOrderDo.setUpdateTime(now);
        ArrayList<UocShipOrderItem> uocShipOrderItemList = new ArrayList<UocShipOrderItem>();
        ArrayList<UocSaleOrderItem> uocSaleOrderItems = new ArrayList<UocSaleOrderItem>();
        uocChngOrderObj.getUocChngOrderItemObjList().forEach(x -> {
            if ("1".equals(x.getOtherChngValue())) {
                UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setShipOrderItemId(x.getShipOrderItemId());
                UocShipOrderItem uocShipOrderItem1 = (UocShipOrderItem)uocShipOrderItemMap.get(x.getShipOrderItemId());
                uocShipOrderItem.setChngingCount(uocShipOrderItem1.getArriveCount());
                uocShipOrderItemList.add(uocShipOrderItem);
                UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setChngingCount(uocShipOrderItem1.getArriveCount());
                uocSaleOrderItem.setSaleOrderItemId(uocShipOrderItem1.getSaleOrderItemId());
                uocSaleOrderItems.add(uocSaleOrderItem);
            } else {
                UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setShipOrderItemId(x.getShipOrderItemId());
                UocShipOrderItem uocShipOrderItem1 = (UocShipOrderItem)uocShipOrderItemMap.get(x.getShipOrderItemId());
                uocShipOrderItem.setChngingCount(uocShipOrderItem1.getRefuseCount());
                uocShipOrderItemList.add(uocShipOrderItem);
                UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setChngingCount(uocShipOrderItem1.getRefuseCount());
                uocSaleOrderItem.setSaleOrderItemId(uocShipOrderItem1.getSaleOrderItemId());
                uocSaleOrderItems.add(uocSaleOrderItem);
            }
        });
        uocShipOrderDo.setShipOrderItemBoList(uocShipOrderItemList);
        uocSaleOrderDo.setSaleOrderItems(uocSaleOrderItems);
        this.shipOrderModel.modifyShipOrderItemChngingCount(uocShipOrderDo);
        this.iUocSaleOrderModel.modifyBatchItemChngingCount(uocSaleOrderDo);
    }

    private List<UocSaleOrderItem> getUocSaleOrderItem(List<UocShipOrderItem> shipOrderItemList) {
        List<Long> itemIdList = shipOrderItemList.stream().map(UocShipOrderItem::getSaleOrderItemId).collect(Collectors.toList());
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(itemIdList);
        return this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    private void checkEnableStateChngOrder(Map<Long, List<UocShipOrderItem>> shipOrderItemList, UocStateChngOrderCreateReqBo reqBo, Map<Long, UocSaleOrderItem> itemMap) {
        for (UocStateChngOrderCreateReqShipBo uocStateChngOrderCreateReqShipBo : reqBo.getChngList()) {
            List<UocShipOrderItem> shipOrderItems = shipOrderItemList.get(uocStateChngOrderCreateReqShipBo.getShipOrderId());
            for (UocShipOrderItem shipOrderItem : shipOrderItems) {
                BigDecimal arriveCount = shipOrderItem.getArriveCount();
                BigDecimal refuseCount = shipOrderItem.getRefuseCount();
                UocSaleOrderItem uocSaleOrderItem = itemMap.get(shipOrderItem.getSaleOrderItemId());
                BigDecimal chngingCount = shipOrderItem.getChngingCount();
                if (chngingCount.compareTo(BigDecimal.ZERO) > 0) {
                    throw new BaseBusinessException("100001", "\u53d1\u8d27\u5355\u5b58\u5728\u672a\u5b8c\u7ed3\u7684\u5f02\u5e38\u53d8\u66f4");
                }
                if (arriveCount.compareTo(BigDecimal.ZERO) > 0 || refuseCount.compareTo(BigDecimal.ZERO) > 0 || uocSaleOrderItem.getAfterServingCount().compareTo(BigDecimal.ZERO) == 0) continue;
                throw new BaseBusinessException("100001", "\u53d1\u8d27\u5355\u72b6\u6001\u4e0d\u4e3a'\u59a5\u6295'\u3001'\u62d2\u6536'\u6216\u8005\u53d1\u8d27\u5355\u552e\u540e\u6570\u91cf\u4e0d\u4e3a0\u65f6,\u4e0d\u5141\u8bb8\u53d1\u8d77\u72b6\u6001\u53d8\u66f4");
            }
        }
    }

    private UocSaleOrderDo getUocSaleOrderDo(UocStateChngOrderCreateReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("101019", "\u67e5\u8be2\u9500\u552e\u5355\u4e3a\u7a7a");
        }
        return uocSaleOrderDo;
    }

    private List<UocShipOrderItem> getShipOrderItemList(UocStateChngOrderCreateReqBo reqBo) {
        ArrayList<UocShipOrderItem> shipOrderItems = new ArrayList<UocShipOrderItem>();
        for (UocStateChngOrderCreateReqShipBo uocStateChngOrderCreateReqShipBo : reqBo.getChngList()) {
            UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
            uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
            uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            uocShipOrderItemQryBo.setShipOrderId(uocStateChngOrderCreateReqShipBo.getShipOrderId());
            UocShipOrderDo uocShipOrderDo = this.shipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
            if (CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
                throw new BaseBusinessException("101006", "\u67e5\u8be2\u53d1\u8d27\u5355\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a");
            }
            shipOrderItems.addAll(uocShipOrderDo.getShipOrderItemBoList());
        }
        return shipOrderItems;
    }

    private UocChngOrderDo convertChngOrderDo(UocStateChngOrderCreateReqBo reqBo, Date now, UocSaleOrderDo uocSaleOrderDo, Map<Long, List<UocShipOrderItem>> shipOrderItemMap, Map<Long, UocSaleOrderItem> itemMap) {
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        uocChngOrderDo.setChngOrderId(IdUtil.nextId());
        uocSaleOrderDo.setSysTenantId(reqBo.getSysTenantId());
        uocChngOrderDo.setChngOrderNo(this.getChngOrderNo(uocSaleOrderDo));
        uocChngOrderDo.setChngOrderState("CHNG_CHNG_QRZ");
        uocChngOrderDo.setCancelTime(now);
        uocChngOrderDo.setCreateOperId(reqBo.getUserId().toString());
        uocChngOrderDo.setCreateOperName(reqBo.getName());
        uocChngOrderDo.setCreateOperMobile(reqBo.getCellphone());
        uocChngOrderDo.setCreateTime(now);
        uocChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.STATE);
        uocChngOrderDo.setTenantId(reqBo.getTenantId());
        uocChngOrderDo.setRemark(reqBo.getRemark());
        ArrayList<UocChngOrderObj> uocChngOrderObjList = new ArrayList<UocChngOrderObj>();
        UocChngOrderObj uocChngOrderObj = new UocChngOrderObj();
        uocChngOrderObj.setOrderId(reqBo.getOrderId());
        uocChngOrderObj.setChngOrderObjId(IdUtil.nextId());
        uocChngOrderObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
        uocChngOrderObj.setChngType(UocConstant.BUSI_TYPE.STATE);
        uocChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
        uocChngOrderObj.setCreateTime(now);
        uocChngOrderObj.setCreateOperId(reqBo.getUserId().toString());
        uocChngOrderObj.setChngFee(BigDecimal.ZERO);
        ArrayList<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<UocChngOrderItemObj>();
        reqBo.getChngList().forEach(x -> {
            List shipOrderItems = (List)shipOrderItemMap.get(x.getShipOrderId());
            for (UocShipOrderItem shipOrderItem : shipOrderItems) {
                UocSaleOrderItem uocSaleOrderItem = (UocSaleOrderItem)((Object)((Object)itemMap.get(shipOrderItem.getSaleOrderItemId())));
                BigDecimal shipItemMoney = uocSaleOrderItem.getSalePrice().multiply(shipOrderItem.getSendCount());
                if ("1".equals(x.getChngState())) {
                    uocChngOrderObj.setChngFee(uocChngOrderObj.getChngFee().add(shipItemMoney));
                } else {
                    uocChngOrderObj.setChngFee(uocChngOrderObj.getChngFee().subtract(shipItemMoney));
                }
                UocChngOrderItemObj uocChngOrderItemObj = new UocChngOrderItemObj();
                uocChngOrderItemObj.setSaleOrderItemId(shipOrderItem.getSaleOrderItemId());
                uocChngOrderItemObj.setId(IdUtil.nextId());
                uocChngOrderItemObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
                uocChngOrderItemObj.setChngOrderObjId(uocChngOrderObj.getChngOrderObjId());
                uocChngOrderItemObj.setShipOrderItemId(shipOrderItem.getShipOrderItemId());
                uocChngOrderItemObj.setSaleOrderItemId(uocSaleOrderItem.getSaleOrderItemId());
                uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
                uocChngOrderItemObj.setCreateTime(now);
                uocChngOrderItemObj.setCreateOperId(reqBo.getUserId().toString());
                uocChngOrderItemObj.setChngType(UocConstant.BUSI_TYPE.STATE);
                uocChngOrderItemObj.setOtherChngValue(x.getChngState());
                uocChngOrderItemObj.setChngState(shipOrderItem.getShipItemState());
                uocChngOrderItemObjList.add(uocChngOrderItemObj);
            }
        });
        uocChngOrderObj.setUocChngOrderItemObjList(uocChngOrderItemObjList);
        uocChngOrderObjList.add(uocChngOrderObj);
        uocChngOrderDo.setUocChngOrderObjList(uocChngOrderObjList);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> orderAccessoryBoList = UocRu.jsl(reqBo.getOrderAccessoryBoList(), UocOrderAccessory.class);
            orderAccessoryBoList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setObjId(uocChngOrderDo.getChngOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setCreateTime(now);
                uocOrderAccessory.setAttachmentType(UocDicConstant.ACCESSORY_TYPE.CREATE_ORDER);
            });
            uocChngOrderDo.setOrderAccessoryBoList(orderAccessoryBoList);
        }
        return uocChngOrderDo;
    }

    private String getChngOrderNo(UocSaleOrderDo uocSaleOrderDo) {
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.STATE);
        uocChngOrderQryBo.setOrderSource(uocSaleOrderDo.getOrderSource());
        uocChngOrderQryBo.setSysTenantId(uocSaleOrderDo.getSysTenantId());
        UocChngOrderDo uocChngOrderDo = this.iUocChngOrderModel.getChngOrderNo(uocChngOrderQryBo);
        return uocChngOrderDo.getChngOrderNo();
    }

    private void val(UocStateChngOrderCreateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getChngList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u53d8\u66f4\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocStateChngOrderCreateReqShipBo uocStateChngOrderCreateReqShipBo : reqBo.getChngList()) {
            if (ObjectUtil.isEmpty((Object)uocStateChngOrderCreateReqShipBo.getShipOrderId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u53d1\u8d27\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtil.isEmpty((Object)uocStateChngOrderCreateReqShipBo.getChngState())) continue;
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u53d8\u66f4\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

