package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocConfSupplier;
import com.tydic.dyc.oc.service.order.bo.*;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocMoneyUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * 标题：类名称:UocUpdateOrderTaskInstanceServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/8 15:29
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocOrderQuotaAllocationDealBusiServiceImpl implements UocOrderQuotaAllocationDealBusiService{

    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Override
    public UocProOrderQuotaAllocationDealRspBo dealOrderQuotaAllocation(UocProOrderQuotaAllocationDealReqBo reqBo) {
        UocProOrderQuotaAllocationDealRspBo rsp = UocRu.success(UocProOrderQuotaAllocationDealRspBo.class);
        if (3 == reqBo.getOperateType()) {
            UocConfSupplier supplierPO = new UocConfSupplier();
            supplierPO.setSupNo(reqBo.getSupNo());
            supplierPO.setConfId(reqBo.getConfId());
            supplierPO.setSysTenantId(reqBo.getSysTenantId());
            try {
                supplierPO.setOrderLimit(UocMoneyUtil.bigDecimal2Long(reqBo.getOrderQuota()));
            } catch (Exception e) {
                e.printStackTrace();
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象转换金额有误");
            }
            supplierPO.setOperatingTime(new Date());
            supplierPO.setOperatorId(String.valueOf(reqBo.getUserId()));
            supplierPO.setOperatorName(reqBo.getUsername());
            supplierPO.setLimitStatus(1);
            int i = iUocOrderModel.updateConfSupplierById(supplierPO);
            if (1 != i) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_SYSTEM_EXCEPTION, "删除配置失败");
            }
            return rsp;
        }
        if (2 == reqBo.getOperateType()) {
            UocConfSupplier uocConfSupplier = iUocOrderModel.getConfSupplierModelById(reqBo.getConfId());
            if (null == uocConfSupplier || 1 == uocConfSupplier.getLimitStatus()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_SYSTEM_EXCEPTION, "该电商的配置已经删除，请刷新列表。");
            }
            UocConfSupplier supplierPO = new UocConfSupplier();
            supplierPO.setSupNo(reqBo.getSupNo());
            supplierPO.setConfId(reqBo.getConfId());
            supplierPO.setSysTenantId(reqBo.getSysTenantId());

            try {
                supplierPO.setOrderLimit(UocMoneyUtil.bigDecimal2Long(reqBo.getOrderQuota()));
            } catch (Exception e) {
                e.printStackTrace();
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象转换金额有误");
            }
            supplierPO.setOperatingTime(new Date());
            supplierPO.setOperatorId(String.valueOf(reqBo.getUserId()));
            supplierPO.setOperatorName(reqBo.getUsername());
            supplierPO.setLimitStatus(0);
            iUocOrderModel.updateConfSupplierById(supplierPO);
        } else if (1 == reqBo.getOperateType()) {
            UocConfSupplier supplierPO = new UocConfSupplier();
            supplierPO.setSysTenantId(reqBo.getSysTenantId());
            supplierPO.setSupNo(reqBo.getSupNo());
            supplierPO.setBusinessTypeCode(reqBo.getBusinessTypeCode());
            UocConfSupplier supplierPO1 = iUocOrderModel.getConfSupplierModelBy(supplierPO);
            try {
                supplierPO.setOrderLimit(UocMoneyUtil.bigDecimal2Long(reqBo.getOrderQuota()));
            } catch (Exception e) {
                e.printStackTrace();
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象转换金额有误");
            }
            supplierPO.setSupName(reqBo.getSupplierName());
            supplierPO.setOperatingTime(new Date());
            supplierPO.setOperatorId(String.valueOf(reqBo.getUserId()));
            supplierPO.setOperatorName(reqBo.getUsername());
            supplierPO.setSysAttr(UocConstant.SYS_ATTR.CUSTOMIZE);
            supplierPO.setLimitStatus(0);
            if (null != supplierPO1) {
                if (0 == supplierPO1.getLimitStatus()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_SYSTEM_EXCEPTION, "该电商的配置已经删除，请刷新列表。");
                }
                supplierPO.setConfId(supplierPO1.getConfId());
                iUocOrderModel.updateConfSupplierById(supplierPO);
            } else {
                supplierPO.setConfId(IdUtil.nextId());
                supplierPO.setSysTenantName(reqBo.getSysTenantName());
                iUocOrderModel.addConfSupplier(supplierPO);
            }
        }
        return rsp;
    }
}
