package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:UocChngOrderConfirmOrRefuseServiceImpl
 * 说明:数量变更确认/拒绝 实现
 * 时间:2022/3/9 20:42
 * 作者:罗有
 */

@HTServiceImpl
public class UocChngOrderConfirmOrRefuseServiceImpl implements UocChngOrderConfirmOrRefuseService {

	@Autowired
	private IUocChngOrderModel iUocChngOrderModel;
	@Autowired
	private IUocShipOrderModel iUocShipOrderModel;
	@Autowired
	private IUocSaleOrderModel iUocSaleOrderModel;
	@Autowired
	private IUocInspOrderModel iUocInspOrderModel;

	private static final Integer OP_FLAG_CONFIRM = 1;

	private static final Integer OP_FLAG_REFUSE = 0;
	@Autowired
	private IUocCommonModel iUocCommonModel;


	@Override
	public UocChngOrderConfirmOrRefuseRspBo dealConfirmOrRefuse(UocChngOrderConfirmOrRefuseReqBo reqBo) {
		UocChngOrderConfirmOrRefuseRspBo rsp = UocRu.success(UocChngOrderConfirmOrRefuseRspBo.class);

		validateArg(reqBo);
		String operId = reqBo.getUserId().toString();
		Date now = new Date();
		//查询变更明细
		List<UocChngOrderItemObj> uocChngOrderItemObjList = getListChngOrderItemObj(reqBo);
		//批量更新变更主体信息:主要是uoc_chng_order状态
		iUocChngOrderModel.modifyBatchChngOrderState(convertChngOrderDo(reqBo, now, operId));
		Map<Integer, List<UocChngOrderItemObj>> chngItems = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(obj -> obj.getChngType()));

		List<UocChngOrderItemObj> uocChngNums = chngItems.get(UocConstant.BUSI_TYPE.NUM);
		List<UocChngOrderItemObj> uocChngState = chngItems.get(UocConstant.BUSI_TYPE.STATE);

		  //数量变更
		  if (!CollectionUtil.isEmpty(uocChngNums)) {
				if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
					confirm(reqBo, operId, now, uocChngNums);
				}
				if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
					refuse(reqBo, operId, now, uocChngNums);
				}
		  }

		  //状态变更
		  if(!CollectionUtil.isEmpty(uocChngState)) {
				if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
					confirmStat(reqBo, operId, now, uocChngState);
       				getShipTaskInsts(reqBo, rsp);
					getSaleOrderInfo(reqBo, rsp);
				}
				if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
					refuse(reqBo, operId, now, uocChngState);
				}
		  }

		reqBo.getChngOrderList().forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
			// 提交任务
			UocCommonDo uocCommonDo = new UocCommonDo();
			List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
			UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
			taskBo.setTaskId(uocChngOrderConfirmOrRefuseReqItemBo.getTaskId());
			taskBos.add(taskBo);
			uocCommonDo.setCompleteTaskInfos(taskBos);
			uocCommonDo.setUserId(11111l);
			uocCommonDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
			uocCommonDo.setSysTenantId(reqBo.getSysTenantId());
			uocCommonDo.setSysTenantName(reqBo.getSysTenantName());
			iUocCommonModel.dealTask(uocCommonDo);
		});

		dealMap(reqBo, now);
		//封装出参对象 (查询销售单明细 ，验收单明细)
		buildSyncRsp(reqBo,rsp,uocChngOrderItemObjList);
		rsp.setSysTenantId(reqBo.getSysTenantId());
		return rsp;
	}
	private void buildSyncRsp(UocChngOrderConfirmOrRefuseReqBo reqBo, UocChngOrderConfirmOrRefuseRspBo rspBo, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
		List<Long> saleOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList());
		List<Long> shipOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).collect(Collectors.toList());

		UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
		uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIds);
		uocSaleOrderItemQryBo.setSysTenantId(reqBo.getSysTenantId());
		List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
		rspBo.getSaleOrderIdList().addAll(saleOrderItemList.stream().map(x -> x.getSaleOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));

		UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
		uocShipOrderItemQryBo.setShipOrderItemIdList(shipOrderItemIds);
		uocShipOrderItemQryBo.setSysTenantId(reqBo.getSysTenantId());
		List<UocShipOrderItem> shipOrderItemList = iUocShipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);
		rspBo.getShipOrderIdList().addAll(shipOrderItemList.stream().map(x -> x.getShipOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));


		reqBo.getChngOrderList().forEach(chngOrder->{
			UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
			uocInspOrderQryBo.setOrderId(chngOrder.getOrderId());
			uocInspOrderQryBo.setSysTenantId(reqBo.getSysTenantId());
			List<UocInspOrderDo> listInspOrder = iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
			if (!CollectionUtils.isEmpty(listInspOrder)){
				listInspOrder.forEach(inspOrder->rspBo.getInspOrderIdList().add(inspOrder.getInspOrderId()+"-"+inspOrder.getOrderId()));
			}
		});

		reqBo.getChngOrderList().forEach(x->{
			rspBo.getChngOrderIdList().add(x.getChngOrderId() + "-" + x.getOrderId());
		});
	}

	private void getSaleOrderInfo(UocChngOrderConfirmOrRefuseReqBo reqBo, UocChngOrderConfirmOrRefuseRspBo rsp) {
		List<UocChngOrderConfirmOrRefuseSaleTaskInstBo> saleOrderTaskInstBoList = new ArrayList<>();
		List<Long> chngOrderIds = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList());
		UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
		uocChngOrderObjQryBo.setChngOrderIdList(chngOrderIds);
		uocChngOrderObjQryBo.setSysTenantId(reqBo.getSysTenantId());
		UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
		uocChngOrderItemObjQryBo.setChngOrderIdList(chngOrderIds);
		uocChngOrderItemObjQryBo.setSysTenantId(reqBo.getSysTenantId());
		List<UocChngOrderItemObj> listChngOrderItemObj = iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
		Map<Long, List<UocChngOrderItemObj>> chngOrderItemMaps = listChngOrderItemObj.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getChngOrderId));


		List<UocChngOrderObj> listChngOrderObjWithOutItem = iUocChngOrderModel.getListChngOrderObjWithOutItem(uocChngOrderObjQryBo);
		if (CollectionUtil.isEmpty(listChngOrderObjWithOutItem)) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "查询变更对象为空");
		}
		for (UocChngOrderObj uocChngOrderObj : listChngOrderObjWithOutItem) {
			Long saleOrderId = uocChngOrderObj.getSaleOrderId();
			UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
			uocSaleOrderDo.setSaleOrderId(saleOrderId);
			uocSaleOrderDo.setOrderId(uocChngOrderObj.getOrderId());
			uocSaleOrderDo.setSysTenantId(reqBo.getSysTenantId());
			UocSaleOrderDo saleOrderMain = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
			if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(saleOrderMain.getOrderSource()) && UocConstant.BUSI_TYPE.STATE.equals(uocChngOrderObj.getChngType())) {
				// 妥投到拒收
				Boolean flag = null;
				UocOrderTaskInst uocSaleOrderTaskInst = new UocOrderTaskInst();
				uocSaleOrderTaskInst.setOrderId(uocChngOrderObj.getOrderId());
				uocSaleOrderTaskInst.setObjId(saleOrderId);
				uocSaleOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SALE);
				uocSaleOrderTaskInst.setFinishTag(0);
				uocSaleOrderTaskInst.setSysTenantId(reqBo.getSysTenantId());
				List<UocOrderTaskInst> uocSaleOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(uocSaleOrderTaskInst);
				if (CollectionUtil.isEmpty(uocSaleOrderTaskInsts)) {
					return;
				}
				UocOrderTaskInst uocSaleOrderTaskInst1 = uocSaleOrderTaskInsts.get(0);
				List<UocChngOrderItemObj> uocChngOrderItemObjs = chngOrderItemMaps.get(uocChngOrderObj.getChngOrderId());
				if (CollectionUtil.isEmpty(uocChngOrderItemObjs)) {
					break;
				}
				if (UocDicConstant.STATE_CHNG.JUSHOU.equals(uocChngOrderItemObjs.get(0).getOtherChngValue())) {
					UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
					uocShipOrderQryBo.setSaleOrderId(saleOrderId);
					uocShipOrderQryBo.setOrderId(uocChngOrderObj.getOrderId());
					uocShipOrderQryBo.setSysTenantId(reqBo.getSysTenantId());
					List<UocShipOrderDo> listShipOrder = iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
					if (CollectionUtil.isEmpty(listShipOrder)) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "通过销售单查询发货单列表为空");
					}

					for (UocShipOrderDo uocShipOrderDo : listShipOrder) {
						UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
						uocOrderTaskInst.setOrderId(uocChngOrderObj.getOrderId());
						uocOrderTaskInst.setObjId(uocShipOrderDo.getShipOrderId());
						uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
						uocOrderTaskInst.setFinishTag(0);
						uocOrderTaskInst.setSysTenantId(reqBo.getSysTenantId());
						List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
						if (CollectionUtil.isEmpty(uocOrderTaskInsts)) {
							return;
						}
						UocOrderTaskInst uocOrderTaskInst1 = uocOrderTaskInsts.get(0);
						String procState = uocOrderTaskInst1.getProcState();
						if (UocStateConstants.SaleOrder.XS_YS_YS.equals(procState)) {
							flag = true;
						} else {
							flag = false;
							break;
						}
					}
					flag = Optional.ofNullable(flag).orElse(Boolean.FALSE);
					if (flag) {
						String taskId = uocSaleOrderTaskInst1.getTaskInstId();
						UocChngOrderConfirmOrRefuseSaleTaskInstBo saleTaskinfo = new UocChngOrderConfirmOrRefuseSaleTaskInstBo();
						saleTaskinfo.setTaskId(taskId);
						saleTaskinfo.setStepId(uocSaleOrderTaskInst1.getProcState());
						saleTaskinfo.setSaleOrderId(saleOrderId);
						saleTaskinfo.setOrderId(uocChngOrderObj.getOrderId());
						saleOrderTaskInstBoList.add(saleTaskinfo);
					}
				}
				// 拒收到妥投
				if (UocDicConstant.STATE_CHNG.TUOTOU.equals(uocChngOrderItemObjs.get(0).getOtherChngValue())) {
					String procState = uocSaleOrderTaskInst1.getProcState();
					if (UocStateConstants.SaleOrder.XS_DH_JS.equals(procState)) {
						String taskId = uocSaleOrderTaskInst1.getTaskInstId();
						UocChngOrderConfirmOrRefuseSaleTaskInstBo saleTaskinfo = new UocChngOrderConfirmOrRefuseSaleTaskInstBo();
						saleTaskinfo.setTaskId(taskId);
						saleTaskinfo.setStepId(uocSaleOrderTaskInst1.getProcState());
						saleTaskinfo.setSaleOrderId(saleOrderId);
						saleTaskinfo.setOrderId(uocChngOrderObj.getOrderId());
						saleOrderTaskInstBoList.add(saleTaskinfo);
					}
				}
			}
		}
		rsp.setSaleOrderTaskInstList(saleOrderTaskInstBoList);
	}

	private void getShipTaskInsts(UocChngOrderConfirmOrRefuseReqBo reqBo, UocChngOrderConfirmOrRefuseRspBo rsp) {
		List<UocChngOrderConfirmOrRefuseShipTaskInstBo> shipTaskInstBoList = new ArrayList<>();
		List<Long> chngOrderIds = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList());
		UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
		uocChngOrderObjQryBo.setChngOrderIdList(chngOrderIds);
		uocChngOrderObjQryBo.setSysTenantId(reqBo.getSysTenantId());
		List<UocChngOrderObj> listChngOrderObjWithOutItem = iUocChngOrderModel.getListChngOrderObjWithOutItem(uocChngOrderObjQryBo);

		listChngOrderObjWithOutItem.forEach(x->{
			UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
			uocOrderTaskInst.setOrderId(x.getOrderId());
			uocOrderTaskInst.setObjId(x.getShipOrderId());
			uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
			uocOrderTaskInst.setFinishTag(0);
			uocOrderTaskInst.setSysTenantId(reqBo.getSysTenantId());
			List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
			if (CollectionUtil.isEmpty(uocOrderTaskInsts)) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询发货单任务信息为空");
			}
			UocOrderTaskInst uocOrderTaskInst1 = uocOrderTaskInsts.get(0);
			String taskInstId = uocOrderTaskInst1.getTaskInstId();
			String procState = uocOrderTaskInst1.getProcState();
			UocChngOrderConfirmOrRefuseShipTaskInstBo uocChngOrderConfirmOrRefuseShipTaskInstBo = new UocChngOrderConfirmOrRefuseShipTaskInstBo();
			uocChngOrderConfirmOrRefuseShipTaskInstBo.setShipOrderId(x.getShipOrderId());
			uocChngOrderConfirmOrRefuseShipTaskInstBo.setTaskId(taskInstId);
			uocChngOrderConfirmOrRefuseShipTaskInstBo.setStepId(procState);
			uocChngOrderConfirmOrRefuseShipTaskInstBo.setChngOrderId(x.getChngOrderId());
			uocChngOrderConfirmOrRefuseShipTaskInstBo.setOrderId(x.getOrderId());
			shipTaskInstBoList.add(uocChngOrderConfirmOrRefuseShipTaskInstBo);
		});
		rsp.setShipTaskInstList(shipTaskInstBoList);
	}

	private void confirmStat(UocChngOrderConfirmOrRefuseReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
		Map<String, List<UocChngOrderItemObj>> chngOrderItemMaps = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getOtherChngValue));
		List<UocChngOrderItemObj> uocChngOrderItemObjsJS = chngOrderItemMaps.get(UocDicConstant.STATE_CHNG.JUSHOU);
		List<UocChngOrderItemObj> uocChngOrderItemObjsTT = chngOrderItemMaps.get(UocDicConstant.STATE_CHNG.TUOTOU);
		if (CollectionUtil.isNotEmpty(uocChngOrderItemObjsJS)) {
			UocShipOrderDo uocShipOrderDo = convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjsJS);
			UocSaleOrderDo uocSaleOrderDo = convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjsJS);
			// 增加sale_order_item中拒收的数量，变更中数量变为0
			iUocSaleOrderModel.modifyItemRefuseCountConfirm(uocSaleOrderDo);
			iUocShipOrderModel.modifyItemRefuseCountConfirm(uocShipOrderDo);
		}
		if (CollectionUtil.isNotEmpty(uocChngOrderItemObjsTT)) {
			UocShipOrderDo uocShipOrderDo = convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjsTT);
			UocSaleOrderDo uocSaleOrderDo = convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjsTT);
			// 增加到货的数量
			iUocSaleOrderModel.modifyItemArriveCountConfirm(uocSaleOrderDo);
			iUocShipOrderModel.modifyItemArriveCountConfirm(uocShipOrderDo);
		}

		//修改发货单状态
		List<Long> shipItemIdList = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).distinct().collect(Collectors.toList());
		UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
		uocShipOrderItemQryBo.setShipOrderItemIdList(shipItemIdList);
		uocShipOrderItemQryBo.setSysTenantId(reqBo.getSysTenantId());
		List<UocShipOrderItem> shipOrderItemList = iUocShipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);

		// 改变发货单状态
		if (CollectionUtil.isNotEmpty(shipOrderItemList)) {
			Map<Long, Long> shipItemToShipIdMaps = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, UocShipOrderItem::getShipOrderId));
			uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
				UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
				Long shipOrderItemId = uocChngOrderItemObj.getShipOrderItemId();
				Long shipOrderId = shipItemToShipIdMaps.get(shipOrderItemId);
				uocShipOrderDo.setOrderId(uocChngOrderItemObj.getOrderId());
				uocShipOrderDo.setShipOrderId(shipOrderId);
				uocShipOrderDo.setSysTenantId(reqBo.getSysTenantId());
				iUocShipOrderModel.modifyStatChngShipStatus(uocShipOrderDo);
			});
		}


	}

	private void refuse(UocChngOrderConfirmOrRefuseReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
		iUocShipOrderModel.modifyItemChngCountRefuse(convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
		iUocSaleOrderModel.modifyBatchItemChngCountRefuse(convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
	}

	private void confirm(UocChngOrderConfirmOrRefuseReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
		//变更发货明细数量，通过ShipOrderItemId找uoc_ship_order_item：退货数量增加，验收，到货数量减少
		iUocShipOrderModel.modifyItemReturnCountConfirm(convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
		//变更各销售明细数量，通过SaleOrderItemId找uoc_sale_order_item：退货数量增加，验收，变更中，到货数量减少
		uocChngOrderItemObjList.forEach(obj->{iUocSaleOrderModel.modifyBatchItemReturnCountConfirm(convertSaleItemOrderDo(now, operId, obj,reqBo.getSysTenantId()));});
		//变更各验收数量
		acceptanceRevise(uocChngOrderItemObjList,reqBo.getSysTenantId());
	}


	/**
	 * 查询执行单信息
	 */
	private UocSaleOrderDo convertSaleOrderDo(UocChngOrderConfirmOrRefuseReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
		UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
		uocSaleOrderDo.setUpdateOperId(operId);
		uocSaleOrderDo.setUpdateTime(now);
		uocSaleOrderDo.setOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList()));
		uocSaleOrderDo.setSaleOrderItemsIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList()));
		uocSaleOrderDo.setSysTenantId(reqBo.getSysTenantId());
		return uocSaleOrderDo;
	}

	/**
	 * 查询发货单信息信息
	 */
	private UocShipOrderDo convertShipOrderDo(UocChngOrderConfirmOrRefuseReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
		List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
		UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
		uocShipOrderDo.setShipOrderItemIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).collect(Collectors.toList()));
		uocShipOrderDo.setOrderIdList(orderIdList);
		uocShipOrderDo.setUpdateTime(now);
		uocShipOrderDo.setUpdateOperId(operId);
		uocShipOrderDo.setSysTenantId(reqBo.getSysTenantId());
		return uocShipOrderDo;
	}

	/**
	 * 组装变更单信息
	 */
	private List<UocChngOrderDo> convertChngOrderDo(UocChngOrderConfirmOrRefuseReqBo reqBo, Date now, String operId) {
		String state = getState(reqBo);
		return reqBo.getChngOrderList().stream().map(uocChngOrderConfirmOrRefuseReqItemBo -> {
			UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
			uocChngOrderDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
			uocChngOrderDo.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
			uocChngOrderDo.setChngOrderState(state);
			uocChngOrderDo.setUpdateTime(now);
			uocChngOrderDo.setUpdateOperId(operId);
			uocChngOrderDo.setUpdateOperName(reqBo.getName());
			uocChngOrderDo.setRejectReason(reqBo.getRejectRemark());
			uocChngOrderDo.setSysTenantId(reqBo.getSysTenantId());
			uocChngOrderDo.setSysTenantName(reqBo.getSysTenantName());
			return uocChngOrderDo;
		}).collect(Collectors.toList());
	}

	/**
	 * 获取对应状态
	 */
	private String getState(UocChngOrderConfirmOrRefuseReqBo reqBo) {
		if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
			return UocStateConstants.ChngOrder.NUM.CHNG_CHNG_JJ;
		}
		return UocStateConstants.ChngOrder.NUM.CHNG_CHNG_QR;
	}

	private UocSaleOrderDo convertSaleItemOrderDo(Date now, String operId, UocChngOrderItemObj uocChngOrderItem, Long sysTenantId) {
		UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
		uocSaleOrderDo.setUpdateOperId(operId);
		uocSaleOrderDo.setUpdateTime(now);
		uocSaleOrderDo.setChngingCount(uocChngOrderItem.getChngNum().negate());
		uocSaleOrderDo.setOrderId(uocChngOrderItem.getOrderId());
		uocSaleOrderDo.setSaleOrderId(uocChngOrderItem.getSaleOrderItemId());
		uocSaleOrderDo.setSysTenantId(sysTenantId);
		return uocSaleOrderDo;
	}


	/**
	 * 查询变更对象明细信息
	 */
	private List<UocChngOrderItemObj> getListChngOrderItemObj(UocChngOrderConfirmOrRefuseReqBo reqBo){
		List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
		UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
		uocChngOrderItemObjQryBo.setChngOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList()));
		uocChngOrderItemObjQryBo.setOrderIdList(orderIdList);
		uocChngOrderItemObjQryBo.setSysTenantId(reqBo.getSysTenantId());
		List<UocChngOrderItemObj> uocChngOrderItemObjList = iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
		if (CollectionUtils.isEmpty(uocChngOrderItemObjList)) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "查询变更明细对象为空");
		}
		return uocChngOrderItemObjList;
	}

	/**
	 * 验收数量变更
	 *
	 * @param uocChngOrderItemObjList
	 * @param sysTenantId
	 */
	private void acceptanceRevise(List<UocChngOrderItemObj> uocChngOrderItemObjList, Long sysTenantId){

		UocInspOrderItemQryBo inspOrderItemQryBo = new UocInspOrderItemQryBo();
		inspOrderItemQryBo.setShipOrderItemIdList(uocChngOrderItemObjList.stream().map(obj->obj.getShipOrderItemId()).collect(Collectors.toList()));
		//查询变更相关验收单明细
		inspOrderItemQryBo.setSysTenantId(sysTenantId);
		UocInspOrderDo listInspOrderItem = iUocInspOrderModel.getListInspOrderItem(inspOrderItemQryBo);
		List<UocInspOrderItem> uocInspOrderItemList = listInspOrderItem.getUocInspOrderItemList();
        //各发货明细对应验收明细map
		Map<Long, List<UocInspOrderItem>> inspMap = uocInspOrderItemList.stream().collect(Collectors.groupingBy(obj -> obj.getShipOrderItemId()));
		uocChngOrderItemObjList.forEach(obj->{
			List<UocInspOrderItem> inspItems = inspMap.get(obj.getShipOrderItemId());
			//电商验收，协议、无协议发货单一次验收
			if(inspItems.size() == 1){
				iUocInspOrderModel.modifyBatchItemInspConfirm(convertInspOrderDo(obj,inspItems.get(0),sysTenantId));
			}else {
				 acceptanceMultiple(obj,inspItems,sysTenantId);
			}
		});
	}

	/**
	 * 变更验收明细
	 *
	 * @param chngOrderItemObj
	 * @param inspItems
	 * @param sysTenantId
	 * @return
	 */
	private UocInspOrderDo convertInspOrderDo(UocChngOrderItemObj chngOrderItemObj, UocInspOrderItem inspItems, Long sysTenantId) {
		UocInspOrderDo inspOrderDo = new UocInspOrderDo();
		inspOrderDo.setInspOrderId(inspItems.getInspOrderId());
		inspOrderDo.setShipOrderItemId(chngOrderItemObj.getShipOrderItemId());
		inspOrderDo.setInspCount(chngOrderItemObj.getChngNum().negate());
		inspOrderDo.setSysTenantId(sysTenantId);

		UocSaleOrderItemQryBo saleOrderDo = new UocSaleOrderItemQryBo();
		saleOrderDo.setSaleOrderItemId(chngOrderItemObj.getSaleOrderItemId());
		//查询变更商品销售明细销售价、采购价
		saleOrderDo.setSysTenantId(sysTenantId);
		List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(saleOrderDo);
		UocSaleOrderItem uocSaleOrderItem = saleOrderItemList.get(0);
		//变更销售价
		inspOrderDo.setTotalSaleFee(uocSaleOrderItem.getSalePrice().multiply(chngOrderItemObj.getChngNum()));
		//变更采购价
		inspOrderDo.setTotalPurchaseFee(uocSaleOrderItem.getPurchasePrice().multiply(chngOrderItemObj.getChngNum()));
		return inspOrderDo;
	}

	private  void acceptanceMultiple(UocChngOrderItemObj chngOrderItemObj, List<UocInspOrderItem> inspItems, Long sysTenantId){
		List<UocInspOrderItem> collect = inspItems.stream().sorted(Comparator.comparing(UocInspOrderItem::getInspCount)).collect(Collectors.toList());
		//变更数量少于最大验收明细的验收数量
		if(chngOrderItemObj.getChngNum().compareTo(collect.get(0).getInspCount()) <= 0){
			iUocInspOrderModel.modifyBatchItemInspConfirm(convertInspOrderDo(chngOrderItemObj,collect.get(0), sysTenantId));
			return;
		}

		//变更明细总变更数量
		BigDecimal chngNum = chngOrderItemObj.getChngNum();
		for(int i=0;i<collect.size();i++){
			UocInspOrderItem item = collect.get(i);
			//当前验收明细的验收数量
			BigDecimal inspCount = item.getInspCount();
			if(chngNum.compareTo(inspCount)<=0) inspCount = chngNum;
			chngOrderItemObj.setChngNum(inspCount);
			iUocInspOrderModel.modifyBatchItemInspConfirm(convertInspOrderDo(chngOrderItemObj,item, sysTenantId));
			//剩余变更数量
			chngNum =  chngNum.subtract(inspCount);
			//该发货单明细下变更完成
			if(chngNum.signum()==0) return;
		}
	}

	/**
	 * 扩展属性处理
	 */
	private void dealMap(UocChngOrderConfirmOrRefuseReqBo reqBo, Date now) {
		List<UocChngOrderConfirmOrRefuseReqItemBo> chngOrderList = reqBo.getChngOrderList();
		chngOrderList.forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
			if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList())) {
				UocChngOrderDo delChngOrderDo = new UocChngOrderDo();
				List<UocChngOrderMap> extParallelBoList = new ArrayList<>();
				uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
					UocChngOrderMap uocChngOrderMap = new UocChngOrderMap();
					uocChngOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
					uocChngOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
					uocChngOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
					uocChngOrderMap.setUpdateOperId(reqBo.getUserId().toString());
					uocChngOrderMap.setUpdateTime(now);
					extParallelBoList.add(uocChngOrderMap);
				});
				delChngOrderDo.setUocChngOrderMapList(extParallelBoList);
				delChngOrderDo.setSysTenantId(reqBo.getSysTenantId());
				iUocChngOrderModel.updateInvalid(delChngOrderDo);
			}
			if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList())) {
				UocChngOrderDo add = new UocChngOrderDo();
				UocChngOrderDo modify = new UocChngOrderDo();
				List<UocChngOrderMap> addList = new ArrayList<>();
				List<UocChngOrderMap> modifyList = new ArrayList<>();
				uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
					if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
						UocChngOrderMap addShipOrderMap = new UocChngOrderMap();
						addShipOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
						addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
						addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
						addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
						addShipOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
						addShipOrderMap.setId(IdUtil.nextId());
						addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
						addShipOrderMap.setCreateTime(now);
						addShipOrderMap.setSysTenantId(reqBo.getSysTenantId());
						addShipOrderMap.setSysTenantName(reqBo.getSysTenantName());
						addList.add(addShipOrderMap);
					} else {
						UocChngOrderMap updateShipOrderMap = new UocChngOrderMap();
						updateShipOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
						updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
						updateShipOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
						updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
						updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
						updateShipOrderMap.setUpdateTime(now);
						updateShipOrderMap.setSysTenantId(reqBo.getSysTenantId());
						modifyList.add(updateShipOrderMap);
					}
				});
				if (!CollectionUtils.isEmpty(addList)) {
					add.setUocChngOrderMapList(addList);
					add.setSysTenantId(reqBo.getSysTenantId());
					iUocChngOrderModel.addChngOrderMap(add);
				}
				if (!CollectionUtils.isEmpty(modifyList)) {
					modify.setUocChngOrderMapList(modifyList);
					modify.setSysTenantId(reqBo.getSysTenantId());
					iUocChngOrderModel.updateBatchValue(modify);
				}
			}
			UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
			uocChngOrderDo.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
			uocChngOrderDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
			uocChngOrderDo.setChngOrderState(OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())?UocStateConstants.ChngOrder.NUM.CHNG_CHNG_QR:UocStateConstants.ChngOrder.NUM.CHNG_CHNG_JJ);
			uocChngOrderDo.setUpdateTime(now);
			uocChngOrderDo.setUpdateOperId(reqBo.getUserId().toString());
			uocChngOrderDo.setSysTenantId(reqBo.getSysTenantId());
			iUocChngOrderModel.updateChngOrderMain(uocChngOrderDo);
		});
	}

	private void validateArg(UocChngOrderConfirmOrRefuseReqBo reqBo) {
		if (null == reqBo) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
		}
		if (!OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) && !OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参操作只支持确认或拒绝为空");
		}
		if (CollectionUtils.isEmpty(reqBo.getChngOrderList())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息列表不能为空");
		}
		reqBo.getChngOrderList().forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
			if (null == uocChngOrderConfirmOrRefuseReqItemBo.getOrderId()) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息的订单ID不能为空");
			}
			if (null == uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId()) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息的变更单ID不能为空");
			}
		});
		if (null == reqBo.getUserId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID不能为空");
		}
		List<UocChngOrderConfirmOrRefuseReqItemBo> chngOrderList = reqBo.getChngOrderList();
		chngOrderList.forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {

			if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList())) {
				uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
					if (null == uocBaseExtParallelDeleteBo.getObjId()) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性对象ID不能为空");
					}
					if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性编码不能为空");
					}
				});
			}
			if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList())) {
				uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
					if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型不能为空");
					}
					if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型仅支持新增和修改");
					}
					if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
						if (null == uocBaseExtParallelDeleteBo.getObjId()) {
							throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，对象ID不能为空");
						}
						if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
							throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，属性编码不能为空");
						}
					}
					if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
						if (null == uocBaseExtParallelDeleteBo.getObjId()) {
							throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，对象ID不能为空");
						}
						if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
							throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性编码不能为空");
						}
						if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldValue())) {
							throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性值不能为空");
						}
					}
				});
			}
		});
	}

}
