package com.tydic.dyc.oc.repository;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;

import java.util.List;

/**
 * 标题:UocOrderRepository
 * 说明:订单
 * 时间:2022-02-21 13:53
 * 作者:罗有
 **/
public interface UocOrderRepository {

    /**
     * 描述:创建销售单
     * @param orderDo 入参
     * @return com.tydic.dyc.oc.model.order.UocOrderDo
     * @author tgy
     * @date 2022/2/24 20:29
     */
    UocOrderDo saveUocOrder(UocOrderDo orderDo);

    /**
     * 描述:保存附件
     * @param uocOrderAccessoryList 入参
     * @return com.tydic.dyc.oc.model.order.UocOrderDo
     * @author tgy
     * @date 2022/2/22 15:10
     */
    UocOrderDo createOrderAccessory(List<UocOrderAccessory> uocOrderAccessoryList);

    /**
     * 描述:创建订单变更记录
     * @param uocOrderStateChgLog 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog
     * @author tkl
     * @date 2022/3/2 13:49
     */
    UocOrderStateChgLog createOrderStateChangeLog(UocOrderStateChgLog uocOrderStateChgLog);

    /**
     * 描述:保存获取件地址信息
     * @param uocOrdLogisticsRela 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela
     * @author tkl
     * @date 2022/5/20 15:49
     */
    UocOrdLogisticsRela createOrderLogisticsRela(UocOrdLogisticsRela uocOrdLogisticsRela);

    List<UocOrderStakeholderQryBo> qryStakeholderList(UocOrderStakeholderQryBo qryBo);

    /**
     * 描述:查询订单任务实例
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst
     * @author tgy
     * @date 2022/2/24 20:29
     */
    List<UocOrderTaskInst> qryOrderTaskInstList(UocOrderTaskInstQryBo qryBo);

    /**
     * 描述:查询订单任务处理实例
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal
     * @author tgy
     * @date 2022/2/24 19:39
     */
    List<UocOrderTaskDeal> qryOrderTaskDealList(UocOrderTaskDealQryBo qryBo);

    /**
     * 描述:查询订单流程实例
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderProcInst
     * @author tgy
     * @date 2022/2/24 20:29
     */
    List<UocOrderProcInst> qryOrderProcInstList(UocOrderProcInstQryBo qryBo);

    /**
     * 描述:查询单订单信息
     * @param uocOrderDo 入参
     * @return com.tydic.dyc.oc.model.order.UocOrderDo
     * @author tgy
     * @date 2022/2/27 15:13
     */
    UocOrderDo qryOrderBy(UocOrderDo uocOrderDo);

    /**
     * 描述:查询订单明细信息
     * @param uocOrderItemQryBo 入参
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderItem></>
     * @author tgy
     * @date 2022/2/27 15:57
     */
    List<UocOrderItem> qryOrderItemList(UocOrderItemQryBo uocOrderItemQryBo);

    /**
     * 描述:查询收获地址信息
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela
     * @author tgy
     * @date 2022/2/27 15:57
     */
    UocOrdLogisticsRela qryOrderLogisticsRela(UocOrdLogisticsRelaQryBo qryBo);

    /**
     * 描述:查询发票信息
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrdInvoice
     * @author tgy
     * @date 2022/2/27 15:57
     */
    UocOrdInvoice qryOrderInvoice(UocOrdInvoiceQryBo qryBo);

    /**
     * 描述:查询订单附件
     *
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderAccessory
     * @author tkl
     * @date 2022/2/25 10:35
     */
    List<UocOrderAccessory> getOrderAccessoryList(UocOrderAccessoryQryBo qryBo);

    /**
     * 查询订单扩展
     *
     * @param qryBo
     * @return
     */
    List<UocOrderMap> qryOrderMapList(UocOrderMapQryBo qryBo);

    /**
     * 更新订单结算关联信息
     * @author wenle
     * @date 2022-04-01 15:19:50
     * @param qryBo 入参
     */
    void dealRelUpdate(UocOrderRel qryBo);

    /**
     * 查询关联详情
     *
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderRel
     * @author wenle
     * @date 2022-04-01 16:36:42
     */
    UocOrderRel qryRelInfo(UocOrderRelQryBo qryBo);

    /**
     * 查询关联信息
     *
     * @param qryBo
     * @return
     */
    List<UocOrderRel> qryListRelInfo(UocOrderRelQryBo qryBo);

    /**
     * 查询外部系统单号关联信息
     *
     * @param qryBo 入参
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex></>
     * @author tkl
     * @date 2022-04-01 16:31:18
     */
    List<UocOrderQueryIndex> qryOrderQueryIndexList(UocOrderQueryIndexQryBo qryBo);

    /**
     * 创建关联对象
     * @author wenle
     * @date 2022-04-01 16:52:10 
     * @param uocOrderRel 入参
     */
    void createRelInfo(UocOrderRel uocOrderRel);

    /**
     * 查询对账状态
     * @author wenle
     * @date 2022-04-01 19:51:42
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderCheckAccount
     */
    UocOrderCheckAccount qryCheckInfo(UocOrderCheckAccountQryBo qryBo);

    /**
     * 创建对账状态
     * @author wenle
     * @date 2022-04-01 19:59:55
     * @param uocOrderCheckAccount 入参
     */
    void createCheckInfo(UocOrderCheckAccount uocOrderCheckAccount);

    /**
     * 更新对账状态
     * @author wenle
     * @date 2022-04-01 20:00:20
     * @param uocOrderCheckAccount 入参
     */
    void updateCheckInfo(UocOrderCheckAccount uocOrderCheckAccount);

    /**
     * 描述：修改订单明细销售金额
     *
     * @author: daiyuanyuan
     * @date:   2022-04-06 14:08
     */
    void modifyBatchItemSalePrice(UocOrderDo uocOrderDo);

    /**
     * 描述：统计销售单明细总金额
     *
     * @author: daiyuanyuan
     * @date:   2022-04-06 14:08
     */
    UocOrderDo getOrderItemTotalPrice(UocOrderDo uocOrderDo);

    /**
     * 描述：修改订单主体信息
     *
     * @author: daiyuanyuan
     * @date: 2022-04-06 14:08
     */
    void modifyOrderMain(UocOrderDo uocOrderDo);

    /**
     * 查询评价配置
     *
     * @param uocConfEvaluateQryBo
     * @return
     */
    BasePageRspBo<UocConfEvaluate> qryListPageConfEvaluate(UocConfEvaluateQryBo uocConfEvaluateQryBo);

    /**
     * 新增评价配置
     */
    void addConfEvaluate(UocConfEvaluate uocConfEvaluate);

    /**
     * 修改评价配置
     */
    void modifyConfEvaluate(UocConfEvaluate uocConfEvaluate);

    /**
     * 删除评价配置
     */
    void deleteConfEvaluate(UocConfEvaluate uocConfEvaluate);

    /**
     * 查询单条评价配置
     *
     * @param id
     */
    UocConfEvaluate getConfEvaluateById(Long id);

    int getCheckConfEvaluate(UocConfEvaluate uocConfEvaluate);

    /**
     * 查询页签状态列表
     *
     * @param qryBo
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocConfTabOrdState></>
     */
    List<UocConfTabOrdState> qryConfTabOrdStateList(UocConfTabOrdStateQryBo qryBo);

    /**
     * 订单按钮配置类查询
     *
     * @param qryBo
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocConfButton></>
     */
    List<UocConfButton> qryConfButtonList(UocConfButtonQryBo qryBo);

    /**
     * 订单按钮配置类更新
     *
     * @param confButton
     * @return com.tydic.dyc.oc.model.order.sub.UocConfButton
     */
    UocConfButton updateConfButton(UocConfButton confButton);

    int deleteConfSupplierBy(UocConfSupplier uocConfSupplier);

    int updateConfSupplierById(UocConfSupplier uocConfSupplier);

    UocConfSupplier getConfSupplierModelById(long supNo);

    UocConfSupplier getConfSupplierModelBy(UocConfSupplier uocConfSupplier);

    int addConfSupplier(UocConfSupplier uocConfSupplier);

    /**
     * 时效类配置查询
     */
    BasePageRspBo<UocConfEffective> qryListPageConfEffective(UocConfEffectiveQryBo uocConfEffectiveQryBo);

    /**
     * 根据条件校验有多少条数据
     */
    int getCheckConfEffectiveBy(UocConfEffectiveQryBo uocConfEffectiveQryBo);

    /**
     * 创建时效配置
     */
    void addConfEffective(UocConfEffective uocConfEffective);

    /**
     * 查询时效类配置
     */
    UocConfEffective getConfEffectiveBy(UocConfEffective uocConfEffective);

    /**
     * 删除时效配置
     */
    void deleteConfEffective(UocConfEffective uocConfEffective);

    /**
     * 根据id更新时效配置
     */
    int updateEffectiveConfById(UocConfEffective effective);

    int getCheckMsg(UocDMsgPoolQryBo qryBo);

    int insertMsgPool(UocDMsgPoolQryBo qryBo);

    BasePageRspBo<ConfSupplierQryBo> qryListPageConfSupplier(ConfSupplierQryBo confSupplierQryBo);

    /**
     * 描述：查询差异化超验配置在用列表
     *
     * @author: daiyuanyuan
     * @date:   2022-04-08 17:32
     */
    List<UocConfInspectionUse> qryInspectionConfigUseList(UocConfInspectionUse  uocConfInspectionUse);

    List<UocConfInspection> qryInspectionConfigList(UocConfInspection  uocConfInspection);

    void updateInspectionConfigUse(UocConfInspectionUse  uocConfInspectionUse);

    void deleteInspectionConfig(UocConfInspection  uocConfInspection);

    void insertInspectionConfigByBatch(List<UocConfInspection>  uocConfInspections);

    void insertOrderEvaluate(UocEvaluate uocEvaluate);

    List<UocEvaluate> qryOrderEvaluateList(UocEvaluateQryBo uocEvaluateQryBo);

    void updateOrderEvaluate(UocEvaluate uocEvaluate);


    List<UocDMsgPoolQryBo> getListByRunResultAndFailureCount(UocDMsgPoolQryBo qryBo);

    /*
     * @Author lsl
     * @Description //TODO 查询妥投类消息
     * @Date 17:33 2022/4/12
     * @Param [qryBo]
     * @return java.util.List<com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo>
     */
    List<UocDMsgPoolQryBo> getVoteMsgList(UocDMsgPoolQryBo qryBo);

    List<UocDMsgPoolQryBo> getMsgList(UocDMsgPoolQryBo qryBo);

    UocDMsgPoolQryBo getModelByMsgId(UocDMsgPoolQryBo qryBo);

    void upDateMsgPoolById(UocDMsgPoolQryBo qryBo);

    void updateQueryIndexById(UocOrderQueryIndexQryBo qryBo);

    /**
     * 页签环节按钮查询
     */
    List<UocTacheButton> qryTacheButton(UocTacheButtonQryBo uocTacheButtonQryBo);

    /**
	 * 描述：修改订单明细采购金额
	 *
	 * @author: daiyuanyuan
	 * @date: 2022-04-06 14:08
	 */
	void modifyBatchItemPurchasePrice(UocOrderDo uocOrderDo);

	void modifyTabConf(UocConfTabOrdState uocConfTabOrdState);

    List<UocOrderItemMap> qryOrderItemMapList(UocOrderItemMapQryBo uocOrderItemMapQryBo);
	void deleteAuditConf(UocConfAudit uocConfAudit);

	List<UocConfAudit> qryListAuditConf(UocConfAuditQryBo uocConfAuditQryBo);

	void updateAuditConf(UocConfAudit uocConfAudit);

	void addExceptionAuditConf(UocConfAudit uocConfAudit);

    List<UocOrderDo> qryOrderList(UocOrderDo qryDo);

    UocConfAudit getAudit(UocConfAuditQryBo uocConfAuditQryBo);
}
