package com.tydic.dyc.oc.service.common;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.qrybo.UocConfSupplierBo;
import com.tydic.dyc.oc.service.common.UocQryConfSupplierService;
import com.tydic.dyc.oc.service.common.bo.UocQryConfSupplierReqBO;
import com.tydic.dyc.oc.service.common.bo.UocQryConfSupplierRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * @Author lsl
 * @Description //TODO 查询电商配置接口实现
 * @Date 17:54 2022/4/7
 * @Param
 * @return
 */
@Slf4j
@HTServiceImpl
public class UocQryConfSupplierServiceImpl implements UocQryConfSupplierService {
    
    @Autowired
    private IUocCommonModel iUocCommonModel;
    
    @Override
    public UocQryConfSupplierRspBO qryConfSupplier(UocQryConfSupplierReqBO reqBO) {
        UocQryConfSupplierRspBO rspBO = new UocQryConfSupplierRspBO();
        rspBO.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
    
        UocConfSupplierBo modelRsp = iUocCommonModel.qryConfSupplier(reqBO.getGoodsSupplierNo());
        if(ObjectUtil.isNotEmpty(modelRsp)){
            rspBO.setDealType(modelRsp.getDealType());
        }
        return rspBO;
    }
}
