package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.service.common.bo.UocProRspBoUtil;
import com.tydic.dyc.oc.service.order.bo.UocGetQueryOutOrderServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocGetQueryOutOrderServiceRspBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOutOrderIndexBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@Slf4j
@HTServiceImpl
public class UocGetQueryOutOrderServiceImpl implements UocGetQueryOutOrderService{
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    @Override
    public UocGetQueryOutOrderServiceRspBo qryOrderQueryIndexList(UocGetQueryOutOrderServiceReqBo reqBo) {
        UocGetQueryOutOrderServiceRspBo rspBo = new UocGetQueryOutOrderServiceRspBo();
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        UocOrderQueryIndexQryBo queryIndexQryBo = new UocOrderQueryIndexQryBo();
        queryIndexQryBo.setOrderId(reqBo.getOrderId());
        queryIndexQryBo.setObjType(reqBo.getObjType());
        List<UocOrderQueryIndex> uocOrderQueryIndexList = iUocOrderModel.qryOrderQueryIndexList(queryIndexQryBo);
        List<UocQryOutOrderIndexBo> uocQryOutOrderIndexBoList = UocRu.jsl(uocOrderQueryIndexList, UocQryOutOrderIndexBo.class);
        rspBo.setUocOrderQueryIndexList(uocQryOutOrderIndexBoList);
        return rspBo;
    }
}
