/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DelFormatHelper;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderMapQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderMap;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.UocQryEsLogisticsInfoService;
import com.tydic.dyc.oc.service.domainservice.bo.OrderTrackInfoBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocEsbReqParamBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryEsLogisticsInfoServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryEsLogisticsInfoServiceRspBo;
import com.tydic.dyc.oc.utils.ESBParamUtil;
import com.tydic.dyc.oc.utils.SslClientUtil;
import com.tydic.dyc.oc.utils.UocOrderPropertiesUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.1.0/com.tydic.dyc.oc.service.domainservice.UocQryEsLogisticsInfoService"})
public class UocQryEsLogisticsInfoServiceImpl
implements UocQryEsLogisticsInfoService {
    private static final Logger log = LoggerFactory.getLogger(UocQryEsLogisticsInfoServiceImpl.class);
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    public static final String FIELD_CODE = "jdOrgId";

    @PostMapping(value={"qryEsLogisticsDataList"})
    public UocQryEsLogisticsInfoServiceRspBo qryEsLogisticsDataList(@RequestBody UocQryEsLogisticsInfoServiceReqBo reqBo) {
        UocQryEsLogisticsInfoServiceRspBo rspBo = UocRu.success(UocQryEsLogisticsInfoServiceRspBo.class);
        this.validateParams(reqBo);
        log.debug("\u67e5\u8be2\u7269\u6d41\u914d\u9001\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBo));
        return this.qryEsLogisData(reqBo, rspBo);
    }

    private UocQryEsLogisticsInfoServiceRspBo qryEsLogisData(UocQryEsLogisticsInfoServiceReqBo reqBo, UocQryEsLogisticsInfoServiceRspBo rspBo) {
        try {
            List<UocOrderMap> mapList = this.getUocOrderMapList(reqBo);
            List<UocOrderStakeholderQryBo> ordStakeHolderList = this.getOrdStakeHolderList(reqBo.getOrderId());
            if (ObjectUtil.isEmpty(ordStakeHolderList)) {
                throw new BaseBusinessException("101013", "\u8c03\u7528ESB\u67e5\u8be2\u914d\u9001\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38\uff1a\u3010\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u4e09\u65b9\u4fe1\u606f\u3011");
            }
            UocShipOrderDo shipOrderDo = this.getShipOrderDo(reqBo);
            UocEsbReqParamBO esbReqParam = new UocEsbReqParamBO();
            if (ObjectUtil.isNull((Object)shipOrderDo)) {
                List<UocOrderQueryIndex> indexList = this.getOrderQueryIndexList(reqBo);
                if (ObjectUtil.isNotEmpty(indexList)) {
                    esbReqParam.setType(UocConstant.ORD_TYPE.PORD_OR_CORD);
                    esbReqParam.setOrderId(indexList.get(0).getOutObjId());
                    esbReqParam.setSupplierId(Long.valueOf(ordStakeHolderList.get(0).getSupId()));
                    if (ObjectUtil.isNotEmpty(mapList)) {
                        esbReqParam.setOrgId(mapList.get(0).getFieldValue());
                    }
                }
            } else {
                rspBo.setShipCompanyName(shipOrderDo.getShipCompanyName());
                if (ObjectUtil.isNotEmpty((Object)shipOrderDo.getShipOrderNoExt())) {
                    esbReqParam.setOrderId(shipOrderDo.getShipOrderNoExt());
                } else {
                    List<UocAfOrder> afOrderList = this.getAfOrderList(shipOrderDo);
                    if (ObjectUtil.isNotEmpty(afOrderList)) {
                        esbReqParam.setOrderId(afOrderList.get(0).getExtOrderId());
                    } else {
                        throw new BaseBusinessException("103004", "\u67e5\u8be2\u552e\u540e\u5355\u4e3a\u7a7a");
                    }
                }
                esbReqParam.setType(UocConstant.ORD_TYPE.SHIP_ORD);
                esbReqParam.setSupplierId(Long.valueOf(ordStakeHolderList.get(0).getSupId()));
                if (ObjectUtil.isNotEmpty(mapList)) {
                    esbReqParam.setOrgId(mapList.get(0).getFieldValue());
                }
            }
            String reqStr = this.initPostStr(esbReqParam);
            String returnString = SslClientUtil.doPost(UocOrderPropertiesUtil.getProperty("ESB_QRY_ORDER_TRACK_URL"), reqStr);
            log.debug("\u8c03\u7528ESB\u67e5\u8be2\u914d\u9001\u4fe1\u606f\u63a5\u53e3\u54cd\u5e94\u62a5\u6587:{}", (Object)returnString);
            if (ObjectUtil.isEmpty((Object)returnString)) {
                throw new BaseBusinessException("101014", "\u8c03\u7528ESB\u67e5\u8be2\u914d\u9001\u4fe1\u606f\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            }
            return this.resolveRsp(returnString, rspBo);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528ESB\u67e5\u8be2\u914d\u9001\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38:{}", (Throwable)e);
            throw new BaseBusinessException("101013", "\u8c03\u7528ESB\u67e5\u8be2\u914d\u9001\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
        }
    }

    private List<UocAfOrder> getAfOrderList(UocShipOrderDo shipOrderDo) {
        UocAfOrderQryBo qryBo = new UocAfOrderQryBo();
        qryBo.setOrderId(shipOrderDo.getOrderId());
        qryBo.setSaleOrderId(shipOrderDo.getSaleOrderId());
        return this.iUocAfOrderModel.getAfOrderList(qryBo);
    }

    private List<UocOrderQueryIndex> getOrderQueryIndexList(UocQryEsLogisticsInfoServiceReqBo reqBo) {
        UocOrderQueryIndexQryBo qryBo = new UocOrderQueryIndexQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        return this.iUocOrderModel.qryOrderQueryIndexList(qryBo);
    }

    private UocShipOrderDo getShipOrderDo(UocQryEsLogisticsInfoServiceReqBo reqBo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        return this.iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
    }

    private List<UocOrderMap> getUocOrderMapList(UocQryEsLogisticsInfoServiceReqBo reqBo) {
        UocOrderMapQryBo uocOrderMapQryBo = new UocOrderMapQryBo();
        uocOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocOrderMapQryBo.setFieldCode(FIELD_CODE);
        return this.iUocOrderModel.qryOrderMapList(uocOrderMapQryBo);
    }

    private List<UocOrderStakeholderQryBo> getOrdStakeHolderList(Long orderId) {
        UocOrderStakeholderQryBo stakeholderQryBo = new UocOrderStakeholderQryBo();
        stakeholderQryBo.setOrderId(orderId);
        return this.iUocOrderModel.qryStakeholderList(stakeholderQryBo);
    }

    private String initPostStr(UocEsbReqParamBO reqParam) {
        String hsn = UocOrderPropertiesUtil.getProperty("SUPPLIER_ID_" + reqParam.getSupplierId());
        String esbReqParam = ESBParamUtil.getEsbReqParam(reqParam, hsn, "BUSINESS_ORDER");
        log.debug("\u8c03\u7528\u914d\u9001\u4fe1\u606f\u67e5\u8be2ESB\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)esbReqParam);
        return esbReqParam;
    }

    private UocQryEsLogisticsInfoServiceRspBo resolveRsp(String returnString, UocQryEsLogisticsInfoServiceRspBo rspBo) {
        log.debug("\u8c03\u7528\u914d\u9001\u4fe1\u606f\u67e5\u8be2ESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)returnString);
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (jsonObject.getBoolean("success").booleanValue()) {
            if ("0000".equals(jsonObject.get((Object)"resultCode"))) {
                String jsonStr = JSONObject.toJSONString((Object)jsonObject.get((Object)"result"));
                if (ObjectUtil.isNotEmpty((Object)jsonStr)) {
                    String waybillCode;
                    List orderTrackList;
                    JSONObject object = JSONObject.parseObject((String)jsonStr);
                    String orderTrack = JSONObject.toJSONString((Object)object.get((Object)"orderTrack"));
                    String orderId = (String)JSONObject.parseObject((String)jsonStr).get((Object)"orderId");
                    if (ObjectUtil.isNotEmpty((Object)orderTrack) && ObjectUtil.isNotEmpty((Object)(orderTrackList = JSON.parseArray((String)orderTrack, OrderTrackInfoBO.class)))) {
                        this.listSort(orderTrackList);
                        rspBo.setOrderTrackList(orderTrackList);
                    }
                    if ((waybillCode = object.getString("waybillCode")) != null) {
                        try {
                            JSONArray array = JSONArray.parseArray((String)waybillCode);
                            rspBo.setCarrier(array.getJSONObject(0).getString("carrier"));
                            rspBo.setDeliveryOrderId(array.getJSONObject(0).getString("deliveryOrderId"));
                        }
                        catch (Exception e) {
                            try {
                                JSONObject code = JSONObject.parseObject((String)waybillCode);
                                rspBo.setCarrier(code.getString("carrier"));
                                rspBo.setDeliveryOrderId(code.getString("deliveryOrderId"));
                            }
                            catch (Exception ignored) {
                                log.error("\u89e3\u6790\u5f02\u5e38:{}", (Object)ignored.getMessage());
                            }
                        }
                    }
                    rspBo.setOrderId(orderId);
                }
            } else {
                rspBo.setRespCode("101012");
                rspBo.setRespDesc("\u8c03\u7528\u914d\u9001\u4fe1\u606f\u67e5\u8be2ESB\u63a5\u53e3\u5931\u8d25" + jsonObject.get((Object)"resultMessage"));
            }
        }
        return rspBo;
    }

    private void listSort(List<OrderTrackInfoBO> list) {
        Collections.sort(list, new Comparator<OrderTrackInfoBO>(){

            @Override
            public int compare(OrderTrackInfoBO o1, OrderTrackInfoBO o2) {
                try {
                    Date dt1 = DelFormatHelper.fromSdfToDate((String)o1.getMsgTime());
                    Date dt2 = DelFormatHelper.fromSdfToDate((String)o2.getMsgTime());
                    if (dt1.getTime() < dt2.getTime()) {
                        return 1;
                    }
                    if (dt1.getTime() > dt2.getTime()) {
                        return -1;
                    }
                    return 0;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        });
    }

    private void validateParams(UocQryEsLogisticsInfoServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocQryLogisticsInfoServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBo.getShipOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d1\u8d27\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBo.getType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

