/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.domainservice.UocQryOrderOverallProgressService;
import com.tydic.dyc.oc.service.domainservice.bo.UocOverallProgressSaleOrderItemBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocOverallProgressStakeholderInfoBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderOverallProgressReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderOverallProgressRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.1.0/com.tydic.dyc.oc.service.domainservice.UocQryOrderOverallProgressService"})
public class UocQryOrderOverallProgressServiceImpl
implements UocQryOrderOverallProgressService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @PostMapping(value={"qryOrderOverallProjress"})
    public UocQryOrderOverallProgressRspBo qryOrderOverallProjress(@RequestBody UocQryOrderOverallProgressReqBo reqBo) {
        this.validateArg(reqBo);
        UocQryOrderOverallProgressRspBo rspBo = UocRu.success(UocQryOrderOverallProgressRspBo.class);
        UocOrderDo uocOrderDo = this.getUocOrderDo(reqBo);
        if (ObjectUtil.isNull((Object)((Object)uocOrderDo))) {
            return rspBo;
        }
        List<UocSaleOrderItem> saleOrderItemList = this.getSaleOrderItemList(reqBo);
        UocSaleOrderDo uocSaleOrderDo = this.getUocSaleOrderDo(reqBo);
        this.buildOrderMain(rspBo, uocOrderDo);
        this.buildSaleOrderItem(rspBo, saleOrderItemList);
        this.buildStakeHolder(rspBo, uocSaleOrderDo);
        return rspBo;
    }

    private void buildStakeHolder(UocQryOrderOverallProgressRspBo rspBo, UocSaleOrderDo uocSaleOrderDo) {
        if (ObjectUtil.isNotNull((Object)uocSaleOrderDo)) {
            rspBo.setSaleOrderNo(uocSaleOrderDo.getSaleOrderNo());
            rspBo.setSaleOrderState(uocSaleOrderDo.getSaleOrderState());
            rspBo.setSaleOrderStateStr(this.getDic().get("UOC_SALE_ORDER_STATE").get(uocSaleOrderDo.getSaleOrderState()));
            if (ObjectUtil.isNotNull((Object)uocSaleOrderDo.getStakeholder())) {
                rspBo.setStakeholderInfo(UocRu.js(uocSaleOrderDo.getStakeholder(), UocOverallProgressStakeholderInfoBO.class));
            }
        }
    }

    private List<UocShipOrderItem> getShipOrderItemList(UocSaleOrderItem reqBo, List<Long> saleOrderItemIdList) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIdList);
        return this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo).getShipOrderItemBoList();
    }

    private void buildSaleOrderItem(UocQryOrderOverallProgressRspBo rspBo, List<UocSaleOrderItem> saleOrderItemList) {
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            List<Long> saleOrderItemIdList = saleOrderItemList.stream().map(UocSaleOrderItem::getSaleOrderItemId).filter(Objects::nonNull).collect(Collectors.toList());
            List<UocShipOrderItem> shipOrderItemList = this.getShipOrderItemList(saleOrderItemList.get(0), saleOrderItemIdList);
            Map<Object, Object> shipOrderItemMap = new HashMap();
            if (ObjectUtil.isNotEmpty(shipOrderItemList)) {
                shipOrderItemMap = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getSaleOrderItemId, o -> o, (k1, k2) -> k2));
            }
            for (UocSaleOrderItem each : saleOrderItemList) {
                if (ObjectUtil.isNotNull((Object)each.getSalePrice()) && ObjectUtil.isNotNull((Object)each.getPurchaseCount())) {
                    each.setTotalSaleFee(each.getSalePrice().multiply(each.getPurchaseCount()));
                }
                if (ObjectUtil.isNotEmpty(shipOrderItemMap) && ObjectUtil.isNotNull((Object)shipOrderItemMap.get(each.getSaleOrderItemId()))) {
                    each.setSendCount(((UocShipOrderItem)shipOrderItemMap.get(each.getSaleOrderItemId())).getSendCount());
                    each.setAcceptanceCount(((UocShipOrderItem)shipOrderItemMap.get(each.getSaleOrderItemId())).getInspCount());
                }
                if (!ObjectUtil.isNotEmpty((Object)each.getArrivalTime())) continue;
                each.setArriveTime(DateUtils.strToDate((String)each.getArrivalTime()));
            }
            rspBo.setSaleOrderItemInfos(UocRu.jsl(saleOrderItemList, UocOverallProgressSaleOrderItemBO.class));
        }
    }

    private UocSaleOrderDo getUocSaleOrderDo(UocQryOrderOverallProgressReqBo reqBo) {
        UocSaleOrderDo qryBo = new UocSaleOrderDo();
        qryBo.setSaleOrderId(reqBo.getSaleOrderId());
        qryBo.setOrderId(reqBo.getOrderId());
        List<UocSaleOrderDo> uocSaleOrderDos = this.iUocSaleOrderModel.qrySaleOrderList(qryBo);
        return ObjectUtil.isNotNull(uocSaleOrderDos) ? uocSaleOrderDos.get(0) : null;
    }

    private UocOrderDo getUocOrderDo(UocQryOrderOverallProgressReqBo reqBo) {
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        return this.iUocOrderModel.qryOrderBy(uocOrderDo);
    }

    private List<UocSaleOrderItem> getSaleOrderItemList(UocQryOrderOverallProgressReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    private void buildOrderMain(UocQryOrderOverallProgressRspBo rspBo, UocOrderDo uocOrderDo) {
        rspBo.setOrderId(uocOrderDo.getOrderId());
        rspBo.setOrderNo(uocOrderDo.getOrderNo());
        rspBo.setOrderName(uocOrderDo.getOrderName());
        rspBo.setOrderState(uocOrderDo.getOrderState());
        rspBo.setOrderStateStr(this.getDic().get("UOC_ORDER_STATE").get(uocOrderDo.getOrderState()));
        rspBo.setCreateTime(uocOrderDo.getCreateTime());
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("UOC_SALE_ORDER_STATE");
        pCodes.add("UOC_ORDER_STATE");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    private void validateArg(UocQryOrderOverallProgressReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocQryOrderOverallProgressReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u8ba2\u5355id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u9500\u552e\u5355id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

