package com.tydic.dyc.oc.service.common;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.order.sub.UocTodo;
import com.tydic.dyc.oc.service.common.bo.*;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 描述: 〈领域服务-查询单条待办信息 实现〉
 * @author : 王久鑫
 * @date : 2022/10/27 14:05
 */
@HTServiceImpl
public class UocGetTodoInfoServiceImpl implements UocGetTodoInfoService{
    @Autowired
    private IUocCommonModel uocCommonModel;
    @Override
    public UocGetTodoInfoRspBo getTodoInfo(UocGetTodoInfoReqBo uocGetTodoInfoReqBo) {
        validateArgs(uocGetTodoInfoReqBo);
        UocTodo uocTodo = new UocTodo();
        BeanUtils.copyProperties(uocGetTodoInfoReqBo,uocTodo);
        UocTodo todoInfo = uocCommonModel.getTodoInfo(uocTodo);
        UocGetTodoInfoRspBo rspBO = new UocGetTodoInfoRspBo();
        rspBO.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        if (ObjectUtil.isNotEmpty(todoInfo)){
            UocTodoBo uocTodoBo = new UocTodoBo();
            BeanUtils.copyProperties(todoInfo,uocTodoBo);
            rspBO.setUocTodoBo(uocTodoBo);
        }
        return rspBO;
    }
    private void validateArgs(UocGetTodoInfoReqBo uocGetTodoInfoReqBo){
        if (null == uocGetTodoInfoReqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
    }
}
