package com.tydic.dyc.oc.config;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 标题:UocIndexConfig
 * 说明: 索引配置（基于新版数据同步，跟之前的区分开）
 * 时间:2022/3/11 10:56
 * 作者:田桂银
 */
@Component
@Data
public class UocIndexConfigPro {

    /**
     * 订单索引
     */
    @Value("${uoc.index.orderIndexPro:oc_order_pro}")
    private String orderIndexPro;

    /**
     * 销售单索引
     */
    @Value("${uoc.index.saleOrderIndexPro:oc_sale_pro}")
    private String saleOrderIndexPro;

    /**
     * 执行单索引
     */
    @Value("${uoc.index.implOrderIndexPro:oc_impl_pro}")
    private String implOrderIndexPro;

    /**
     * 发货单索引
     */
    @Value("${uoc.index.shipOrderIndexPro:oc_ship_pro}")
    private String shipOrderIndexPro;

    /**
     * 售后单索引
     */
    @Value("${uoc.index.afOrderIndexPro:oc_af_pro}")
    private String afOrderIndexPro;

    /**
     * 验收单索引
	 */
	@Value("${uoc.index.inspOrderIndexPro:oc_insp_pro}")
	private String inspOrderIndexPro;

	/**
	 * 变更单索引
	 */
	@Value("${uoc.index.chngOrderIndexPro:oc_chng_pro}")
	private String chngOrderIndexPro;

	/**
	 * 代办索引
	 */
	@Value("${uoc.index.todoIndexPro:oc_todo_pro}")
	private String todoIndexPro;

	/**
	 * 成交服务费索引
	 */
	@Value("${uoc.index.transactionIndexPro:oc_transaction_pro}")
	private String transactionIndexPro;

	/**
	 * 代办索引删除
	 */
	@Value("${uoc.index.todoIndexPro:oc_todo_delete_pro}")
	private String todoIndexDeletePro;

	/**
	 * 审批单索引
	 */
	@Value("${uoc.index.approvalOrderIndexPro:oc_approval_pro}")
	private String approvalOrderIndexPro;

	/**
	 * 索引不存在时，报错内容包含，用这个创建
	 */
	public static final String INDEX_EXCEPTION = "index_not_found_exception";

}


