package com.tydic.dyc.oc.service.saleorder;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.bo.UocQryLastMonthSaleOrdersCountServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocQryLastMonthSaleOrdersCountServiceRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@HTServiceImpl
public class UocQryLastMonthSaleOrdersCountServiceImpl implements UocQryLastMonthSaleOrdersCountService{
    
    
    @Autowired
    private IUocSaleOrderModel saleOrderModel;
    
    @Override
    public UocQryLastMonthSaleOrdersCountServiceRspBo queryCounts(UocQryLastMonthSaleOrdersCountServiceReqBo reqBo) {
        UocQryLastMonthSaleOrdersCountServiceRspBo rspBO =  new UocQryLastMonthSaleOrdersCountServiceRspBo();
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        
        List<String> saleOrderList = new ArrayList<>();
        saleOrderList.add(0, UocStateConstants.SaleOrder.XS_YS_YS);
        saleOrderList.add(1,UocStateConstants.SaleOrder.XS_YS_BFYS);
        uocSaleOrderDo.setSaleOrderStateList(saleOrderList);
        
        LocalDate firstDayOfMonth =  LocalDate.now().minusMonths(1).with(TemporalAdjusters.firstDayOfMonth());
        LocalDate lastDayOfMonth =  LocalDate.now().minusMonths(1).with(TemporalAdjusters.lastDayOfMonth());
    
        uocSaleOrderDo.setCreateTimeStart(Date.from(firstDayOfMonth.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
        uocSaleOrderDo.setCreateTimeEnd(Date.from(lastDayOfMonth.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
    
        int count = saleOrderModel.qrySaleCounts(uocSaleOrderDo);
    
        rspBO.setSaleOrderCounts(count);
        rspBO.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBO;
    }

}
