package com.tydic.dyc.oc.repository;

import com.tydic.dyc.oc.model.common.qrybo.UocConfSupplierBo;
import com.tydic.dyc.oc.model.common.qrybo.UocQryMateriaOrderNoBo;
import com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigDo;
import com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigItemDo;
import com.tydic.dyc.oc.model.common.sub.UocConfSupplierDO;
import com.tydic.dyc.oc.model.common.sub.UocFile;
import com.tydic.dyc.oc.model.order.sub.*;

import java.util.List;

/**
 * 标题:UocCommonRepository
 * 说明:通用
 * 时间:2022/2/25 19:36
 * 作者:罗有
 */

public interface UocCommonRepository {
    /**
     * 添加附件
     *
     * @param uocOrderAccessoryList
     */
    void addBatchOrderAccessory(List<UocOrderAccessory> uocOrderAccessoryList);

    /**
     * 描述:置为已办
     *
     * @param uocOrderTaskInstList 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst
     * @author tgy
     * @date 2022/2/27 9:30
     */
    void updateToFinished(List<UocOrderTaskInst> uocOrderTaskInstList);

    /**
     * 描述:保存销售单任务实例
     * @param saveTaskList 入参
     * @return void
     * @author tgy
     * @date 2022/2/27 12:45
     */
    void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList);

    /**
     * 描述:保存流程实例数据
     * @param inst 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderProcInst
     * @author tgy
     * @date 2022/2/27 21:33
     */
    UocOrderProcInst createProInst(UocOrderProcInst inst);

    /**
     * 描述:查询流程实例列表
     * @param inst 入参
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderProcInst>
     * @author tgy
     * @date 2022/2/27 21:37
     */
    List<UocOrderProcInst> qryProcInsList(UocOrderProcInst inst);


    /**
     * 描述:保存任务处理对象数据
     * @param dealList 入参
     * @return void
     * @author tgy
     * @date 2022/3/1 18:24
     */
    void saveOrderTaskDealList(List<UocOrderTaskDeal> dealList);

    /**
     * 描述:创建状态变更日志
     * @param uocOrderStateChgLog 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog
     * @author tgy
     * @date 2022/3/3 17:40
     */
    UocOrderStateChgLog createOrderStateChangeLog(UocOrderStateChgLog uocOrderStateChgLog);


    /**
     * 描述:任务列表查询
     * @param taskInst 入参
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst>
     * @author tgy
     * @date 2022/3/9 13:23
     */
    List<UocOrderTaskInst> qryTaskInstList(UocOrderTaskInst taskInst);


    /**
     * 描述:更新流程实例数据
     * @param inst 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderProcInst
     * @author tgy
     * @date 2022/3/10 19:39
     */
    UocOrderProcInst updateProInst(UocOrderProcInst inst);

    /**
     * 描述:保存业务操作数据
     * @param recordList 入参
     * @return void
     * @author tgy
     * @date 2022/3/10 20:16
     */
    void saveOperRecord(List<UocOrderBusiOperRecord> recordList);

    String getOrderNoSingle(String code);

    void updateTaskInst(UocOrderTaskInst inst);

    /*
     * @Author lsl
     * @Description 查询供应商配置
     * @Date 18:11 2022/4/7
     * @Param [goodsSupplierNo]
     * @return com.tydic.dyc.oc.model.common.qrybo.UocConfSupplierBo
     */
    UocConfSupplierBo qryConfSupplier(String goodsSupplierNo);

    /**
     * 说明: 查询供应商配置列表
     * 时间: 19:48 2022-06-01
     * 作者: 王钟游
     **/
    List<UocConfSupplierDO> qryConfSupplierList(UocConfSupplierDO uocConfSupplierDO);

    /**
     * 封装FileClient 上传服务
     * @param uocFile
     * @return
     */
    UocFile uploadFile(UocFile uocFile);


    int saveOrderQueryIndex(UocOrderQueryIndex index);

    void deleteTaskInstByStepIdAndFinshTag(UocOrderTaskInst taskInst);

    void saveProcTaskInstLog(List<UocOrderTaskInst> saveTaskList);

    void deleteProcTaskInstByIds(UocOrderTaskInst taskInst);

    void updateTaskDeal(UocOrderTaskDeal taskDeal);

    /**
     * 保存待办信息
     * @param uocTodo
     * @return
     */
    int saveTodoInfo(UocTodo uocTodo);

    /**
     * 根据主键id更新待办信息
     * @param uocTodo
     * @return
     */
    int updateTodoById(UocTodo uocTodo);

    /**
     * 查询单条待办信息
     * @param uocTodo
     * @return
     */
    UocTodo getTodoInfo(UocTodo uocTodo);

    /**
     * 查询多条待办信息
     * @param uocTodo
     * @return
     */
    List<UocTodo> getTodoListInfo(UocTodo uocTodo);

    /**
     * 批量插入待办信息
     * @param list
     */
    void insertBatchTodo(List<UocTodo> list);

    /**
     * 描述:根据配置编码查询配置及配置明细信息
     * @param paramCode 参数编码
     * @return com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigDo
     * @author tgy
     * @date 2023/1/4 11:04
     */
    UocCfcParamConfigDo qryCfcParamByCode(String paramCode);

    /**
     * 描述:更新业务配置项
     * @param reqDo 入参
     * @return com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigItemDo
     * @author tgy
     * @date 2023/1/4 11:07
     */
    UocCfcParamConfigItemDo updateCfcItemValue(UocCfcParamConfigItemDo reqDo);


    /**
     * 描述:根据skuid查询物料编码
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.common.qrybo.UocQryMateriaOrderNoBo
     * @author tgy
     * @date 2023/1/6 19:07
     */
    UocQryMateriaOrderNoBo qryMateriaBySkuIdAndUserId(UocQryMateriaOrderNoBo qryBo) ;
}
