package com.tydic.dyc.oc.service.cmporder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.constants.UocCfcConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigDo;
import com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigItemDo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.UocSysDictionaryDo;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocMustCompareOrderConfigQryServiceReqBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocMustCompareOrderConfigQryServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:UocMustCompareOrderConfigQryServiceImpl
 * 说明:
 * 时间:2023/1/3 17:12
 * 作者:田桂银
 */
@HTServiceImpl
public class UocMustCompareOrderConfigQryServiceImpl implements UocMustCompareOrderConfigQryService {

    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Override
    public UocMustCompareOrderConfigQryServiceRspBo qryMustCompareOrderConfig(UocMustCompareOrderConfigQryServiceReqBo reqBo) {
        UocMustCompareOrderConfigQryServiceRspBo rspBo = UocRu.success(UocMustCompareOrderConfigQryServiceRspBo.class);
        //查询业务配置
        UocCfcParamConfigDo uocCfcParamConfigDo = iUocCommonModel.qryCfcParamByCode(UocCfcConstants.COMMODITY_MUST_COMPARE_ORDER_CONFIG.PARAM_CONFIG_CODE);
        if(ObjectUtil.isNotEmpty(uocCfcParamConfigDo.getItemList())){
            UocCfcParamConfigItemDo itemDo = uocCfcParamConfigDo.getItemList().get(0);
            UocSysDictionaryQryBo qryCodeBo = new UocSysDictionaryQryBo();
            qryCodeBo.setPCode(UocCfcConstants.COMMODITY_MUST_COMPARE_ORDER_CONFIG.PARAM_CONFIG_CODE);
            qryCodeBo.setCode(itemDo.getItemValue());
            //字典查询
            UocSysDictionaryDo dic = iUocSysDictionaryModel.getModelBy(qryCodeBo);
            rspBo.setNeedCompare(itemDo.getItemValue());
            rspBo.setNeedCompareStr(dic.getDescrip());
            rspBo.setOpDate(itemDo.getCreateTime());
            rspBo.setOpUserId(itemDo.getCreateId());
            rspBo.setOpUserName(itemDo.getCreateName());
            rspBo.setItemId(itemDo.getItemId());
        }
        return rspBo;
    }
}


