package com.tydic.dyc.oc.model.audit;

import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalLogQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.audit.sub.UocAuditOrder;
import com.tydic.dyc.oc.model.order.sub.UocOrderBusiOperRecord;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;

import java.util.List;

/**
 * 标题:IUocApproveModel
 * 说明:审批模块
 * 时间:2022/3/10 17:14
 * 作者:田桂银
 */
public interface IUocAuditOrderModel {


    /**
     * 描述:保存审批数据
     * @param orderDo 入参
     * @return com.tydic.dyc.oc.model.audit.UocAuditOrderDo
     * @author tgy
     * @date 2022/3/10 17:23
     */
    UocAuditOrderDo saveAudit(UocAuditOrderDo orderDo);


    /**
     * 描述:更新流程实例数据
     * @param inst 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderProcInst
     * @author tgy
     * @date 2022/3/10 19:39
     */
    UocOrderProcInst updateProInst(UocOrderProcInst inst);


    /**
     * 描述:更新审批单数据
     * @param updateDo 入参
     * @return com.tydic.dyc.oc.model.audit.UocAuditOrderDo
     * @author tgy
     * @date 2022/3/10 19:52
     */
    UocAuditOrderDo updateApprove(UocAuditOrderDo updateDo);

    /**
     * 描述:保存业务操作数据
     * @param recordList 入参
     * @return void
     * @author tgy
     * @date 2022/3/10 20:16
     */
    void saveOperRecord(List<UocOrderBusiOperRecord> recordList);


    /**
     * 描述: 查询
     * @param obj 入参
     * @return java.util.List<com.tydic.dyc.oc.model.audit.sub.UocApprovalObj>
     * @author tgy
     * @date 2022/3/10 21:18
     */
    List<UocApprovalObj> qryApprovealObj(UocApprovalObjQryBo obj);

    /**
     * 描述: 查询审批单列表
     * @param qryBo 入参
     * @return java.util.List<com.tydic.dyc.oc.model.audit.sub.UocAuditOrder>
     * @author tgy
     * @date 2022/3/10 21:18
     */
    List<UocAuditOrder> qryAuditOrderList(UocAuditOrderQryBo qryBo);

    void saveAuditLog(UocAuditOrderDo orderDo);

    /**
     * 查询审批日志
     * @author wenle
     * @date 2022-04-07 20:32:11
     * @param uocApprovalLogQryBo 入参
     * @return com.tydic.dyc.oc.model.audit.UocAuditOrderDo
     */
    UocAuditOrderDo qryApprovalLog(UocApprovalLogQryBo uocApprovalLogQryBo);

    /**
     * 审批单查询
     * @param qryBo
     * @return
     */
    UocAuditOrderDo qryAuditOrder(UocAuditOrderQryBo qryBo);
}
