package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderProcInsUpdateStatusDomainServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderProcInsUpdateStatusDomainServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * 描述: 〈领域服务-销售单任务提交（单条）实现〉
 *
 * @author : yuhao
 * @date : 2022/7/26 18:42
 */
@HTServiceImpl
public class UocCreateOrderProcInsUpdateStatusDomainServiceImpl implements UocCreateOrderProcInsUpdateStatusDomainService {

    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Override
    public UocCreateOrderProcInsUpdateStatusDomainServiceRspBo createOrderProcIns(UocCreateOrderProcInsUpdateStatusDomainServiceReqBo reqBo) {
        UocCommonDo uocCommonDo = UocRu.js(reqBo, UocCommonDo.class);
        UocCommonDo uocCommonDoRsp = this.iUocCommonModel.dealTask(uocCommonDo);
        UocCreateOrderProcInsUpdateStatusDomainServiceRspBo rspBo =
                UocRu.success(UocCreateOrderProcInsUpdateStatusDomainServiceRspBo.class);
        rspBo.setFinishTaskInfoBos(uocCommonDoRsp.getFinishTaskInfoBos());
        if (!CollectionUtils.isEmpty(reqBo.getNextTaskInfos())) {
            rspBo.setOrderId(reqBo.getOrderId());
            rspBo.setSaleOrderId(reqBo.getNextTaskInfos().get(0).getBusiObjId());
        }
        return rspBo;
    }

}


