package com.tydic.dyc.oc.model.order.qrybo;

import com.tydic.dyc.base.bo.BasePageReqBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 标题:UocOrderRelQryBo
 * 说明:订单外部关联领域对象
 * 时间:2022-02-21 19:10
 * 作者:罗有
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class UocOrderRelQryBo extends BasePageReqBo {
	private static final long serialVersionUID =  8973839140021191124L;

	@DocField(value = "ID")
	private Long id;

	@DocField(value = "订单ID")
	private Long orderId;

	@DocField(value = "关联对象id")
	private Long objId;

	@DocField(value = "关联对象类型 1.订单 2.销售单 3.执行单 4.发货单 5.收货单 6.售后服务单 7.支付单 99.其他")
	private Integer objType;

	@DocField(value = "关联ID")
	private String relId;

	@DocField(value = "关联类型 0普通开票 1上游开票 2服务费")
	private Integer relType;

	@DocField(value = "关联状态 0未提交 1已提交 2挂起 ")
	private Integer relStatus;

	@DocField(value = "订单来源系统")
	private String orderSystem;

	@DocField(value = "删除标志1已删除")
	private Integer delTag;

	@DocField(value = "排序")
	private String orderBy;

	@DocField(value = "关联类型 0普通开票 1上游开票 2服务费")
	private List<Integer> relTypeList;

}
