package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleGoodsAfterTakeTypeBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocAfterServiceTypeQryServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocAfterTakeTypeBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocAfterTakeTypeQryServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocAfterTakeTypeQryServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@HTServiceImpl
@Slf4j
public class UocAfterTakeTypeQryServiceImpl implements UocAfterTakeTypeQryService{
    
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    /**
     * 售后返回方式查询
     *
     * @param reqBo
     * @return
     */
    @Override
    public UocAfterTakeTypeQryServiceRspBo qryAfterServiceType(UocAfterTakeTypeQryServiceReqBo reqBo) {
        UocAfterTakeTypeQryServiceRspBo rspBo = UocRu.success(UocAfterTakeTypeQryServiceRspBo.class);
    
        //字典查询封装数据
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocDicConstant.SERVICE_TYPE.P_CODE);
        Map<String, Map<String, String>> dicMap = iUocSysDictionaryModel.getDictionaryMap(pCodes);
        Map<String, String> serviceMaps = dicMap.get(UocDicConstant.TAKE_TYPE.P_CODE);
        
        List<Long> saleOrderItemIds = reqBo.getOrdItemList();
        List<UocAfterTakeTypeBo> takTypes = new ArrayList<>();
        saleOrderItemIds.forEach(e->{
            UocSaleGoodsAfterTakeTypeBo takeTypeBo = new UocSaleGoodsAfterTakeTypeBo();
            takeTypeBo.setSaleOrderItemId(e);
            List<UocSaleGoodsAfterTakeTypeBo> takeTypeBos = iUocSaleOrderModel.qryCommityTakeTypes(takeTypeBo);
            takeTypeBos.forEach(t->{
                UocAfterTakeTypeBo uocAfterTakeTypeBo = new UocAfterTakeTypeBo();
                uocAfterTakeTypeBo.setPickwareType(t.getAfterTakeType());
                uocAfterTakeTypeBo.setPickwareTypeName(serviceMaps.get(t.getAfterTakeType()).toString());
                uocAfterTakeTypeBo.setSaleOrderItemId(t.getSaleOrderItemId());
                takTypes.add(uocAfterTakeTypeBo);
            });
        });
        rspBo.setAfterTakeList(takTypes);
        return rspBo;
    }
}
