/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocMsgCreateVoterService;
import com.tydic.dyc.oc.service.domainservice.bo.UocArriveInfoBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgCreateVoterReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgCreateVoterRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.UocOrderPropertiesUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocMsgCreateVoterService"})
public class UocMsgCreateVoterServiceImpl
implements UocMsgCreateVoterService {
    private static final Logger log = LoggerFactory.getLogger(UocMsgCreateVoterServiceImpl.class);
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    @PostMapping(value={"createVoter"})
    public UocMsgCreateVoterRspBo createVoter(@RequestBody UocMsgCreateVoterReqBo reqBo) {
        log.info("\u59a5\u6295\u62d2\u6536\u72b6\u6001\u4fee\u6539\u63a5\u53e3\u53c2\u6570\u4e3a\uff1a{}", (Object)reqBo.toString());
        UocMsgCreateVoterRspBo rspBo = new UocMsgCreateVoterRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        this.createCoreVoter(reqBo, rspBo);
        log.info("\u59a5\u6295\u62d2\u6536\u72b6\u6001\u4fee\u6539\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", (Object)rspBo.toString());
        if (!StringUtils.isBlank((CharSequence)rspBo.getTaskInstId())) {
            UocCommonDo uocCommonDo = new UocCommonDo();
            ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(rspBo.getTaskInstId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(11111L);
            uocCommonDo.setOrderId(reqBo.getOrderId());
            this.iUocCommonModel.dealTask(uocCommonDo);
        }
        return rspBo;
    }

    public void createCoreVoter(UocMsgCreateVoterReqBo reqBo, UocMsgCreateVoterRspBo rspBo) {
        try {
            this.delieveredCoreReject(reqBo, rspBo);
        }
        catch (Exception e) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delieveredCoreReject(UocMsgCreateVoterReqBo reqBo, UocMsgCreateVoterRspBo rspBO) {
        this.validateArg(reqBo);
        UocOrderQueryIndexQryBo uocOrderQueryIndexQryBo = new UocOrderQueryIndexQryBo();
        ArrayList<UocOrderQueryIndexQryBo> uocOrderQueryIndexBoList = new ArrayList<UocOrderQueryIndexQryBo>();
        UocDMsgPoolQryBo msgPoolQryBo = new UocDMsgPoolQryBo();
        if (!UocOrderPropertiesUtil.getProperty("SUPPLIER_JD_ID").equals(String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo())) && !UocOrderPropertiesUtil.getProperty("SUPPLIER_SUNING_ID").equals(String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo()))) {
            msgPoolQryBo.setPackageId(reqBo.getDycUocQryMsgBO().getOutOrderId());
            msgPoolQryBo = this.iUocOrderModel.getMsgList(msgPoolQryBo).get(0);
        } else {
            msgPoolQryBo.setMsgType(12);
            msgPoolQryBo.setOutOrderId(reqBo.getDycUocQryMsgBO().getOutOrderId());
            msgPoolQryBo = this.iUocOrderModel.getMsgList(msgPoolQryBo).get(0);
            if (ObjectUtil.isEmpty((Object)msgPoolQryBo)) {
                msgPoolQryBo.setMsgType(18);
                msgPoolQryBo.setOutOrderId(reqBo.getDycUocQryMsgBO().getOutOrderId());
                msgPoolQryBo = this.iUocOrderModel.getMsgList(msgPoolQryBo).get(0);
            }
        }
        if (!ObjectUtil.isNotEmpty((Object)msgPoolQryBo)) {
            rspBO.setRespCode("101002");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5916\u90e8\u8ba2\u5355[" + reqBo.getDycUocQryMsgBO().getOutOrderId() + "\u5bf9\u5e94\u7684\u53d1\u8d27\u4fe1\u606f");
            return;
        }
        if (!UocOrderPropertiesUtil.getProperty("SUPPLIER_JD_ID").equals(String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo())) && !UocOrderPropertiesUtil.getProperty("SUPPLIER_SUNING_ID").equals(String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo()))) {
            uocOrderQueryIndexQryBo.setOutObjId(msgPoolQryBo.getPackageId());
        } else {
            uocOrderQueryIndexQryBo.setOutObjId(msgPoolQryBo.getOutOrderId());
        }
        uocOrderQueryIndexQryBo.setOrderId(msgPoolQryBo.getOrderId());
        uocOrderQueryIndexQryBo.setOrderSystem(UocDicConstant.OBJ_TYPE.SHIP.toString());
        List<UocOrderQueryIndex> uocOrderQueryIndexList = this.iUocOrderModel.qryOrderQueryIndexList(uocOrderQueryIndexQryBo);
        if (!ObjectUtil.isNotEmpty(uocOrderQueryIndexList)) {
            rspBO.setRespCode("101002");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5916\u90e8\u8ba2\u5355[" + reqBo.getDycUocQryMsgBO().getOutOrderId() + "\u5bf9\u5e94\u7684\u5173\u8054\u4fe1\u606f");
            return;
        }
        for (UocOrderQueryIndex item : uocOrderQueryIndexList) {
            uocOrderQueryIndexBoList.add(UocRu.js(item, UocOrderQueryIndexQryBo.class));
        }
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getDycUocQryMsgBO().getObjId());
        uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (uocSaleOrderDo == null) {
            rspBO.setRespCode("101002");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5916\u90e8\u8ba2\u5355[" + reqBo.getDycUocQryMsgBO().getOutOrderId() + "\u5bf9\u5e94\u7684\u9500\u552e\u8ba2\u5355\u4fe1\u606f");
            return;
        }
        Long saleVoucherId = uocSaleOrderDo.getSaleOrderId();
        Long orderId = uocSaleOrderDo.getOrderId();
        Long shipVoucherId = ((UocOrderQueryIndexQryBo)uocOrderQueryIndexBoList.get(0)).getObjId();
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(orderId);
        uocShipOrderQryBo.setShipOrderId(shipVoucherId);
        List<UocShipOrderDo> shipOrderDoList = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        if (ObjectUtil.isEmpty(shipOrderDoList)) {
            rspBO.setRespCode("101002");
            rspBO.setRespDesc("\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u53d1\u8d27\u5355\u4fe1\u606f!");
            return;
        }
        UocShipOrderDo uocShipOrderDo = shipOrderDoList.get(0);
        try {
            this.executeArriveRegist(reqBo, uocShipOrderDo, rspBO);
        }
        catch (Exception e) {
            throw new BaseBusinessException("101002", e.getMessage());
        }
        boolean isAllReceive = this.judgeIsAllReceive(orderId, saleVoucherId);
        BigDecimal totalRefuseAmout = new BigDecimal(0);
        boolean isAllRefuse = this.judgeIsAllRefuse(orderId, totalRefuseAmout, saleVoucherId);
        UocOrderStakeholderQryBo stakeholderQryBo = new UocOrderStakeholderQryBo();
        stakeholderQryBo.setStakeholderId(uocSaleOrderDo.getStakeholderId());
        List<UocOrderStakeholderQryBo> stakeholderQryBoList = this.iUocOrderModel.qryStakeholderList(stakeholderQryBo);
        String purOrgId = stakeholderQryBoList.get(0).getPurOrgId();
        try {
            UocSaleOrderDo saleOrderDo = new UocSaleOrderDo();
            saleOrderDo.setSaleOrderId(saleVoucherId);
            saleOrderDo.setOrderId(orderId);
            saleOrderDo.setUpdateTime(new Date());
            UocShipOrderDo shipOrderDo = new UocShipOrderDo();
            shipOrderDo.setShipOrderId(shipVoucherId);
            shipOrderDo.setOrderId(orderId);
            if (isAllReceive && reqBo.getDycUocQryMsgBO().getMsgState().equals(1)) {
                saleOrderDo.setSaleOrderState("XS_DH_DH");
                shipOrderDo.setShipOrderState("FH_FH_YDH");
                this.iUocShipOrderModel.modifyShipOrderMain(shipOrderDo);
                this.iUocSaleOrderModel.modifySaleOrderMain(saleOrderDo);
            } else if (reqBo.getDycUocQryMsgBO().getMsgState().equals(1) && !isAllReceive) {
                shipOrderDo.setShipOrderState("FH_FH_YDH");
                this.iUocShipOrderModel.modifyShipOrderMain(shipOrderDo);
            } else if (reqBo.getDycUocQryMsgBO().getMsgState().equals(2) && isAllRefuse) {
                saleOrderDo.setSaleOrderState("XS_DH_JS");
                shipOrderDo.setShipOrderState("FH_FH_JS");
                this.iUocShipOrderModel.modifyShipOrderMain(shipOrderDo);
                this.iUocSaleOrderModel.modifySaleOrderMain(saleOrderDo);
            } else if (reqBo.getDycUocQryMsgBO().getMsgState().equals(2) && !isAllRefuse) {
                shipOrderDo.setShipOrderState("FH_FH_JS");
                this.iUocShipOrderModel.modifyShipOrderMain(shipOrderDo);
            }
            if (isAllReceive) {
                UocSaleOrderItemQryBo saleOrderItemQryBo = new UocSaleOrderItemQryBo();
                saleOrderItemQryBo.setOrderId(orderId);
                saleOrderItemQryBo.setSaleOrderId(saleVoucherId);
                List<UocSaleOrderItem> saleOrderItems = this.iUocSaleOrderModel.getSaleOrderItemList(saleOrderItemQryBo);
                BigDecimal totalPurchaseCount = new BigDecimal(0);
                BigDecimal totalArriveCount = new BigDecimal(0);
                BigDecimal totalRefuseCount = new BigDecimal(0);
                for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
                    totalPurchaseCount = totalPurchaseCount.add(saleOrderItem.getPurchaseCount());
                    totalArriveCount = totalArriveCount.add(saleOrderItem.getArriveCount());
                    totalRefuseCount = totalRefuseCount.add(saleOrderItem.getRefuseCount());
                }
                if (totalRefuseCount.compareTo(BigDecimal.ZERO) != 0 && totalArriveCount.compareTo(BigDecimal.ZERO) != 0) {
                    saleOrderDo.setSaleOrderState("XS_DH_BFDH");
                }
                this.iUocSaleOrderModel.modifySaleOrderMain(saleOrderDo);
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u9500\u552e\u5355\u72b6\u6001\u5f02\u5e38: {}", (Throwable)e);
            rspBO.setRespCode("101002");
            rspBO.setRespDesc("\u66f4\u65b0\u9500\u552e\u5355\u72b6\u6001\u5f02\u5e38!");
            return;
        }
        rspBO.setSaleOrderId(saleVoucherId);
        rspBO.setShipOrderId(uocShipOrderDo.getShipOrderId());
        rspBO.setOrderId(orderId);
        rspBO.setTotalRefuseAmout(totalRefuseAmout);
        rspBO.setPurOrgId(purOrgId);
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        taskInstQryBo.setObjId(uocShipOrderDo.getShipOrderId());
        taskInstQryBo.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        List<UocOrderTaskInst> taskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if (ObjectUtil.isNotEmpty(taskInsts)) {
            rspBO.setTaskInstId(taskInsts.get(0).getTaskInstId());
            rspBO.setStepId(taskInsts.get(0).getProcState());
        }
        UocDMsgPoolQryBo qryBo = new UocDMsgPoolQryBo();
        qryBo.setId(reqBo.getDycUocQryMsgBO().getId());
        qryBo.setRunResult(1);
        this.iUocOrderModel.updateMsgPoolById(qryBo);
    }

    public boolean judgeIsAllReceive(Long orderId, Long saleVoucherId) {
        boolean isAllReceive = true;
        UocSaleOrderItemQryBo saleOrderItemQryBo = new UocSaleOrderItemQryBo();
        saleOrderItemQryBo.setOrderId(orderId);
        saleOrderItemQryBo.setSaleOrderId(saleVoucherId);
        List<UocSaleOrderItem> saleOrderItems = this.iUocSaleOrderModel.getSaleOrderItemList(saleOrderItemQryBo);
        if (saleOrderItems == null || saleOrderItems.isEmpty()) {
            throw new BaseBusinessException("101002", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u4e3a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f!");
        }
        BigDecimal totalPurchaseCount = new BigDecimal(0);
        BigDecimal totalArriveCount = new BigDecimal(0);
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            totalPurchaseCount = totalPurchaseCount.add(saleOrderItem.getPurchaseCount());
            BigDecimal arriveCount = saleOrderItem.getArriveCount().add(saleOrderItem.getRefuseCount());
            totalArriveCount = totalArriveCount.add(arriveCount);
        }
        if (totalArriveCount.compareTo(totalPurchaseCount) != 0) {
            isAllReceive = false;
        }
        log.info("------------------------\u662f\u5426\u662f\u5168\u90e8\u5230\u8d27\u72b6\u6001\u503c\uff1a" + isAllReceive);
        return isAllReceive;
    }

    public boolean judgeIsAllRefuse(Long orderId, BigDecimal totalRefuseAmout, Long saleVoucherId) {
        boolean isAllRefuse = true;
        UocSaleOrderItemQryBo saleOrderItemQryBo = new UocSaleOrderItemQryBo();
        saleOrderItemQryBo.setOrderId(orderId);
        saleOrderItemQryBo.setSaleOrderId(saleVoucherId);
        List<UocSaleOrderItem> saleOrderItems = this.iUocSaleOrderModel.getSaleOrderItemList(saleOrderItemQryBo);
        if (saleOrderItems == null || saleOrderItems.isEmpty()) {
            throw new BaseBusinessException("101002", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u4e3a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f!");
        }
        BigDecimal totalPurchaseCount = new BigDecimal(0);
        BigDecimal totalRefuseCount = new BigDecimal(0);
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            totalPurchaseCount = totalPurchaseCount.add(saleOrderItem.getPurchaseCount());
            totalRefuseCount = totalRefuseCount.add(saleOrderItem.getRefuseCount());
            totalRefuseAmout = totalRefuseAmout.add(saleOrderItem.getRefuseCount().multiply(saleOrderItem.getSalePrice().setScale(2)));
        }
        if (totalRefuseCount.compareTo(totalPurchaseCount) != 0) {
            isAllRefuse = false;
        }
        return isAllRefuse;
    }

    public void executeArriveRegist(UocMsgCreateVoterReqBo reqBo, UocShipOrderDo uocShipOrderDo, UocMsgCreateVoterRspBo rspBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        ArrayList<UocArriveInfoBO> arriveInfoBOList = new ArrayList<UocArriveInfoBO>();
        uocShipOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        UocShipOrderDo uocShipOrderDo1 = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        List<UocShipOrderItem> shipOrderItemBoList = uocShipOrderDo1.getShipOrderItemBoList();
        boolean notArrive = false;
        for (UocShipOrderItem shipOrderItem : shipOrderItemBoList) {
            UocArriveInfoBO arriveInfoBO = new UocArriveInfoBO();
            if (reqBo.getDycUocQryMsgBO().getMsgState().equals(2)) {
                arriveInfoBO.setRejectCount(shipOrderItem.getSendCount());
                arriveInfoBO.setShipItemId(shipOrderItem.getShipOrderItemId());
            } else if (reqBo.getDycUocQryMsgBO().getMsgState().equals(1)) {
                arriveInfoBO.setArriveCount(shipOrderItem.getSendCount());
                arriveInfoBO.setShipItemId(shipOrderItem.getShipOrderItemId());
                if (shipOrderItem.getArriveCount() != null && shipOrderItem.getSendCount().compareTo(shipOrderItem.getArriveCount()) <= 0) {
                    notArrive = true;
                }
            }
            arriveInfoBOList.add(arriveInfoBO);
        }
        if (!notArrive) {
            this.arriveRegist(uocShipOrderDo, arriveInfoBOList, rspBo);
            this.updateShipArriveTime(uocShipOrderDo.getOrderId(), uocShipOrderDo.getShipOrderId());
        }
    }

    public void arriveRegist(UocShipOrderDo uocShipOrderDo, List<UocArriveInfoBO> arriveInfoBOList, UocMsgCreateVoterRspBo rspBO) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        UocShipOrderDo shipOrderItemDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        List<UocShipOrderItem> ordShipItemList = shipOrderItemDo.getShipOrderItemBoList();
        for (UocShipOrderItem shipOrderItem : ordShipItemList) {
            BigDecimal totalCount = new BigDecimal(0);
            if ((totalCount = totalCount.add(shipOrderItem.getArriveCount()).add(shipOrderItem.getRefuseCount())).compareTo(shipOrderItem.getSendCount()) <= 0) continue;
            throw new BaseBusinessException("101002", "\u7535\u5546\u59a5\u6295\u8fdb\u884c\u5230\u8d27\u767b\u8bb0\u53d1\u8d27\u660e\u7ec6\u3010\u5230\u8d27\u6570\u91cf+\u62d2\u6536\u6570\u91cf>=\u53d1\u8d27\u6570\u91cf\u3011\uff01");
        }
        for (UocArriveInfoBO bo : arriveInfoBOList) {
            UocShipOrderItem uocShipOrderItem;
            UocShipOrderDo shipArriveDo = new UocShipOrderDo();
            ArrayList<UocShipOrderItem> shipOrderItemBoList = new ArrayList<UocShipOrderItem>();
            shipArriveDo.setShipOrderItemBoList(shipOrderItemBoList);
            if (bo.getArriveCount() != null) {
                uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setArriveCount(bo.getArriveCount());
                uocShipOrderItem.setShipItemState("FH_FH_YDH");
                uocShipOrderItem.setShipOrderItemId(bo.getShipItemId());
                shipOrderItemBoList.add(uocShipOrderItem);
            }
            if (bo.getRejectCount() != null) {
                uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setRefuseCount(bo.getRejectCount());
                uocShipOrderItem.setShipItemState("FH_FH_JS");
                uocShipOrderItem.setShipOrderItemId(bo.getShipItemId());
                uocShipOrderItem.setShipOrderItemId(bo.getShipItemId());
                shipOrderItemBoList.add(uocShipOrderItem);
            }
            this.iUocShipOrderModel.modifyItemArriveCount(shipArriveDo);
            uocShipOrderItemQryBo.setShipOrderItemId(bo.getShipItemId());
            List<UocShipOrderItem> shipOrderItemList = this.iUocShipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);
            for (UocShipOrderItem shipOrderItem : shipOrderItemList) {
                UocSaleOrderItem saleOrderItem;
                Long saleOrderItemId = shipOrderItem.getSaleOrderItemId();
                log.info("\u66f4\u65b0\u9500\u552e\u5355\u660e\u7ec6\u4e3a {} \u7684\u5230\u8d27\u6570\u91cf", (Object)saleOrderItemId);
                UocSaleOrderDo saleOrderDo = new UocSaleOrderDo();
                saleOrderDo.setOrderId(uocShipOrderDo.getOrderId());
                ArrayList<UocSaleOrderItem> saleItemList = new ArrayList<UocSaleOrderItem>();
                saleOrderDo.setSaleOrderItems(saleItemList);
                if (bo.getArriveCount() != null) {
                    saleOrderItem = new UocSaleOrderItem();
                    saleOrderItem.setArriveCount(bo.getArriveCount());
                    saleOrderItem.setSaleOrderItemId(saleOrderItemId);
                    saleItemList.add(saleOrderItem);
                }
                if (bo.getRejectCount() != null) {
                    saleOrderItem = new UocSaleOrderItem();
                    saleOrderItem.setRefuseCount(bo.getRejectCount());
                    saleOrderItem.setSaleOrderItemId(saleOrderItemId);
                    saleItemList.add(saleOrderItem);
                }
                this.iUocSaleOrderModel.updateSaleItemArriveAccount(saleOrderDo);
            }
        }
    }

    public void updateShipArriveTime(Long orderId, Long shipOrderId) {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderId(orderId);
        uocShipOrderDo.setShipOrderId(shipOrderId);
        uocShipOrderDo.setArriveTime(new Date());
        this.iUocShipOrderModel.modifyShipArrivtime(uocShipOrderDo);
    }

    private void validateArg(UocMsgCreateVoterReqBo reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("100001", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getDycUocQryMsgBO().getOutOrderId())) {
            throw new BaseBusinessException("100001", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010outOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getDycUocQryMsgBO().getSupNo() == null) {
            throw new BaseBusinessException("100001", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010supNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getDycUocQryMsgBO().getMsgState() == null) {
            throw new BaseBusinessException("100001", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010msgState\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

