/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocEvaluateQryBo;
import com.tydic.dyc.oc.model.order.sub.UocEvaluate;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.UocEvaluateDealService;
import com.tydic.dyc.oc.service.domainservice.bo.UocEvaluateDealServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEvaluateDealServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocEvaluateDealService"})
public class UocEvaluateDealServiceImpl
implements UocEvaluateDealService {
    private static final Logger log = LoggerFactory.getLogger(UocEvaluateDealServiceImpl.class);
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"dealEvaluate"})
    public UocEvaluateDealServiceRspBo dealEvaluate(@RequestBody UocEvaluateDealServiceReqBo reqBo) {
        this.verifyParam(reqBo);
        Long saleOrderId = null;
        Long orderId = null;
        if (null != reqBo.getSaleOrderId() && null != reqBo.getOrderId()) {
            saleOrderId = reqBo.getSaleOrderId();
            orderId = reqBo.getOrderId();
        } else {
            UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
            querySaleOrderDo.setSaleOrderNo(reqBo.getSaleOrderNo());
            UocSaleOrderDo saleOrderMainInfo = this.iUocSaleOrderModel.getSaleOrderMain(querySaleOrderDo);
            if (null != saleOrderMainInfo) {
                saleOrderId = saleOrderMainInfo.getSaleOrderId();
                orderId = saleOrderMainInfo.getOrderId();
            } else {
                throw new BaseBusinessException("100001", "\u6839\u636e\u9500\u552e\u5355\u7f16\u53f7\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u5931\u8d25");
            }
        }
        List<UocEvaluate> saleOrderEvaluateInfo = this.querySaleOrderEvaluateInfo(saleOrderId, orderId);
        if (CollectionUtils.isNotEmpty(saleOrderEvaluateInfo)) {
            for (UocEvaluate uocEvaluate : saleOrderEvaluateInfo) {
                UocEvaluate updateEva = new UocEvaluate();
                updateEva.setId(uocEvaluate.getId());
                updateEva.setEvaluateState(reqBo.getEvaluateState());
                this.iUocOrderModel.updateOrderEvaluate(updateEva);
            }
        } else {
            UocEvaluate addEvaluate = new UocEvaluate();
            addEvaluate.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            addEvaluate.setId(IdUtil.nextId());
            addEvaluate.setOrderId(orderId);
            addEvaluate.setCreateOperId(String.valueOf(reqBo.getUserId()));
            addEvaluate.setEvaluateState(reqBo.getEvaluateState());
            addEvaluate.setObjId(saleOrderId);
            this.iUocOrderModel.insertOrderEvaluate(addEvaluate);
        }
        UocEvaluateDealServiceRspBo rspBo = new UocEvaluateDealServiceRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setOrderId(orderId);
        rspBo.setSaleOrderId(saleOrderId);
        return rspBo;
    }

    private List<UocEvaluate> querySaleOrderEvaluateInfo(Long saleOrderId, Long orderId) {
        UocEvaluateQryBo uocEvaluateQryBo = new UocEvaluateQryBo();
        uocEvaluateQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocEvaluateQryBo.setObjId(saleOrderId);
        uocEvaluateQryBo.setOrderId(orderId);
        List<UocEvaluate> uocEvaluates = this.iUocOrderModel.qryOrderEvaluateList(uocEvaluateQryBo);
        return uocEvaluates;
    }

    private void verifyParam(UocEvaluateDealServiceReqBo reqBo) {
        if (ObjectUtil.isNull((Object)reqBo)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getSaleOrderNo())) {
            if (reqBo.getOrderId() == null) {
                throw new BaseBusinessException("100001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBo.getSaleOrderId() == null) {
                throw new BaseBusinessException("100001", "\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (reqBo.getEvaluateState() == null) {
            throw new BaseBusinessException("100001", "\u8bc4\u4ef7\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

