package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocDistSaleOrderReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocDistSaleOrderRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 描述: 〈领域服务-销售单分配实现〉
 * @author : yuhao
 * @date : 2022/7/22 16:15
 */
@HTServiceImpl
public class UocDistSaleOrderServiceImpl implements UocDistSaleOrderService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Override
    public UocDistSaleOrderRspBo distSaleOrder(UocDistSaleOrderReqBo reqBo) {
        UocDistSaleOrderRspBo rspBo = new UocDistSaleOrderRspBo();
        // 入参校验
        this.verifyParam(reqBo);
        // 更新销售单表协议经办人信息
        this.updateSaleOrderInfo(reqBo);
        //提交订单任务
        this.submitOrderTask(reqBo);

        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBo;
    }

    /**
     * 提交订单任务
     * @param reqBo
     */
    private void submitOrderTask(UocDistSaleOrderReqBo reqBo){
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskList = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        task.setTaskId(reqBo.getTaskId());
        taskList.add(task);
        uocCommonDo.setCompleteTaskInfos(taskList);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }

    /**
     * 更新销售单协议经办人
     * @param reqBo
     */
    private void updateSaleOrderInfo(UocDistSaleOrderReqBo reqBo){
        UocSaleOrderDo updateUocSaleOrder = new UocSaleOrderDo();
        BeanUtils.copyProperties(reqBo,updateUocSaleOrder);
        updateUocSaleOrder.setUpdateTime(new Date());
        updateUocSaleOrder.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        updateUocSaleOrder.setUpdateOperName(reqBo.getName());
        this.iUocSaleOrderModel.modifySaleOrderMain(updateUocSaleOrder);
    }

    /**
     * 入参校验
     */
    private void verifyParam(UocDistSaleOrderReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getUserId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "当前登录人id不能为空");
        }
        if(StringUtils.isEmpty(reqBo.getName())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "当前登录人名称不能为空");
        }
        if(StringUtils.isEmpty(reqBo.getProDeliveryId())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "协议经办人id不能为空");
        }
        if(StringUtils.isEmpty(reqBo.getProDeliveryName())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "协议经办人名称不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单id不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单id不能为空");
        }
        if(StringUtils.isEmpty(reqBo.getTaskId())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "任务id不能为空");
        }
    }
}
