/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.domainservice.UocAdjustPriceOrderCreateService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAdjustPriceOrderCreateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAdjustPriceOrderCreateRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocAdjustPriceOrderCreateService"})
public class UocAdjustPriceOrderCreateServiceImpl
implements UocAdjustPriceOrderCreateService {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"createAdjustPriceOrder"})
    public UocAdjustPriceOrderCreateRspBo createAdjustPriceOrder(@RequestBody UocAdjustPriceOrderCreateReqBo reqBo) {
        this.verifyParam(reqBo);
        if (UocConstant.ADJUST_FLAG.YES.equals(reqBo.getAdjustFlag())) {
            Long changeOrderId = this.createAdjustChangeOrder(reqBo);
            this.updateSaleOrderMainInfo(reqBo, UocConstant.ADJUST_PRICE.MIDDLE_ADJUST);
            this.submitProcessTask(reqBo);
            UocAdjustPriceOrderCreateRspBo rspBo = new UocAdjustPriceOrderCreateRspBo();
            rspBo.setChngOrderId(changeOrderId);
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        if (UocConstant.ADJUST_FLAG.NO.equals(reqBo.getAdjustFlag())) {
            this.updateSaleOrderMainInfo(reqBo, UocConstant.ADJUST_PRICE.NO_ADJUST);
            this.submitProcessTask(reqBo);
            UocAdjustPriceOrderCreateRspBo rspBo = new UocAdjustPriceOrderCreateRspBo();
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        throw new BaseBusinessException("100001", "\u9519\u8bef\u7684\u8c03\u4ef7\u6807\u8bc6\uff0c\u65e0\u6cd5\u8bc6\u522b");
    }

    private void submitProcessTask(UocAdjustPriceOrderCreateReqBo reqBo) {
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskList = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        task.setTaskId(reqBo.getTaskId());
        taskList.add(task);
        uocCommonDo.setCompleteTaskInfos(taskList);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }

    private void updateSaleOrderMainInfo(UocAdjustPriceOrderCreateReqBo reqBo, Integer adjustPrice) {
        UocSaleOrderDo updateUocSaleOrderDo = new UocSaleOrderDo();
        updateUocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateUocSaleOrderDo.setOrderId(reqBo.getOrderId());
        updateUocSaleOrderDo.setAdjustPrice(adjustPrice);
        updateUocSaleOrderDo.setAdjustPriceOperId(String.valueOf(reqBo.getUserId()));
        updateUocSaleOrderDo.setAdjustPriceOperName(reqBo.getName());
        updateUocSaleOrderDo.setAdjustPriceTime(new Date());
        this.iUocSaleOrderModel.modifySaleOrderMain(updateUocSaleOrderDo);
    }

    private Long createAdjustChangeOrder(UocAdjustPriceOrderCreateReqBo reqBo) {
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        Long changeOrderId = IdUtil.nextId();
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        uocChngOrderDo.setChngOrderId(changeOrderId);
        uocChngOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        uocChngOrderDo.setCreateOperName(reqBo.getName());
        uocChngOrderDo.setCreateTime(new Date());
        uocChngOrderDo.setRemark(reqBo.getRemark());
        uocChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.PRICE_CHG);
        Long changeOrderObjectId = IdUtil.nextId();
        ArrayList<UocChngOrderObj> uocChngOrderObjList = new ArrayList<UocChngOrderObj>();
        UocChngOrderObj uocChngOrderObj = new UocChngOrderObj();
        uocChngOrderObj.setOrderId(reqBo.getOrderId());
        uocChngOrderObj.setChngOrderObjId(changeOrderObjectId);
        uocChngOrderObj.setChngOrderId(changeOrderId);
        uocChngOrderObj.setChngType(UocConstant.BUSI_TYPE.PRICE_CHG);
        uocChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
        uocChngOrderObj.setCreateTime(new Date());
        uocChngOrderObj.setCreateOperId(String.valueOf(reqBo.getUserId()));
        ArrayList<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<UocChngOrderItemObj>();
        for (Object uocAdjustPriceOrderCreateReqItemBo : reqBo.getSaleItemList()) {
            UocChngOrderItemObj uocChngOrderItemObj = new UocChngOrderItemObj();
            uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
            uocChngOrderItemObj.setChngOrderId(changeOrderId);
            uocChngOrderItemObj.setChngOrderObjId(changeOrderObjectId);
            uocChngOrderItemObj.setId(IdUtil.nextId());
            uocChngOrderItemObj.setOrderItemId(uocAdjustPriceOrderCreateReqItemBo.getOrderItemId());
            uocChngOrderItemObj.setSaleOrderItemId(uocAdjustPriceOrderCreateReqItemBo.getSaleOrderItemId());
            uocChngOrderItemObj.setChngType(UocConstant.BUSI_TYPE.PRICE_CHG);
            if (null != uocAdjustPriceOrderCreateReqItemBo.getAdjustPurchasePrice()) {
                uocChngOrderItemObj.setChngPurchaseFee(uocAdjustPriceOrderCreateReqItemBo.getAdjustPurchasePrice());
            } else {
                uocChngOrderItemObj.setChngPurchaseFee(uocAdjustPriceOrderCreateReqItemBo.getAdjustPrice());
            }
            uocChngOrderItemObj.setChngFee(uocAdjustPriceOrderCreateReqItemBo.getAdjustPrice());
            uocChngOrderItemObj.setCreateOperId(String.valueOf(reqBo.getUserId()));
            uocChngOrderItemObj.setCreateTime(new Date());
            uocChngOrderItemObjList.add(uocChngOrderItemObj);
        }
        uocChngOrderObj.setUocChngOrderItemObjList(uocChngOrderItemObjList);
        uocChngOrderObjList.add(uocChngOrderObj);
        uocChngOrderDo.setUocChngOrderObjList(uocChngOrderObjList);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            ArrayList<UocOrderAccessory> orderAccessoryBoList = new ArrayList<UocOrderAccessory>();
            for (UocBaseOrderAccessoryAddBo uocBaseOrderAccessoryAddBo : reqBo.getOrderAccessoryBoList()) {
                UocOrderAccessory uocOrderAccessory = new UocOrderAccessory();
                BeanUtils.copyProperties((Object)uocBaseOrderAccessoryAddBo, (Object)uocOrderAccessory);
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setObjId(uocChngOrderDo.getChngOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
                uocOrderAccessory.setAttachmentType(UocDicConstant.OBJ_TYPE.CHNG);
                orderAccessoryBoList.add(uocOrderAccessory);
            }
            uocChngOrderDo.setOrderAccessoryBoList(orderAccessoryBoList);
        }
        List<Long> collect = reqBo.getSaleItemList().stream().map(obj -> obj.getSaleOrderItemId()).collect(Collectors.toList());
        UocSaleOrderItemQryBo itemQryBo = new UocSaleOrderItemQryBo();
        itemQryBo.setSaleOrderItemIdList(collect);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(itemQryBo);
        Map<Long, UocSaleOrderItem> listMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        ArrayList<UocChngOrderItemMap> uocChngOrderItemMapList = new ArrayList<UocChngOrderItemMap>();
        reqBo.getSaleItemList().forEach(obj -> {
            UocSaleOrderItem saleOrderItem = (UocSaleOrderItem)((Object)((Object)listMap.get(obj.getSaleOrderItemId())));
            UocChngOrderItemMap chngOrderItemMap = new UocChngOrderItemMap();
            chngOrderItemMap.setChngOrderId(uocChngOrderDo.getChngOrderId());
            chngOrderItemMap.setOrderId(uocChngOrderDo.getOrderId());
            chngOrderItemMap.setChngOrderObjId(saleOrderItem.getSaleOrderItemId());
            chngOrderItemMap.setDelTag(0);
            if (obj.getAdjustPrice() != null) {
                chngOrderItemMap.setId(IdUtil.nextId());
                chngOrderItemMap.setFieldCode("adjustPrice");
                chngOrderItemMap.setFieldName("\u9500\u552e\u4ef7\u53d8\u66f4\u524d");
                chngOrderItemMap.setFieldValue(saleOrderItem.getSalePrice() + "");
                uocChngOrderItemMapList.add(chngOrderItemMap);
            }
            UocChngOrderItemMap chngOrderItemMap1 = new UocChngOrderItemMap();
            BeanUtils.copyProperties((Object)chngOrderItemMap, (Object)chngOrderItemMap1);
            if (obj.getAdjustPurchasePrice() != null) {
                chngOrderItemMap1.setId(IdUtil.nextId());
                chngOrderItemMap1.setFieldCode("adjustPurchasePrice");
                chngOrderItemMap1.setFieldName("\u91c7\u8d2d\u4ef7\u53d8\u66f4\u524d");
                chngOrderItemMap1.setFieldValue(saleOrderItem.getPurchasePrice() + "");
                uocChngOrderItemMapList.add(chngOrderItemMap1);
            }
        });
        uocChngOrderDo.setUocChngOrderItemMapList(uocChngOrderItemMapList);
        this.iUocChngOrderModel.createChngOrder(uocChngOrderDo);
        return changeOrderId;
    }

    private void verifyParam(UocAdjustPriceOrderCreateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5f53\u524d\u767b\u5f55\u4ebaID\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBo.getName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5f53\u524d\u767b\u5f55\u4eba\u540d\u79f0\u4e3a\u7a7a");
        }
        if (null == reqBo.getAdjustFlag()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u662f\u5426\u8c03\u4ef7\u6807\u8bc6\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBo.getTaskId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u4efb\u52a1ID\u4e3a\u7a7a");
        }
    }
}

