package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalLog;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.sub.UocOrderBusiOperRecord;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveMoveServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveMoveServiceReqTaskBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveMoveServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocApproveMoveServiceImpl
 * 说明:
 * 时间:2022/3/10 16:29
 * 作者:田桂银
 */
@HTServiceImpl
public class UocApproveMoveServiceImpl implements UocApproveMoveService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @Override
    public UocApproveMoveServiceRspBo moveApprove(UocApproveMoveServiceReqBo reqBo) {
        UocApproveMoveServiceRspBo rspBo = UocRu.success(UocApproveMoveServiceRspBo.class);

        validateArg(reqBo);

        Date now = new Date();

        //根据orderid和objid查询审批单id
        UocApprovalObjQryBo qryObj = new UocApprovalObjQryBo();
        qryObj.setObjId(reqBo.getObjId().toString());
        qryObj.setOrderId(reqBo.getOrderId());
        qryObj.setObjBusiType(reqBo.getObjBusiType());
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(qryObj);
        if (ObjectUtil.isEmpty(uocApprovalObjs)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "查询审批对象为空");
        }
        Long auditOrderId = uocApprovalObjs.get(0).getAuditOrderId();
        //如果审批通过，且结束，更新流程数据，更新审批单数据 为结束
        Boolean finished = reqBo.getFinished();
        Integer finalResult = reqBo.getFinalResult();
        if (finished) {
            UocOrderProcInst updateInst = new UocOrderProcInst();
            updateInst.setOrderId(reqBo.getOrderId());
            updateInst.setObjId(reqBo.getObjId());
            updateInst.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            updateInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
            updateInst.setFinishTime(now);
            updateInst.setProcInstId(reqBo.getProcInstId());
            updateInst.setProcInstId(reqBo.getProcInstId());
            iUocAuditOrderModel.updateProInst(updateInst);

            UocAuditOrderDo updateApprove = new UocAuditOrderDo();
            updateApprove.setOrderId(reqBo.getOrderId());
            updateApprove.setAuditOrderId(auditOrderId);
            updateApprove.setFinishTime(now);
            updateApprove.setUpdateTime(now);
            updateApprove.setUpdateOperId(reqBo.getUserId().toString());
            updateApprove.setFinalResult(finalResult);
            updateApprove.setAuditOrderStatus(reqBo.getFinalResult().toString());
            iUocAuditOrderModel.updateApprove(updateApprove);
        }

        //保存审批日志
        saveLog(reqBo, now, auditOrderId, finished, finalResult);
        //结束旧任务
        String oldTaskInstId = reqBo.getOldTaskInstId();
        //判断当前状态，是否为未办理
        UocOrderTaskInst qryInst = new UocOrderTaskInst();
        qryInst.setOrderId(reqBo.getOrderId());
        qryInst.setTaskInstId(oldTaskInstId);
        List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(qryInst);
        //不存在，报错
        if (ObjectUtil.isEmpty(uocOrderTaskInsts)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "任务实例id(" + oldTaskInstId + ")不存在");
        }
        //已办，报错
        if (UocDicConstant.PROC_TASK_FINISHED.FINISHED.equals(uocOrderTaskInsts.get(0).getFinishTag())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "任务实例id(" + oldTaskInstId + ")已完结");
        }

        List<UocOrderTaskInst> updateList = new ArrayList<>();
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        updateList.add(uocOrderTaskInst);
        uocOrderTaskInst.setOrderId(reqBo.getOrderId());
        uocOrderTaskInst.setTaskInstId(oldTaskInstId);
        //设置为已办
        iUocSaleOrderModel.updateProcTaskInstToFinished(updateList);


        //保存任务数据，处理数据
        List<UocApproveMoveServiceReqTaskBo> taskBoList = reqBo.getTaskBoList();
        if(ObjectUtil.isNotEmpty(taskBoList)){
            List<UocOrderTaskDeal> saveDealList = new ArrayList<>();
            List<UocOrderTaskInst> saveList = new ArrayList<>();
            for (UocApproveMoveServiceReqTaskBo reqTaskBo : taskBoList) {
                UocOrderTaskInst taskBo = new UocOrderTaskInst();
                taskBo.setId(IdUtil.nextId());
                taskBo.setOrderId(reqBo.getOrderId());
                taskBo.setTaskInstId(reqTaskBo.getTaskInstId());
                taskBo.setObjId(reqBo.getObjId());
                taskBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
                taskBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                saveList.add(taskBo);


                String assignee = reqTaskBo.getAssignee();
                List<String> candidates = reqTaskBo.getCandidates();
                //处理人和候选人
                if (ObjectUtil.isNotEmpty(assignee)) {
                    UocOrderTaskDeal deal = assembleTaskDealObj(reqBo, reqTaskBo);
                    deal.setDealId(assignee);
                    deal.setDealClass(UocDicConstant.TASK_DEAL_CLASS.ASSIGNEE);
                    deal.setDelTag(UocDicConstant.DELETE_TAG.NO_DEL);
                    saveDealList.add(deal);
                } else if (ObjectUtil.isNotEmpty(candidates)) {
                    for (String candidate : candidates) {
                        UocOrderTaskDeal deal = assembleTaskDealObj(reqBo, reqTaskBo);
                        deal.setDealId(candidate);
                        deal.setDealClass(UocDicConstant.TASK_DEAL_CLASS.CANDIDATE);
                        deal.setDelTag(UocDicConstant.DELETE_TAG.NO_DEL);
                        saveDealList.add(deal);
                    }
                }

                if (ObjectUtil.isNotEmpty(saveDealList)) {
                    iUocSaleOrderModel.saveOrderTaskDealList(saveDealList);
                }
                iUocSaleOrderModel.saveProcTaskInst(saveList);
            }
        }


        //保存业务操作记录
        List<UocOrderBusiOperRecord> recordList = new ArrayList<>();
        UocOrderBusiOperRecord saveRecord = UocRu.js(reqBo, UocOrderBusiOperRecord.class);
        recordList.add(saveRecord);
        saveRecord.setId(IdUtil.nextId());
        saveRecord.setObjId(reqBo.getObjId());
        saveRecord.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        saveRecord.setOrderId(reqBo.getOrderId());
        saveRecord.setCreateTime(now);
        saveRecord.setDealTime(now);
        saveRecord.setDealOperId(reqBo.getUserId().toString());
        saveRecord.setDealOperName(reqBo.getName());
//        recordList
        iUocAuditOrderModel.saveOperRecord(recordList);


        //保存附件


        return rspBo;
    }

    private void saveLog(UocApproveMoveServiceReqBo reqBo, Date now, Long auditOrderId, Boolean finished, Integer finalResult) {
        UocApprovalLog approvalLog = new UocApprovalLog();
        approvalLog.setFinish(finished ? UocConstant.AUDIT_LOG_FINISH.YES : UocConstant.AUDIT_LOG_FINISH.NO);
        approvalLog.setId(IdUtil.nextId());
        approvalLog.setOperid(reqBo.getUserId().toString());
        approvalLog.setOperName(reqBo.getName());
        approvalLog.setOperDept(reqBo.getOrgId().toString());
        approvalLog.setCreateTime(now);
        approvalLog.setDealTime(now);
        approvalLog.setAuditAdvice(reqBo.getDealReason());
        approvalLog.setAuditResult(finalResult);
        approvalLog.setObjType(reqBo.getObjBusiType());
        approvalLog.setAuditOrderId(auditOrderId);
        approvalLog.setAuditResult(reqBo.getFinalResult());
        UocAuditOrderDo logDo = new UocAuditOrderDo();
        logDo.setApprovalLog(approvalLog);
        iUocAuditOrderModel.saveAuditLog(logDo);
    }


    /**
     * 描述:对象创建
     *
     * @param reqBo, nextTaskInfo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal
     * @author tgy
     * @date 2022/3/3 17:31
     */
    private UocOrderTaskDeal assembleTaskDealObj(UocApproveMoveServiceReqBo reqBo, UocApproveMoveServiceReqTaskBo nextTaskInfo) {
        UocOrderTaskDeal deal = new UocOrderTaskDeal();
        deal.setId(IdUtil.nextId());
        deal.setTaskInstId(nextTaskInfo.getTaskInstId());
        deal.setOrderId(reqBo.getOrderId());
        deal.setObjId(reqBo.getObjId());
        deal.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        return deal;
    }

    private void validateArg(UocApproveMoveServiceReqBo reqBo) {

        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocApproveMoveServiceReqBo]不能为空");
        }
       /* if (ObjectUtil.isEmpty(reqBo.getAuditOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[审批单id]不能为空");
        }*/
        if (ObjectUtil.isEmpty(reqBo.getUserId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[用户id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getObjId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[objid]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getProcInstId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[流程实例id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getFinalResult())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[审批结果 0通过 1驳回]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getFinished())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[审批是否结束]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOldTaskInstId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[旧任务实例id]不能为空");
        }
        /*if (ObjectUtil.isEmpty(reqBo.getTaskBoList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[审批任务列表]不能为空");
        }*/

        if(ObjectUtil.isNotEmpty(reqBo.getTaskBoList())){
            for (UocApproveMoveServiceReqTaskBo uocApproveMoveServiceReqTaskBo : reqBo.getTaskBoList()) {
                validateTask(uocApproveMoveServiceReqTaskBo);
            }
        }



    }

    private void validateTask(UocApproveMoveServiceReqTaskBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocApproveMoveServiceReqTaskBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getTaskInstId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[新任务实例id]不能为空");
        }

    }
}


