package com.tydic.dyc.oc.service.common;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.qrybo.UocConfSupplierBo;
import com.tydic.dyc.oc.service.common.bo.UocQryConfSupplierReqBO;
import com.tydic.dyc.oc.service.common.bo.UocQryConfSupplierRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 描述: 〈领域服务-查询供应商配置实现〉
 * @author : yuhao
 * @date : 2022/8/1 11:06
 */
@Slf4j
@HTServiceImpl
public class UocQryConfSupplierServiceImpl implements UocQryConfSupplierService {
    
    @Autowired
    private IUocCommonModel iUocCommonModel;
    
    @Override
    public UocQryConfSupplierRspBO qryConfSupplier(UocQryConfSupplierReqBO reqBO) {
        UocQryConfSupplierRspBO rspBO = new UocQryConfSupplierRspBO();
        rspBO.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
    
        UocConfSupplierBo modelRsp = iUocCommonModel.qryConfSupplier(reqBO.getGoodsSupplierNo());
        if(ObjectUtil.isNotEmpty(modelRsp)){
            rspBO.setDealType(modelRsp.getDealType());
        }
        return rspBO;
    }
}
