package com.tydic.dyc.oc.config.mq;

import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import com.tydic.dyc.oc.config.mq.consumer.UocSaleOrderSyncConsumer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 标题:UocSaleOrderSyncMqConfig
 * 说明:
 * 时间:2022/3/9 20:45
 * 作者:田桂银
 */
@Configuration
public class UocSaleOrderSyncMqConfig {
    @Value("${data.sync.event.pid:EVENT_PID}")
    private String orderCreatePid;

    @Value("${data.sync.event.topic:EVENT_TOPIC_LOCAL}")
    private String orderCreateTopic;

    @Value("${data.sync.event.tag:UOC}")
    private String orderCreateTag;


    @Bean("uocSaleOrderSyncConsumer")
    public UocSaleOrderSyncConsumer uocCreateOrderConsumer() {
        UocSaleOrderSyncConsumer uocCreateOrderConsumer = new UocSaleOrderSyncConsumer();
        uocCreateOrderConsumer.setId(orderCreatePid);
        uocCreateOrderConsumer.setSubject(orderCreateTopic);
        String[] tags = {orderCreateTag};
        uocCreateOrderConsumer.setTags(tags);
        return uocCreateOrderConsumer;
    }

    @Bean(value = "uocSaleOrderSyncProvider", initMethod = "startup", destroyMethod = "shutdown")
    public ProxyProducerFactoryBean uocSaleOrderSyncProxyProducerFactoryBean() {
        DefaultProxyMessageConfig defaultProxyMessageConfig = new DefaultProxyMessageConfig();
        defaultProxyMessageConfig.setId(orderCreatePid);
        ProxyProducerFactoryBean proxyProducerFactoryBean = new ProxyProducerFactoryBean();
        proxyProducerFactoryBean.setMessageConfig(defaultProxyMessageConfig);
        return proxyProducerFactoryBean;
    }
}


