package com.tydic.dyc.oc.service.common;

import cn.hutool.core.util.ObjectUtil;

import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.sub.UocConfSupplierDO;
import com.tydic.dyc.oc.service.common.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 描述: 〈领域服务-根据订单查询供应商限额配置 实现〉
 * @author : yuhao
 * @date : 2022/8/1 11:05
 */
@HTServiceImpl
public class UocQrySupplierQuotaConfigServiceImpl implements UocQrySupplierQuotaConfigService {

    @Autowired
    private IUocCommonModel uocCommonModel;

    @Override
    public UocQrySupplierQuotaConfigRspBo checkSupQuotaLimit(UocQrySupplierQuotaConfigReqBo reqBo) {
        validateArgs(reqBo);
        Set<String> supplierSet = reqBo.getItemList().stream().map(UocQrySupplierQuotaConfigReqSkuBo::getGoodsSupplierId).collect(Collectors.toSet());
        UocConfSupplierDO uocConfSupplierDO = new UocConfSupplierDO();
        uocConfSupplierDO.setSupplierNos(new ArrayList<>(supplierSet));
        uocConfSupplierDO.setLimitStatus(0);//查询生效数据
        List<UocConfSupplierDO> uocConfSupplierDoS = uocCommonModel.qryConfSupplierList(uocConfSupplierDO);
        Map<String, UocConfSupplierDO> supConfigMap = uocConfSupplierDoS.stream().collect(Collectors.toMap(UocConfSupplierDO::getSupNo, Function.identity()));

        //根据供应商分组
        Map<String, List<UocQrySupplierQuotaConfigReqSkuBo>> supMap = reqBo.getItemList().stream().collect(Collectors.groupingBy(UocQrySupplierQuotaConfigReqSkuBo::getGoodsSupplierId));
        for (Map.Entry<String, List<UocQrySupplierQuotaConfigReqSkuBo>> tMap : supMap.entrySet()) {
            String key = tMap.getKey();
            List<UocQrySupplierQuotaConfigReqSkuBo> value = tMap.getValue();

            UocConfSupplierDO confSupplierDO = supConfigMap.get(key);
            if (confSupplierDO == null) {
                uocConfSupplierDO.setSupNo("0");
                uocConfSupplierDO.setBusinessTypeCode(Integer.toString(value.get(0).getBusinessTypeCode()));
                uocConfSupplierDoS = uocCommonModel.qryConfSupplierList(uocConfSupplierDO);
                if (CollectionUtils.isEmpty(uocConfSupplierDoS)){
                    //如果数据库没配，就不管
                    continue;
                }
                confSupplierDO = uocConfSupplierDoS.get(0);
            }
            BigDecimal totalPrice = new BigDecimal(0);
            for (UocQrySupplierQuotaConfigReqSkuBo skuBo : value) {
                if (confSupplierDO.getOrderLimit() != null) {
                    totalPrice = skuBo.getPurchaseCount().multiply(skuBo.getSkuSalePrice()).add(totalPrice);
                }
            }
            if(StringUtils.isNotBlank(confSupplierDO.getOrderLimit()) && new BigDecimal(confSupplierDO.getOrderLimit()).divide(new BigDecimal(10000), 3, BigDecimal.ROUND_HALF_UP).subtract(totalPrice).compareTo(BigDecimal.ZERO) > 0) {
                return UocRu.failed(BaseRspConstant.RSP_CODE_FAIL, confSupplierDO.getSupName() + "下的订单不满足[" + new BigDecimal(confSupplierDO.getOrderLimit()).divide(new BigDecimal(10000), 3, BigDecimal.ROUND_HALF_UP).toString() + "]元，不允许下单。", UocQrySupplierQuotaConfigRspBo.class);
            }
        }
        return UocRu.success(UocQrySupplierQuotaConfigRspBo.class);
    }

    private void validateArgs(UocQrySupplierQuotaConfigReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        List<UocQrySupplierQuotaConfigReqSkuBo> itemList = reqBo.getItemList();
        if (ObjectUtil.isEmpty(itemList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参属性itemList不能为空");
        } else {
            for (UocQrySupplierQuotaConfigReqSkuBo tBo : itemList) {
                if (ObjectUtil.isEmpty(tBo)) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参属性itemList中对象不能为空");
                }
                if (ObjectUtil.isEmpty(tBo.getGoodsSupplierId())) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参属性itemList中对象属性[goodsSupplierId]不能为空");
                }
                if (ObjectUtil.isEmpty(tBo.getPurchaseCount())) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参属性itemList中对象属性[purchaseCount]不能为空");
                }
                if (ObjectUtil.isEmpty(tBo.getSkuId())) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参属性itemList中对象属性[skuId]不能为空");
                }
                if (ObjectUtil.isEmpty(tBo.getSkuSalePrice())) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参属性itemList中对象属性[skuSalePrice]不能为空");
                }
            }
        }

    }

}


