package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.service.common.bo.UocProBusinessException;
import com.tydic.dyc.oc.service.common.bo.UocProRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocMoneyUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@HTServiceImpl
@Slf4j
public class UocMsgSplitOrderServiceImpl implements UocMsgSplitOrderService {
    
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    @Autowired
    private IUocCommonModel iUocCommonModel;
    
    @Override
    public UocMsgSplitOrderRspBo splitOrder(UocMsgSplitOrderReqBo reqBo) {
        UocMsgSplitOrderRspBo rspBo = UocRu.success(UocMsgSplitOrderRspBo.class);
        //查询销售订单信息
        UocSaleOrderDo uocSaleOrderDo = qrySale(reqBo);
        if(null == uocSaleOrderDo){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR,"订单拆单通知业务失败：未查询到销售订单信息!");
        }
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        taskInstQryBo.setObjId(uocSaleOrderDo.getSaleOrderId());
        taskInstQryBo.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        //查询订单任务实例
        List<UocOrderTaskInst> taskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if(ObjectUtil.isNotEmpty(taskInsts)){
            rspBo.setTaskInstId(taskInsts.get(0).getTaskInstId());
            rspBo.setStepId(taskInsts.get(0).getProcState());
            rspBo.setProcInstId(taskInsts.get(0).getProcInstId());
        }
        int count = 0;
        UocGetJDSplitOrderBO uocGetJDSplitOrderBO = reqBo.getUocGetJDSplitOrderBO();
        if(ObjectUtil.isEmpty(uocGetJDSplitOrderBO)){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR,"订单拆单通知业务失败：没有拆单消息!");
        }
        //子单列表
        List<UocChildSaleOrderBO> childSaleOrderBOList = uocGetJDSplitOrderBO.getCOrder();
        Iterator<UocChildSaleOrderBO> iterator = childSaleOrderBOList.iterator();
        
        //查询到外部子单id
        List<String> outId =new ArrayList<>();
        for (UocChildSaleOrderBO orderBO : childSaleOrderBOList) {
            outId.add(orderBO.getOrderId());
        }
        // 该逻辑去掉，否则京东会有订单积压
//        while (iterator.hasNext()) {
//            UocChildSaleOrderBO uocChildSaleOrderBO =  iterator.next();
//            if(!(uocChildSaleOrderBO.getJdOrderState() >= 7)){
//                throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR,"订单拆单通知业务失败：有子订单没有完成拆单，不予进行操作!");
//            }
//        }
        List<UocCreateOrderServiceRspSaleOrderBo> saleOrderList = new ArrayList<>();
    
        UocOrderQueryIndexQryBo qryBo = new UocOrderQueryIndexQryBo();
        qryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        qryBo.setOrderId(uocSaleOrderDo.getOrderId());
        List<UocOrderQueryIndex> queryIndexList= iUocOrderModel.qryOrderQueryIndexList(qryBo);
    
        List<String> outNo = new ArrayList<>();
        for (UocOrderQueryIndex idx : queryIndexList) {
            outNo.add(idx.getOutObjId());
            if (!outId.contains(idx.getOutObjId())) {
                UocSaleOrderDo uocSaleOrderDo1 = new UocSaleOrderDo();
                uocSaleOrderDo1.setOrderId(idx.getOrderId());
                uocSaleOrderDo1.setSaleOrderId(idx.getObjId());
                uocSaleOrderDo1.setSaleOrderState(UocStateConstants.SaleOrder.XS_SPLIT);
                try {
                    //如果该销售单拆过单，则更新状态为已拆单. TODO 这里需要同步es
                    iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo1);
                    saleOrderList.add(UocRu.js(uocSaleOrderDo1,UocCreateOrderServiceRspSaleOrderBo.class));
                } catch (Exception ignored) {
                    log.error("二次拆单的订单处理失败:" + JSON.toJSONString(idx));
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR,"二次拆单的订单处理失败!");
                }
            }
        }
        
        for(UocChildSaleOrderBO childSaleOrderRspBO :childSaleOrderBOList){
            
            if (outNo.contains(childSaleOrderRspBO.getOrderId())) {
                continue;
            }
            UocCreateOrderServiceRspSaleOrderBo serviceRspSaleOrderBo = new UocCreateOrderServiceRspSaleOrderBo();
            UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO = new UocCreateOrdByOrdSplitBO();
            uocCreateOrdByOrdSplitBO.setUocChildSaleOrderBO(childSaleOrderRspBO);
            uocCreateOrdByOrdSplitBO.setOrderId(uocSaleOrderDo.getOrderId());
            uocCreateOrdByOrdSplitBO.setSaleId(uocSaleOrderDo.getSaleOrderId());
            uocCreateOrdByOrdSplitBO.setCount(count);
        
            Long newSaleOrderId = splitCoreOrder(uocCreateOrdByOrdSplitBO);
            serviceRspSaleOrderBo.setSaleOrderId(newSaleOrderId);
            saleOrderList.add(serviceRspSaleOrderBo);
            count ++;
        }
    
        //组装返回参数
        rspBo.setOrderId(uocSaleOrderDo.getOrderId());
        rspBo.setSaleOrderList(saleOrderList);
    
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(rspBo.getTaskInstId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(11111L);
        uocCommonDo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        log.info("拆单流转原订单的任务,{}", JSON.toJSONString(uocCommonDo));
        iUocCommonModel.dealTask(uocCommonDo);
    
    
        //处理完拆单消息后更新msgPool中的执行状态为已执行
        UocDMsgPoolQryBo qryBo1 = new UocDMsgPoolQryBo();
        qryBo1.setId(reqBo.getDycUocQryMsgBO().getId());
        qryBo1.setRunResult(1);//执行成功
        iUocOrderModel.updateMsgPoolById(qryBo1);
        return rspBo;
    }
    
    /*
     * @Author lsl
     * @Description //TODO 查询销售订单信息
     * @Date 16:36 2022/4/12
     * @Param [reqBo]
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     */
    public UocSaleOrderDo qrySale(UocMsgSplitOrderReqBo reqBo){
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBo.getDycUocQryMsgBO().getObjId());
        return iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }
    /*
     * @Author lsl
     * @Description //TODO 拆单核心服务
     * @Date 11:29 2022/4/13
     * @Param [orderId, saleOrderId, childSaleOrderRspBO, count]
     * @return void
     */
    public Long splitCoreOrder(UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO){

//        buildSaleAndItemParam(uocCreateOrdByOrdSplitBO);
        //外部子订单信息
        UocChildSaleOrderBO childSaleOrderRspBO = uocCreateOrdByOrdSplitBO.getUocChildSaleOrderBO();
        Long totalFee = 0L;
        Long freight = null;
        Long newSaleOrderId = IdUtil.nextId();
        try {
            //订单总金额（不含运费）
            totalFee = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getOrderPrice());
            //运费
            freight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getFreight());
            if (freight == null) {
                freight = 0L;
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("通过拆单创建子订单时异常：转换订单费用错误!");
        }
        
        UocSaleOrderQryBo uocSaleOrderBo = new UocSaleOrderQryBo();
        uocSaleOrderBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        uocSaleOrderBo.setSaleOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
        UocSaleOrderDo saleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderBo);
        //新销售订单id
        saleOrderDo.setSaleOrderId(newSaleOrderId);
        //父销售订单id（原销售订单id）
        saleOrderDo.setUpperOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
//        saleOrderDo.setSaleOrderNo(saleOrderDo.getSaleOrderNo() + "-" +  uocCreateOrdByOrdSplitBO.getCount());
        saleOrderDo.setSaleOrderNoExt(String.valueOf(childSaleOrderRspBO.getOrderId()));
        try {
            saleOrderDo.setTotalSaleFee(MoneyUtils.Long2BigDecimal(totalFee));
            saleOrderDo.setTotalPurchaseFee(MoneyUtils.Long2BigDecimal(totalFee));
            saleOrderDo.setTotalTransFee(MoneyUtils.Long2BigDecimal(freight));
        } catch (Exception e) {
            e.printStackTrace();
            log.error("通过拆单创建子订单时异常：转换订单费用错误!");
        }
        //销售单明细表
        List<UocOrderSkuBO> exSkuList = childSaleOrderRspBO.getSku(); //外部单品列表
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
        List<UocSaleOrderItem> saleItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        List<UocSaleOrderItem> newSaleItemList = new ArrayList<>();
        BigDecimal totalSaleFee = BigDecimal.ZERO;
        for(UocSaleOrderItem saleOrderItem: saleItemList){
            Long newSaleOrderItemId = IdUtil.nextId();
            for (UocOrderSkuBO extSkuBo: exSkuList){
//                if(saleOrderItem.getSkuExtSkuId().equals(extSkuBo.getSkuId())){
//                    saleOrderItem.setPurchaseCount(new BigDecimal(extSkuBo.getNum()));
//                }
                if(saleOrderItem.getSkuExtSkuId().equals(extSkuBo.getSkuId())){
                    UocSaleOrderItem newUocSaleOrderItem = JSONObject.parseObject(JSON.toJSONString(saleOrderItem),UocSaleOrderItem.class);
                    newUocSaleOrderItem.setPurchaseCount(new BigDecimal(extSkuBo.getNum()));
                    newUocSaleOrderItem.setSaleOrderId(newSaleOrderId);
                    newUocSaleOrderItem.setSaleOrderItemId(newSaleOrderItemId);
                    newSaleItemList.add(newUocSaleOrderItem);
                    totalSaleFee = totalSaleFee.add(newUocSaleOrderItem.getTotalSaleFee());
                }
            }
        }
        saleOrderDo.setSaleOrderItems(newSaleItemList);
        saleOrderDo.setTotalSaleFee(totalSaleFee);
        Integer isJdCz = 0;
        //如果京东的子订单接口返回orderType = 5 ,代表厂家直送订单
        if(ObjectUtil.isNotEmpty(childSaleOrderRspBO.getOrderType()) && childSaleOrderRspBO.getOrderType() == 5){
            isJdCz = 1;
        }
        saleOrderDo.setJdCz(isJdCz);
        iUocSaleOrderModel.createSaleOrder(saleOrderDo);
        
        UocOrderQueryIndex uocOrderQueryIndex = new UocOrderQueryIndex();
        uocOrderQueryIndex.setObjId(newSaleOrderId);
        uocOrderQueryIndex.setOrderSystem(UocDicConstant.OBJ_TYPE.SALE.toString());
        uocOrderQueryIndex.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderQueryIndex.setOutObjId(String.valueOf(childSaleOrderRspBO.getOrderId()));
        uocOrderQueryIndex.setOrderId(saleOrderDo.getOrderId());
        uocOrderQueryIndex.setId(IdUtil.nextId());
        iUocCommonModel.saveOrderQueryIndex(uocOrderQueryIndex);
    
        //销毁父订单
        try {
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setSaleOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
            uocSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_SPLIT);
            iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        } catch (Exception e) {
            log.error("拆单失败:删除父订单异常!:" + e.getMessage());
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR,"拆单失败:删除父订单异常!");
    
        }
        
        return newSaleOrderId;
    }
    /*
     * @Author lsl
     * @Description //TODO 构建发票信息
     * @Date 17:18 2022/4/13
     * @Param []
     * @return void
     */
    public void buildInvoiceParam(Long newOrderId,UocOrderDo uocOrderDo,Long orderId){
        UocOrdInvoiceQryBo qryBo = new UocOrdInvoiceQryBo();
        qryBo.setOrderId(orderId);
        UocOrdInvoice uocOrdInvoice = iUocOrderModel.qryOrderInvoice(qryBo);
        if(null != uocOrdInvoice){
            uocOrdInvoice.setId(IdUtil.nextId());
            uocOrdInvoice.setOrderId(newOrderId);
            uocOrderDo.setUocOrdInvoice(uocOrdInvoice);
        }
    }
    /*
     * @Author lsl
     * @Description //TODO 构建附件信息
     * @Date 17:21 2022/4/13
     * @Param
     * @return
     */
    public void buildAccessort(Long newOrderId,UocOrderDo uocOrderDo,Long orderId){
        UocOrderAccessoryQryBo accessoryQryBo = new UocOrderAccessoryQryBo();
        accessoryQryBo.setOrderId(orderId);
        List<UocOrderAccessory> accessoryList = iUocOrderModel.getOrderAccessoryList(accessoryQryBo);
        if(ObjectUtil.isNotEmpty(accessoryList)){
            List<UocOrderAccessory> accessories =new ArrayList<>();
            for (UocOrderAccessory accessory : accessoryList) {
                accessory.setOrderId(newOrderId);
                accessory.setId(IdUtil.nextId());
                //时间
                accessory.setCreateTime(new Date());
                if (accessory.getObjType().equals(1)) {
                    accessory.setObjId(null);
                }
                accessories.add(accessory);
            }
            uocOrderDo.setAccessoryList(accessories);
        }
    }
    
    /*
     * @Author lsl
     * @Description //TODO 构建地址联系人参数
     * @Date 17:24 2022/4/13
     * @Param
     * @return
     */
    public void buildLogisticsRelaParam(Long newOrderId,UocOrderDo uocOrderDo,Long orderId){
        UocOrdLogisticsRelaQryBo logisticsRelaQryBo = new UocOrdLogisticsRelaQryBo();
        logisticsRelaQryBo.setOrderId(orderId);
        UocOrdLogisticsRela uocOrdLogisticsRela = iUocOrderModel.qryOrderLogisticsRela(logisticsRelaQryBo);
        if(null != uocOrdLogisticsRela){
            uocOrdLogisticsRela.setContactId(IdUtil.nextId());
            uocOrdLogisticsRela.setOrderId(newOrderId);
        }
        uocOrderDo.setReceiverAddress(uocOrdLogisticsRela);
    }
    /*
     * @Author lsl
     * @Description //TODO 构建订单扩展参数
     * @Date 17:27 2022/4/13
     * @Param
     * @return
     */
    public void buildOrderMapExtParam(Long newOrderId,UocOrderDo uocOrderDo,Long orderId){
        UocOrderMapQryBo orderMapQryBo = new UocOrderMapQryBo();
        orderMapQryBo.setOrderId(orderId);
        List<UocOrderMap> uocOrderMaps =  iUocOrderModel.qryOrderMapList(orderMapQryBo);
        if(ObjectUtil.isNotEmpty(uocOrderMaps)){
            List<UocOrderMap> poList = new ArrayList<>();
            for (UocOrderMap orderMap: uocOrderMaps){
                orderMap.setId(IdUtil.nextId());
                orderMap.setOrderId(newOrderId);
                poList.add(orderMap);
            }
            uocOrderDo.setOrderExt(poList);
        }
    }
    /*
     * @Author lsl
     * @Description //TODO 构建销售及销售明细表
     * @Date 17:30 2022/4/13
     * @Param
     * @return
     */
    public void buildSaleAndItemParam(Long newOrderId, UocSaleOrderDo saleOrderQryDo, UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO){
        UocChildSaleOrderBO childSaleOrderRspBO = uocCreateOrdByOrdSplitBO.getUocChildSaleOrderBO();
        Long totalFee = 0L;
        Long baseFreight = null;
        Long freight = null;
        try {
            totalFee = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getOrderPrice());
            baseFreight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getBaseFreight());
            if (baseFreight == null) {
                baseFreight = 0L;
            }
            freight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getFreight());
            if (freight == null) {
                freight = 0L;
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("通过拆单创建子订单时异常：转换订单费用错误!");
        }

        try {
            UocSaleOrderQryBo uocSaleOrderBo = new UocSaleOrderQryBo();
            uocSaleOrderBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
            saleOrderQryDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderBo);
            saleOrderQryDo.setOrderId(newOrderId);
            saleOrderQryDo.setSaleOrderId(IdUtil.nextId());
            saleOrderQryDo.setSaleOrderNo("");
            saleOrderQryDo.setTotalSaleFee(MoneyUtils.Long2BigDecimal(totalFee));
            saleOrderQryDo.setTotalPurchaseFee(MoneyUtils.Long2BigDecimal(totalFee));
            saleOrderQryDo.setTotalTransFee(MoneyUtils.Long2BigDecimal(baseFreight));
            saleOrderQryDo.setTotalTransFee(MoneyUtils.Long2BigDecimal(baseFreight + freight));
        } catch (Exception e) {
            e.printStackTrace();
            log.error("通过拆单创建子订单时异常：转换订单费用错误!");
        }
//        saleOrderQryDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_CJ_CJ);

        //销售单明细表
        List<UocOrderSkuBO> exSkuList = childSaleOrderRspBO.getSku(); //外部单品列表
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        List<UocSaleOrderItem> saleItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        for(UocSaleOrderItem saleOrderItem: saleItemList){
            Long saleOrderItemId = IdUtil.nextId();
            for (UocOrderSkuBO extSkuBo: exSkuList){
                if(saleOrderItem.getSkuExtSkuId().equals(extSkuBo.getSkuId())){
                    saleOrderItem.setPurchaseCount(new BigDecimal(extSkuBo.getNum()));
                }
            }
            saleOrderItem.setOrderId(newOrderId);
            saleOrderItem.setSaleOrderItemId(saleOrderItemId);
        }
        saleOrderQryDo.setSaleOrderItems(saleItemList);
    }
    /*
     * @Author lsl
     * @Description //TODO 构建支付配置表
     * @Date 17:35 2022/4/13
     * @Param
     * @return
     */
    public void buildPayConfig(Long newOrderId,UocSaleOrderDo saleOrderQryDo,Long orderId){
        UocSaleOrderPayConfQryBo payConfQryBo = new UocSaleOrderPayConfQryBo();
        payConfQryBo.setOrderId(orderId);
        List<UocSaleOrderPayConf> payConfList = iUocSaleOrderModel.getSaleOrderPayConfList(payConfQryBo);
        if (ObjectUtil.isEmpty(payConfList)) {
            return;
        }
        UocSaleOrderPayConf uocSaleOrderPayConf = payConfList.get(0);
        uocSaleOrderPayConf.setId(IdUtil.nextId());
        uocSaleOrderPayConf.setOrderId(newOrderId);
        if (ObjectUtil.isNotEmpty(uocSaleOrderPayConf.getPrePayFee())) {
            BigDecimal preFee = saleOrderQryDo.getTotalSaleFee().divide(saleOrderQryDo.getTotalSaleFee(), 2, BigDecimal.ROUND_UP).
                    multiply(uocSaleOrderPayConf.getPrePayFee()).setScale(2, BigDecimal.ROUND_UP);
            preFee = preFee.multiply(new BigDecimal(10000));
            uocSaleOrderPayConf.setPrePayFee(preFee);
        }
        saleOrderQryDo.getSaleOrderPayConfList().add(uocSaleOrderPayConf);
    }
}
