/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderReqShipBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventConsumerInspCreate
implements EventConsumer {
    private static final Logger log = LoggerFactory.getLogger(EventConsumerInspCreate.class);
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerInspCreate->{}", (Object)JSON.toJSONString(map));
        ArrayList<IUocEsSyncQryEventReqBo> retList = new ArrayList<IUocEsSyncQryEventReqBo>();
        Long orderId = UocRu.parseLong(map.get("orderId"));
        Long saleOrderId = UocRu.parseLong(map.get("saleOrderId"));
        Long inspOrderId = UocRu.parseLong(map.get("inspOrderId"));
        Object objList = map.get("shipOrderList");
        if (ObjectUtil.isNotNull((Object)objList)) {
            List<UocCreateInspOrderReqShipBo> shipOrderList = UocRu.jsl(objList, UocCreateInspOrderReqShipBo.class);
            ArrayList<IUocEsSyncQryReqBo> shipList = new ArrayList<IUocEsSyncQryReqBo>();
            shipOrderList.forEach(uocCreateInspOrderReqShipBo -> {
                IUocEsSyncQryReqBo ship = new IUocEsSyncQryReqBo();
                ship.setOrderId(orderId);
                ship.setObjId(uocCreateInspOrderReqShipBo.getShipOrderId());
                shipList.add(ship);
            });
            IUocEsSyncQryEventReqBo shipEvent = new IUocEsSyncQryEventReqBo();
            shipEvent.setIndexName(this.uocIndexConfig.getShipOrderIndex());
            shipEvent.setDataList(shipList);
            retList.add(shipEvent);
        }
        if (ObjectUtil.isNotEmpty((Object)inspOrderId)) {
            ArrayList<IUocEsSyncQryReqBo> inspList = new ArrayList<IUocEsSyncQryReqBo>();
            IUocEsSyncQryReqBo insp = new IUocEsSyncQryReqBo();
            insp.setOrderId(orderId);
            insp.setObjId(inspOrderId);
            inspList.add(insp);
            IUocEsSyncQryEventReqBo inspEvent = new IUocEsSyncQryEventReqBo();
            inspEvent.setIndexName(this.uocIndexConfig.getInspOrderIndex());
            inspEvent.setDataList(inspList);
            retList.add(inspEvent);
        }
        ArrayList<IUocEsSyncQryReqBo> saleList = new ArrayList<IUocEsSyncQryReqBo>();
        IUocEsSyncQryReqBo sale = new IUocEsSyncQryReqBo();
        sale.setOrderId(orderId);
        sale.setObjId(saleOrderId);
        saleList.add(sale);
        IUocEsSyncQryEventReqBo saleEvent = new IUocEsSyncQryEventReqBo();
        saleEvent.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        saleEvent.setDataList(saleList);
        retList.add(saleEvent);
        return retList;
    }

    @Override
    public String getEvent() {
        return "UOCE_CREATE_INSP";
    }
}

