/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderMapQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderMap;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleItemMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.service.domainservice.UocMsgSplitOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocChildSaleOrderBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrdByOrdSplitBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetJDSplitOrderBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgSplitOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgSplitOrderRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderSkuBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocMoneyUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocMsgSplitOrderService"})
public class UocMsgSplitOrderServiceImpl
implements UocMsgSplitOrderService {
    private static final Logger log = LoggerFactory.getLogger(UocMsgSplitOrderServiceImpl.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    @PostMapping(value={"splitOrder"})
    public UocMsgSplitOrderRspBo splitOrder(@RequestBody UocMsgSplitOrderReqBo reqBo) {
        UocMsgSplitOrderRspBo rspBo = UocRu.success(UocMsgSplitOrderRspBo.class);
        UocSaleOrderDo uocSaleOrderDo = this.qrySale(reqBo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("101002", "\u8ba2\u5355\u62c6\u5355\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u4fe1\u606f!");
        }
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        taskInstQryBo.setObjId(uocSaleOrderDo.getSaleOrderId());
        taskInstQryBo.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        List<UocOrderTaskInst> taskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if (ObjectUtil.isEmpty(taskInsts)) {
            throw new BaseBusinessException("101002", "\u8ba2\u5355\u62c6\u5355\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u8868\u4fe1\u606f!");
        }
        taskInsts = taskInsts.stream().sorted(Comparator.comparing(UocOrderTaskInst::getCreateTime).reversed()).collect(Collectors.toList());
        log.info("\u7236\u5355\u7684\u6d41\u7a0b\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(taskInsts));
        if (ObjectUtil.isNotEmpty(taskInsts)) {
            rspBo.setTaskInstId(taskInsts.get(0).getTaskInstId());
            rspBo.setStepId(taskInsts.get(0).getProcState());
            rspBo.setProcInstId(taskInsts.get(0).getProcInstId());
        }
        int count = 0;
        UocGetJDSplitOrderBO uocGetJDSplitOrderBO = reqBo.getUocGetJDSplitOrderBO();
        if (ObjectUtil.isEmpty((Object)uocGetJDSplitOrderBO)) {
            throw new BaseBusinessException("101002", "\u8ba2\u5355\u62c6\u5355\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u6ca1\u6709\u62c6\u5355\u6d88\u606f!");
        }
        List childSaleOrderBOList = uocGetJDSplitOrderBO.getCOrder();
        ArrayList<String> outId = new ArrayList<String>();
        for (UocChildSaleOrderBO orderBO : childSaleOrderBOList) {
            outId.add(orderBO.getOrderId());
        }
        ArrayList<UocCreateOrderServiceRspSaleOrderBo> saleOrderList = new ArrayList<UocCreateOrderServiceRspSaleOrderBo>();
        UocOrderQueryIndexQryBo qryBo = new UocOrderQueryIndexQryBo();
        qryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        qryBo.setOrderId(uocSaleOrderDo.getOrderId());
        List<UocOrderQueryIndex> queryIndexList = this.iUocOrderModel.qryOrderQueryIndexList(qryBo);
        queryIndexList = queryIndexList.stream().filter(e -> {
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setOrderId(e.getOrderId());
            uocSaleOrderQryBo.setSaleOrderId(e.getObjId());
            UocSaleOrderDo uocSaleOrderDo1 = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
            Long upperOrderId = uocSaleOrderDo1.getUpperOrderId();
            if ("100055".equals(uocSaleOrderDo1.getStakeholder().getSupId())) {
                return !(upperOrderId == null ? !reqBo.getDycUocQryMsgBO().getObjId().equals(uocSaleOrderDo1.getSaleOrderId()) : !reqBo.getDycUocQryMsgBO().getObjId().equals(upperOrderId));
            }
            return false;
        }).collect(Collectors.toList());
        ArrayList<String> outNo = new ArrayList<String>();
        for (UocOrderQueryIndex idx : queryIndexList) {
            outNo.add(idx.getOutObjId());
            if (outId.contains(idx.getOutObjId())) continue;
            UocSaleOrderDo uocSaleOrderDo1 = new UocSaleOrderDo();
            uocSaleOrderDo1.setOrderId(idx.getOrderId());
            uocSaleOrderDo1.setSaleOrderId(idx.getObjId());
            uocSaleOrderDo1.setSaleOrderState("XS_SPLIT");
            try {
                this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo1);
                UocOrderProcInstQryBo instQryBo = new UocOrderProcInstQryBo();
                instQryBo.setOrderId(idx.getOrderId());
                instQryBo.setObjId(idx.getObjId());
                List<UocOrderProcInst> uocOrderProcInstList = this.iUocOrderModel.qryOrderProcInstList(instQryBo);
                saleOrderList.add(UocRu.js((Object)uocSaleOrderDo1, UocCreateOrderServiceRspSaleOrderBo.class));
            }
            catch (Exception ignored) {
                log.error("\u4e8c\u6b21\u62c6\u5355\u7684\u8ba2\u5355\u5904\u7406\u5931\u8d25:" + JSON.toJSONString((Object)idx));
                throw new BaseBusinessException("101002", "\u4e8c\u6b21\u62c6\u5355\u7684\u8ba2\u5355\u5904\u7406\u5931\u8d25!");
            }
        }
        for (UocChildSaleOrderBO childSaleOrderRspBO : childSaleOrderBOList) {
            if (outNo.contains(childSaleOrderRspBO.getOrderId())) continue;
            UocCreateOrderServiceRspSaleOrderBo serviceRspSaleOrderBo = new UocCreateOrderServiceRspSaleOrderBo();
            UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO = new UocCreateOrdByOrdSplitBO();
            uocCreateOrdByOrdSplitBO.setUocChildSaleOrderBO(childSaleOrderRspBO);
            uocCreateOrdByOrdSplitBO.setOrderId(uocSaleOrderDo.getOrderId());
            uocCreateOrdByOrdSplitBO.setSaleId(uocSaleOrderDo.getSaleOrderId());
            uocCreateOrdByOrdSplitBO.setCount(Integer.valueOf(count));
            Long newSaleOrderId = this.splitCoreOrder(uocCreateOrdByOrdSplitBO);
            serviceRspSaleOrderBo.setSaleOrderId(newSaleOrderId);
            saleOrderList.add(serviceRspSaleOrderBo);
            ++count;
        }
        rspBo.setOrderId(uocSaleOrderDo.getOrderId());
        rspBo.setSaleOrderList(saleOrderList);
        Iterator iterator = childSaleOrderBOList.iterator();
        Boolean splitOver = true;
        while (iterator.hasNext()) {
            UocChildSaleOrderBO uocChildSaleOrderBO = (UocChildSaleOrderBO)iterator.next();
            if (uocChildSaleOrderBO.getJdOrderState() >= 7) continue;
            splitOver = false;
        }
        if (splitOver.booleanValue() || "E0006".equalsIgnoreCase(taskInsts.get(0).getProcState())) {
            UocCommonDo uocCommonDo = new UocCommonDo();
            ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(rspBo.getTaskInstId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(11111L);
            uocCommonDo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
            log.info("\u62c6\u5355\u6d41\u8f6c\u539f\u8ba2\u5355\u7684\u4efb\u52a1,{}", (Object)JSON.toJSONString((Object)uocCommonDo));
            this.iUocCommonModel.dealTask(uocCommonDo);
        }
        UocDMsgPoolQryBo qryBo1 = new UocDMsgPoolQryBo();
        qryBo1.setId(reqBo.getDycUocQryMsgBO().getId());
        qryBo1.setRunResult(1);
        this.iUocOrderModel.updateMsgPoolById(qryBo1);
        return rspBo;
    }

    public UocSaleOrderDo qrySale(UocMsgSplitOrderReqBo reqBo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBo.getDycUocQryMsgBO().getObjId());
        return this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    public Long splitCoreOrder(UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO) {
        UocChildSaleOrderBO childSaleOrderRspBO = uocCreateOrdByOrdSplitBO.getUocChildSaleOrderBO();
        Long totalFee = 0L;
        Long freight = null;
        Long newSaleOrderId = IdUtil.nextId();
        try {
            totalFee = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getOrderPrice());
            freight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getFreight());
            if (freight == null) {
                freight = 0L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38\uff1a\u8f6c\u6362\u8ba2\u5355\u8d39\u7528\u9519\u8bef!");
        }
        UocSaleOrderQryBo uocSaleOrderBo = new UocSaleOrderQryBo();
        uocSaleOrderBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        uocSaleOrderBo.setSaleOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
        UocSaleOrderDo saleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderBo);
        saleOrderDo.setSaleOrderId(newSaleOrderId);
        saleOrderDo.setUpperOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
        saleOrderDo.setSaleOrderNoExt(String.valueOf(childSaleOrderRspBO.getOrderId()));
        try {
            saleOrderDo.setTotalSaleFee(MoneyUtils.Long2BigDecimal((Long)totalFee));
            saleOrderDo.setTotalPurchaseFee(MoneyUtils.Long2BigDecimal((Long)totalFee));
            saleOrderDo.setTotalTransFee(MoneyUtils.Long2BigDecimal((Long)freight));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38\uff1a\u8f6c\u6362\u8ba2\u5355\u8d39\u7528\u9519\u8bef!");
        }
        List exSkuList = childSaleOrderRspBO.getSku();
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
        List<UocSaleOrderItem> saleItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        ArrayList<UocSaleOrderItem> newSaleItemList = new ArrayList<UocSaleOrderItem>();
        BigDecimal totalSaleFee = BigDecimal.ZERO;
        for (UocSaleOrderItem saleOrderItem : saleItemList) {
            Long newSaleOrderItemId = IdUtil.nextId();
            for (Object extSkuBo : exSkuList) {
                if (!saleOrderItem.getSkuExtSkuId().equals(extSkuBo.getSkuId())) continue;
                UocSaleOrderItem newUocSaleOrderItem = (UocSaleOrderItem)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)saleOrderItem)), UocSaleOrderItem.class));
                newUocSaleOrderItem.setPurchaseCount(new BigDecimal(extSkuBo.getNum()));
                newUocSaleOrderItem.setSaleOrderId(newSaleOrderId);
                newUocSaleOrderItem.setSaleOrderItemId(newSaleOrderItemId);
                UocSaleItemMapQryBo uocSaleItemMapQryBo = new UocSaleItemMapQryBo();
                uocSaleItemMapQryBo.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                List<UocSaleItemMap> saleItemMapList = this.iUocSaleOrderModel.getSaleOrderItemMapList(uocSaleItemMapQryBo);
                ArrayList<UocSaleItemMap> newSaleItemMapList = new ArrayList<UocSaleItemMap>();
                for (UocSaleItemMap saleItemMap : saleItemMapList) {
                    UocSaleItemMap newSaleItemMap = (UocSaleItemMap)JSONObject.parseObject((String)JSON.toJSONString((Object)saleItemMap), UocSaleItemMap.class);
                    newSaleItemMap.setId(IdUtil.nextId());
                    newSaleItemMap.setSaleOrderItemId(newSaleOrderItemId);
                    newSaleItemMap.setSaleOrderId(newSaleOrderId);
                    newSaleItemMap.setCreateTime(new Date());
                    newSaleItemMapList.add(newSaleItemMap);
                }
                newUocSaleOrderItem.setSaleItemMapList(newSaleItemMapList);
                newSaleItemList.add(newUocSaleOrderItem);
                totalSaleFee = totalSaleFee.add(newUocSaleOrderItem.getSaleFee());
            }
        }
        saleOrderDo.setSaleOrderItems(newSaleItemList);
        saleOrderDo.setTotalSaleFee(totalSaleFee);
        Integer isJdCz = 2;
        if (ObjectUtil.isNotEmpty((Object)childSaleOrderRspBO.getOrderType()) && childSaleOrderRspBO.getOrderType() == 5) {
            isJdCz = 1;
        }
        saleOrderDo.setJdCz(isJdCz);
        saleOrderDo.setSaleOrderState("XS_FH_DFH");
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
        uocSaleOrderMapQryBo.setSaleOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
        List<UocSaleOrderMap> saleOrderMapList = this.iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
        ArrayList<UocSaleOrderMap> newSaleOrderMapList = new ArrayList<UocSaleOrderMap>();
        for (UocSaleOrderMap saleOrderMap : saleOrderMapList) {
            UocSaleOrderMap newSaleOrderMap = (UocSaleOrderMap)JSONObject.parseObject((String)JSON.toJSONString((Object)saleOrderMap), UocSaleOrderMap.class);
            newSaleOrderMap.setId(IdUtil.nextId());
            newSaleOrderMap.setCreateTime(new Date());
            newSaleOrderMap.setSaleOrderId(newSaleOrderId);
            newSaleOrderMapList.add(newSaleOrderMap);
        }
        saleOrderDo.setSaleOrderMapList(newSaleOrderMapList);
        this.iUocSaleOrderModel.createSaleOrder(saleOrderDo);
        UocOrderQueryIndex uocOrderQueryIndex = new UocOrderQueryIndex();
        uocOrderQueryIndex.setObjId(newSaleOrderId);
        uocOrderQueryIndex.setOrderSystem(UocDicConstant.OBJ_TYPE.SALE.toString());
        uocOrderQueryIndex.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderQueryIndex.setOutObjId(String.valueOf(childSaleOrderRspBO.getOrderId()));
        uocOrderQueryIndex.setOrderId(saleOrderDo.getOrderId());
        uocOrderQueryIndex.setId(IdUtil.nextId());
        this.iUocCommonModel.saveOrderQueryIndex(uocOrderQueryIndex);
        try {
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setSaleOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
            uocSaleOrderDo.setSaleOrderState("XS_SPLIT");
            uocSaleOrderDo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
            this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        }
        catch (Exception e) {
            log.error("\u62c6\u5355\u5931\u8d25:\u5220\u9664\u7236\u8ba2\u5355\u5f02\u5e38!:" + e.getMessage());
            throw new BaseBusinessException("101002", "\u62c6\u5355\u5931\u8d25:\u5220\u9664\u7236\u8ba2\u5355\u5f02\u5e38!");
        }
        return newSaleOrderId;
    }

    public void buildAccessort(Long newOrderId, UocOrderDo uocOrderDo, Long orderId) {
        UocOrderAccessoryQryBo accessoryQryBo = new UocOrderAccessoryQryBo();
        accessoryQryBo.setOrderId(orderId);
        List<UocOrderAccessory> accessoryList = this.iUocOrderModel.getOrderAccessoryList(accessoryQryBo);
        if (ObjectUtil.isNotEmpty(accessoryList)) {
            ArrayList<UocOrderAccessory> accessories = new ArrayList<UocOrderAccessory>();
            for (UocOrderAccessory accessory : accessoryList) {
                accessory.setOrderId(newOrderId);
                accessory.setId(IdUtil.nextId());
                accessory.setCreateTime(new Date());
                if (accessory.getObjType().equals(1)) {
                    accessory.setObjId(null);
                }
                accessories.add(accessory);
            }
            uocOrderDo.setAccessoryList(accessories);
        }
    }

    public void buildLogisticsRelaParam(Long newOrderId, UocOrderDo uocOrderDo, Long orderId) {
        UocOrdLogisticsRelaQryBo logisticsRelaQryBo = new UocOrdLogisticsRelaQryBo();
        logisticsRelaQryBo.setOrderId(orderId);
        UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(logisticsRelaQryBo);
        if (null != uocOrdLogisticsRela) {
            uocOrdLogisticsRela.setContactId(IdUtil.nextId());
            uocOrdLogisticsRela.setOrderId(newOrderId);
        }
        uocOrderDo.setReceiverAddress(uocOrdLogisticsRela);
    }

    public void buildOrderMapExtParam(Long newOrderId, UocOrderDo uocOrderDo, Long orderId) {
        UocOrderMapQryBo orderMapQryBo = new UocOrderMapQryBo();
        orderMapQryBo.setOrderId(orderId);
        List<UocOrderMap> uocOrderMaps = this.iUocOrderModel.qryOrderMapList(orderMapQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderMaps)) {
            ArrayList<UocOrderMap> poList = new ArrayList<UocOrderMap>();
            for (UocOrderMap orderMap : uocOrderMaps) {
                orderMap.setId(IdUtil.nextId());
                orderMap.setOrderId(newOrderId);
                poList.add(orderMap);
            }
            uocOrderDo.setOrderExt(poList);
        }
    }

    public void buildSaleAndItemParam(Long newOrderId, UocSaleOrderDo saleOrderQryDo, UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO) {
        UocChildSaleOrderBO childSaleOrderRspBO = uocCreateOrdByOrdSplitBO.getUocChildSaleOrderBO();
        Long totalFee = 0L;
        Long baseFreight = null;
        Long freight = null;
        try {
            totalFee = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getOrderPrice());
            baseFreight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getBaseFreight());
            if (baseFreight == null) {
                baseFreight = 0L;
            }
            if ((freight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getFreight())) == null) {
                freight = 0L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38\uff1a\u8f6c\u6362\u8ba2\u5355\u8d39\u7528\u9519\u8bef!");
        }
        try {
            UocSaleOrderQryBo uocSaleOrderBo = new UocSaleOrderQryBo();
            uocSaleOrderBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
            saleOrderQryDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderBo);
            saleOrderQryDo.setOrderId(newOrderId);
            saleOrderQryDo.setSaleOrderId(IdUtil.nextId());
            saleOrderQryDo.setSaleOrderNo("");
            saleOrderQryDo.setTotalSaleFee(MoneyUtils.Long2BigDecimal((Long)totalFee));
            saleOrderQryDo.setTotalPurchaseFee(MoneyUtils.Long2BigDecimal((Long)totalFee));
            saleOrderQryDo.setTotalTransFee(MoneyUtils.Long2BigDecimal((Long)baseFreight));
            saleOrderQryDo.setTotalTransFee(MoneyUtils.Long2BigDecimal((Long)(baseFreight + freight)));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38\uff1a\u8f6c\u6362\u8ba2\u5355\u8d39\u7528\u9519\u8bef!");
        }
        List exSkuList = childSaleOrderRspBO.getSku();
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        List<UocSaleOrderItem> saleItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        for (UocSaleOrderItem saleOrderItem : saleItemList) {
            Long saleOrderItemId = IdUtil.nextId();
            for (UocOrderSkuBO extSkuBo : exSkuList) {
                if (!saleOrderItem.getSkuExtSkuId().equals(extSkuBo.getSkuId())) continue;
                saleOrderItem.setPurchaseCount(new BigDecimal(extSkuBo.getNum()));
            }
            saleOrderItem.setOrderId(newOrderId);
            saleOrderItem.setSaleOrderItemId(saleOrderItemId);
        }
        saleOrderQryDo.setSaleOrderItems(saleItemList);
    }

    public void buildPayConfig(Long newOrderId, UocSaleOrderDo saleOrderQryDo, Long orderId) {
        UocSaleOrderPayConfQryBo payConfQryBo = new UocSaleOrderPayConfQryBo();
        payConfQryBo.setOrderId(orderId);
        List<UocSaleOrderPayConf> payConfList = this.iUocSaleOrderModel.getSaleOrderPayConfList(payConfQryBo);
        if (ObjectUtil.isEmpty(payConfList)) {
            return;
        }
        UocSaleOrderPayConf uocSaleOrderPayConf = payConfList.get(0);
        uocSaleOrderPayConf.setId(IdUtil.nextId());
        uocSaleOrderPayConf.setOrderId(newOrderId);
        if (ObjectUtil.isNotEmpty((Object)uocSaleOrderPayConf.getPrePayFee())) {
            BigDecimal preFee = saleOrderQryDo.getTotalSaleFee().divide(saleOrderQryDo.getTotalSaleFee(), 2, 0).multiply(uocSaleOrderPayConf.getPrePayFee()).setScale(2, 0);
            preFee = preFee.multiply(new BigDecimal(10000));
            uocSaleOrderPayConf.setPrePayFee(preFee);
        }
        saleOrderQryDo.getSaleOrderPayConfList().add(uocSaleOrderPayConf);
    }
}

