/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocAfterOrderConfirmOrRefuseService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfOrderServiceInfoBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderConfirmOrRefuseReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocAfterOrderConfirmOrRefuseService"})
public class UocAfterOrderConfirmOrRefuseServiceImpl
implements UocAfterOrderConfirmOrRefuseService {
    private static final Logger log = LoggerFactory.getLogger(UocAfterOrderConfirmOrRefuseServiceImpl.class);
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel shipOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    private static final Integer OP_FLAG_CONFIRM = 1;
    private static final Integer OP_FLAG_REFUSE = 0;

    @PostMapping(value={"dealAfterOrder"})
    public UocAfterOrderConfirmOrRefuseRspBo dealAfterOrder(@RequestBody UocAfterOrderConfirmOrRefuseReqBo reqBo) {
        this.validateArg(reqBo);
        UocAfterOrderConfirmOrRefuseRspBo rspBo = UocRu.success(UocAfterOrderConfirmOrRefuseRspBo.class);
        List<UocAfOrderDo> afOrderDos = this.buildUpdateBatchAfParam(reqBo);
        this.iUocAfOrderModel.updateBatchAfOrderMain(afOrderDos);
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            this.updateAfingCount(reqBo);
        }
        this.buidRspBo(reqBo, rspBo);
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(reqBo.getTaskId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(11111L);
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
        log.info("\u4f9b\u5e94\u5546\u786e\u8ba4\u91c7\u8d2d\u7533\u8bf7\u51fa\u53c2\uff1a" + rspBo);
        return rspBo;
    }

    private void buidRspBo(UocAfterOrderConfirmOrRefuseReqBo reqBo, UocAfterOrderConfirmOrRefuseRspBo rspBo) {
        ArrayList<Integer> pickWareTypes = new ArrayList<Integer>();
        ArrayList<String> shipOrderItemIds = new ArrayList<String>();
        ArrayList<String> saleOrderIdList = new ArrayList<String>();
        ArrayList<Object> afOrderServiceInfoBoList = new ArrayList<Object>();
        for (UocAfterOrderConfirmOrRefuseReqItemBo uocAfterOrderConfirmOrRefuseReqItemBo : reqBo.getAfOrderList()) {
            UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
            uocAfOrderQryBo.setAfOrderId(uocAfterOrderConfirmOrRefuseReqItemBo.getAfOrderId());
            UocAfOrder afOrderInfo = this.iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
            afOrderServiceInfoBoList.add(JSONObject.parseObject((String)JSON.toJSONString((Object)afOrderInfo), UocAfOrderServiceInfoBo.class));
            pickWareTypes.add(afOrderInfo.getPickwareType());
            saleOrderIdList.add(afOrderInfo.getSaleOrderId() + "-" + afOrderInfo.getOrderId());
            UocAfOrderItemQryBo uocAfOrderItemQryBo = new UocAfOrderItemQryBo();
            uocAfOrderItemQryBo.setAfOrderId(afOrderInfo.getAfOrderId());
            List<UocAfOrderItem> afOrderItemList = this.iUocAfOrderModel.getAfOrderItemList(uocAfOrderItemQryBo);
            UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
            uocShipOrderItemQryBo.setShipOrderItemId(afOrderItemList.get(0).getShipItemId());
            List<UocShipOrderItem> shipOrderItemList = this.shipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);
            UocShipOrderItem uocShipOrderItem = shipOrderItemList.get(0);
            shipOrderItemIds.add(uocShipOrderItem.getShipOrderId() + "-" + uocShipOrderItem.getOrderId());
        }
        rspBo.setPickwareType(pickWareTypes);
        rspBo.setAfOrderServiceInfoBoList(afOrderServiceInfoBoList);
        rspBo.setAfOrderIdList(reqBo.getAfOrderList().stream().map(obj -> obj.getAfOrderId() + "-" + obj.getOrderId()).collect(Collectors.toList()));
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            rspBo.setSaleOrderIdList(saleOrderIdList.stream().distinct().collect(Collectors.toList()));
            rspBo.setShipOrderIdList(shipOrderItemIds.stream().distinct().collect(Collectors.toList()));
        }
    }

    private void updateAfingCount(UocAfterOrderConfirmOrRefuseReqBo reqBo) {
        List afOrderList = reqBo.getAfOrderList();
        for (UocAfterOrderConfirmOrRefuseReqItemBo uocAfterOrderConfirmOrRefuseReqItemBo : afOrderList) {
            UocAfOrderItemQryBo uocAfOrderQryBo = new UocAfOrderItemQryBo();
            uocAfOrderQryBo.setAfOrderId(uocAfterOrderConfirmOrRefuseReqItemBo.getAfOrderId());
            uocAfOrderQryBo.setOrderId(uocAfterOrderConfirmOrRefuseReqItemBo.getOrderId());
            List<UocAfOrderItem> afOrderItemList = this.iUocAfOrderModel.getAfOrderItemList(uocAfOrderQryBo);
            for (UocAfOrderItem uocAfOrderItem : afOrderItemList) {
                Long orderItemId = uocAfOrderItem.getSaleItemId();
                BigDecimal returnCount = uocAfOrderItem.getReturnCount();
                Long shipItemId = uocAfOrderItem.getShipItemId();
                UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setOrderId(uocAfOrderItem.getOrderId());
                uocShipOrderItem.setShipOrderItemId(shipItemId);
                uocShipOrderItem.setAfterServingCount(returnCount.negate());
                uocShipOrderItem.setUpdateTime(new Date());
                uocShipOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
                this.shipOrderModel.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
                UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setOrderId(uocAfOrderItem.getOrderId());
                uocSaleOrderItem.setSaleOrderItemId(orderItemId);
                uocSaleOrderItem.setAfterServingCount(returnCount.negate());
                uocSaleOrderItem.setUpdateTime(new Date());
                uocSaleOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
                this.iUocSaleOrderModel.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
            }
        }
    }

    private List<UocAfOrderDo> buildUpdateBatchAfParam(UocAfterOrderConfirmOrRefuseReqBo reqBo) {
        ArrayList<UocAfOrderDo> afOrderDos = new ArrayList<UocAfOrderDo>();
        for (UocAfterOrderConfirmOrRefuseReqItemBo uocAfterOrderConfirmOrRefuseReqItemBo : reqBo.getAfOrderList()) {
            UocAfOrderDo uocAfOrderDo = new UocAfOrderDo();
            uocAfOrderDo.setAfOrderId(uocAfterOrderConfirmOrRefuseReqItemBo.getAfOrderId());
            uocAfOrderDo.setOrderId(uocAfterOrderConfirmOrRefuseReqItemBo.getOrderId());
            uocAfOrderDo.setReturnReason(reqBo.getReturnReason());
            uocAfOrderDo.setUpdateTime(new Date());
            uocAfOrderDo.setServState(reqBo.getOpFlag().equals(1) ? UocDicConstant.SERVICE_STATE.APPROVAL_PASS : UocDicConstant.SERVICE_STATE.APPROVAL_NOT_PASS);
            if (reqBo.getOpFlag() == 0) {
                uocAfOrderDo.setPayState(UocDicConstant.PAY_AFTER_STATE.CANCELED);
            }
            if (null != reqBo.getReturnAddress() && null != reqBo.getReturnAddress().getContactProvinceId() && !"".equals(reqBo.getReturnAddress().getContactProvinceId())) {
                long id = IdUtil.nextId();
                uocAfOrderDo.setReturnAddress(UocRu.js(reqBo.getReturnAddress(), UocOrdLogisticsRela.class));
                uocAfOrderDo.getReturnAddress().setContactId(id);
                uocAfOrderDo.getReturnAddress().setOrderId(reqBo.getOrderId());
                uocAfOrderDo.setExtField1(String.valueOf(id));
            }
            afOrderDos.add(uocAfOrderDo);
        }
        return afOrderDos;
    }

    private void validateArg(UocAfterOrderConfirmOrRefuseReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOpFlag()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty((Collection)reqBo.getAfOrderList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u552e\u540e\u5355\u636e\u4e3a\u7a7a");
        }
        for (UocAfterOrderConfirmOrRefuseReqItemBo uocAfterOrderConfirmOrRefuseReqItemBo : reqBo.getAfOrderList()) {
            if (null == uocAfterOrderConfirmOrRefuseReqItemBo.getOrderId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
            }
            if (null != uocAfterOrderConfirmOrRefuseReqItemBo.getAfOrderId()) continue;
            throw new BaseBusinessException("100001", "\u5165\u53c2\u552e\u540e\u5355ID\u4e3a\u7a7a");
        }
    }
}

