package com.tydic.dyc.oc.model.insporder.sub;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocInspOrderItem
 * 说明:验收明细
 * 时间:2022-02-21 19:09
 * 作者:罗有
 **/
@Data
public class UocInspOrderItem implements Serializable {
	private static final long serialVersionUID =  -6376640365849311275L;

	@DocField(value = "验收明细id")
	private Long inspOrderItemId;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "销售单id")
	private Long saleOrderId;

	@DocField(value = "执行明细id")
	private Long implOrderItemId;

	@DocField(value = "销售明细id")
	private Long saleOrderItemId;


	@DocField(value = "验收单id")
	private Long inspOrderId;

	@DocField(value = "发货明细ID")
	private Long shipOrderItemId;

	@DocField(value = "状态1 已验收 2 退货申请中             3 退货完成")
	private String inspItemStatus;

	@DocField(value = "计量单位")
	private String unitName;

	@DocField(value = "验收数量")
	private BigDecimal inspCount;

	@DocField(value = "退货中数量")
	private BigDecimal returnCount;

	@DocField(value = "已退货数量")
	private BigDecimal alreadyReturnCount;

	@DocField(value = "异常变更在途数量")
	private BigDecimal chngingCount;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "纵向扩展")
	private List<UocInspItemMap> itemExtParallelBoList;


	@DocField(value = "订单IDList")
	private List<Long> orderIdList;


	@DocField(value = "验收单明细IdList")
	private List<Long> inspOrderItemsIdList;

	@DocField(value = "计量单位位数")
	private String unitDigit;
    
    @DocField(value = "验收数量")
    private BigDecimal inspItemCount;
}
