package com.tydic.dyc.oc.service.common;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.order.sub.UocTodo;
import com.tydic.dyc.oc.service.common.bo.UocUpdateTodoInfoByIdReqBo;
import com.tydic.dyc.oc.service.common.bo.UocUpdateTodoInfoByIdRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 描述: 〈领域服务-更新待办数据 实现〉
 * @author : 王久鑫
 * @date : 2022/10/27 14:05
 */
@HTServiceImpl
public class UocUpdateTodoInfoByIdServiceImpl implements UocUpdateTodoInfoByIdService{
    @Autowired
    private IUocCommonModel uocCommonModel;
    @Override
    public UocUpdateTodoInfoByIdRspBo updateTodoInfoById(UocUpdateTodoInfoByIdReqBo uocUpdateTodoInfoByIdReqBo) {
        validateArgs(uocUpdateTodoInfoByIdReqBo);
        UocTodo uocTodo = new UocTodo();
        BeanUtils.copyProperties(uocUpdateTodoInfoByIdReqBo,uocTodo);
        uocCommonModel.updateTodoById(uocTodo);
        UocUpdateTodoInfoByIdRspBo rspBO = new UocUpdateTodoInfoByIdRspBo();
        rspBO.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBO;
    }
    private void validateArgs(UocUpdateTodoInfoByIdReqBo uocUpdateTodoInfoByIdReqBo){
        if (null == uocUpdateTodoInfoByIdReqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocUpdateTodoInfoByIdReqBo.getTodoId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参待办ID不能为空");
        }
    }
}
