package com.tydic.dyc.oc.model.saleorder;

import com.tydic.dyc.base.bo.BaseExtendBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocSaleOrder
 * 说明:销售订单
 * 时间:2022-02-21 14:26
 * 作者:罗有
 **/
@Data
public class UocSaleOrderDo  extends BaseExtendBo {
	private static final long serialVersionUID =  -2623077385921898547L;

	@DocField(value = "销售单id")
	private Long saleOrderId;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "三方信息id")
	private Long stakeholderId;

	@DocField(value = "销售单编码")
	private String saleOrderNo;

	@DocField(value = "外部销售单编码")
	private String saleOrderNoExt;

	@DocField(value = "销售单名称")
	private String saleOrderName;

	@DocField(value = "销售单类型")
	private Integer saleOrderType;

	@DocField(value = "订单状态")
	private String saleOrderState;

	@DocField(value = "订单状态翻译")
	private String saleOrderStateStr;

	@DocField(value = "销售单单说明")
	private String saleOrderDesc;

	@DocField(value = "订单来源  1 自营单品   2 电商导入   3 协议生成    ")
	private Integer orderSource;

	@DocField(value = "订单来源翻译")
	private String orderSourceStr;

	@DocField(value = "支付类型")
	private Integer payMod;

	@DocField(value = "支付类型翻译")
	private String payModStr;

	@DocField(value = "支付方式")
	private String payType;

	@DocField(value = "支付方式翻译")
	private String payTypeStr;

	@DocField(value = "销售金额")
	private BigDecimal totalSaleFee;

	@DocField(value = "采购金额")
	private BigDecimal totalPurchaseFee;

	@DocField(value = "优惠金额")
	private BigDecimal totalActShareFee;

	@DocField(value = "运费")
	private BigDecimal totalTransFee;

	@DocField(value = "实付金额")
	private BigDecimal usedFee;

	@DocField(value = "实付积分")
	private BigDecimal usedIntegral;

	@DocField("协议id")
	private String agreementId;

	@DocField(value = "协议编号")
	private String agreementNo;

	@DocField("协议数据id")
	private Long agrDataId;

	@DocField(value = "合同编号")
	private String contractNo;

	@DocField(value = "支付状态")
	private Integer payState;

	@DocField(value = "支付状态翻译")
	private String payStateStr;

	@DocField(value = "流转状态")
	private String procState;

	@DocField(value = "流转状态翻译")
	private String procStateStr;

	@DocField(value = "税率")
	private String taxRate;

	@DocField(value = "竣工标志             1 竣工             0 在途")
	private Integer finishFlag;

	@DocField(value = "竣工标志翻译")
	private String finishFlagStr;

	@DocField(value = "租户ID")
	private String tenantId;

	@DocField(value = "送货时间")
	private Date sendTime;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "撤单时间")
	private Date cancelTime;

	@DocField(value = "撤单工号")
	private String cancelOperId;

	@DocField(value = "撤单原因")
	private String cancelReason;
	@DocField(value = "撤单原因标识")
	private Integer cancelReasonFlag;

	@DocField(value = "取消订单申请同意拒绝原因")
	private String cancelReplyContent;

	@DocField(value = "取消订单申请同意拒绝原因时间")
	private Date cancelReplyTime;

	@DocField(value = "创建人名称")
	private String createOperName;

	@DocField(value = "更新人名称")
	private String updateOperName;

	@DocField(value = "撤单人名称")
	private String cancelOperName;

	@DocField(value = "供应商拒单原因")
	private String rejectReason;

	@DocField(value = "供应商拒单人")
	private String rejectOperId;

	@DocField(value = "供应商拒单人名称")
	private String rejectOperName;

	@DocField(value = "供应商拒单时间")
	private Date rejectTime;

	@DocField(value = "撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	@DocField(value = "撤单标志翻译")
	private String cancelFlagStr;

	@DocField(value = "竣工时间")
	private Date finishTime;

	@DocField(value = "逾期时间")
	private Date expTime;

	@DocField(value = "结算模式 2:撮合 1:贸易")
	private Integer modelSettle;

	@DocField(value = "结算模式翻译")
	private String modelSettleStr;

	@DocField(value = "采购类别             1 物资             2 施工             3 服务             ")
	private Integer purchaseType;

	@DocField(value = "采购类别翻译")
	private String purchaseTypeStr;

	@DocField(value = "采购模式   1计划，2非计划")
	private Integer purchaseMode;

	@DocField(value = "采购模式翻译")
	private String purchaseModeStr;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "总金额")
	private BigDecimal totalFee;

	@DocField(value = "总数量")
	private Integer totalCount;

	@DocField(value = "撤单申请时间")
	private Date cancelRequestTime;

	@DocField(value = "是否已关闭尾差 1是 0否")
	private Integer closePennyDiff;

	@DocField(value = "销售单扩展")
	private List<UocSaleOrderMap> saleOrderMapList;

	@DocField(value = "销售单明细")
	private List<UocSaleOrderItem> saleOrderItems;

	@DocField(value = "三方信息")
	private UocSaleStakeholder stakeholder;

	@DocField(value = "销售单支付配置")
	private List<UocSaleOrderPayConf> saleOrderPayConfList;

	@DocField("销售单附件")
	private List<UocOrderAccessory> saleOrderAccessoryList;

	@DocField("是否收取成交服务费")
	private Boolean isCreateServiceFee = false;

	@DocField(value = "订单IDList")
	private List<Long> orderIdList;


	@DocField(value = "销售单IdList")
	private List<Long> saleOrderItemsIdList;

	@DocField(value = "协议经办人id（配送专责）")
	private String proDeliveryId;

	@DocField(value = "协议经办人名字（配送专责）")
	private String proDeliveryName;

	@DocField(value = "调价机制：0：无，1：事前调价，2：事中调价 默认值：0")
	private Integer adjustPrice;

	@DocField(value = "订单创建结果 0创建中，1成功，2失败")
	private Integer createdResult;

	@DocField(value = "调价人id")
	private String adjustPriceOperId;

	@DocField(value = "调价人名称")
	private String adjustPriceOperName;

	@DocField(value = "调价时间")
	private Date adjustPriceTime;
	@DocField(value = "是否京东长直，1是，0否，默认0")
	private Integer jdCz;

	@DocField(value = "是否京东长直，1是，0否，默认0 翻译")
	private String jdCzStr;

	@DocField(value = "删除标志1已删除")
	private Integer delTag;

	@DocField(value = "异常变更在途数量")
	private BigDecimal chngingCount;
    
    @DocField(value = "父订单id 销售订单id")
    private Long upperOrderId;

    @DocField(value = "供应商编码")
	private Long supId;

	@DocField(value = "任务id")
	private String taskId;
	
	@DocField(value = "状态列表")
    private List<String> saleOrderStateList;
    
    @DocField(value = "创建时间 开始")
    private Date createTimeStart;
    
    @DocField(value = "创建时间 结束")
    private Date createTimeEnd;
    
    @DocField(value = "流程实例id")
    private String procInstId;
    
    @DocField(value = "是否拆单生成订单")
    private Boolean splitCreateOrder = false;
    
}
