package com.tydic.dyc.oc.model.payorder.sub;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocPayOrder
 * 说明:支付单
 * 时间:2022-02-21 19:11
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocPayOrder implements Serializable {
	private static final long serialVersionUID =  8208620837787203712L;

	@DocField(value = "支付单id")
	private Long payOrderId;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "支付名称")
	private String payName;

	@DocField(value = "支付类型            1 线上支付    2 线下支付")
	private Integer payMod;

	@DocField(value = "支付方式             1 微信             2 支付宝             3 企业支付")
	private Integer payType;

	@DocField(value = "支付优先级")
	private String payLevel;

	@DocField(value = "外部支付流水")
	private String outPayOrderNo;

	@DocField(value = "退款/扣款标志             0 扣款             1 退款")
	private Integer interType;

	@DocField(value = "应付金额")
	private BigDecimal totalFee;

	@DocField(value = "应付金额占比")
	private BigDecimal totalFeeSup;

	@DocField(value = "减免金额")
	private BigDecimal reduceFee;

	@DocField(value = "红包金额")
	private BigDecimal redEnvelopeFee;

	@DocField(value = "活动金额")
	private BigDecimal actFee;

	@DocField(value = "实付金额")
	private BigDecimal payFee;

	@DocField(value = "违约金比例")
	private BigDecimal penaltyRatio;

	@DocField(value = "已付金额")
	private BigDecimal paidFee;

	@DocField(value = "支付金额类型")
	private Integer payFeeType;

	@DocField(value = "支付状态")
	private String payState;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "付款方ID")
	private String payerId;

	@DocField(value = "付款方名称")
	private String payerName;

	@DocField(value = "收款方ID")
	private String payeeId;

	@DocField(value = "收款方名称")
	private String payeeName;

	@DocField(value = "合同编号")
	private String contractNo;

	@DocField(value = "合同ID")
	private String contractId;

	@DocField(value = "租户ID")
	private String tenantId;

	@DocField(value = "支付工号")
	private String payOperId;

	@DocField(value = "支付时间")
	private Date payTime;

	@DocField(value = "竣工标志             1 竣工             0 在途")
	private Integer finishFlag;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "撤单时间")
	private Date cancelTime;

	@DocField(value = "撤单工号")
	private String cancelOperId;

	@DocField(value = "撤单原因")
	private String cancelReason;

	@DocField(value = "撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	@DocField(value = "竣工时间")
	private Date finishTime;

	@DocField(value = "逾期时间")
	private Date expTime;



}
