package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderReqShipBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEcArrvalAcceptanceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEcArrvalAcceptanceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 标题:UocEcArrvalAcceptanceServiceImpl
 * 说明:TODO
 * 时间:2022/4/7 15:16
 * 作者:代愿愿
 */
@HTServiceImpl
@Slf4j
public class UocEcArrvalAcceptanceServiceImpl implements UocEcArrvalAcceptanceService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    /**
     * 全部验收完成
     */
    private static final String OP_FLAG_YES = "1";

    @Override
    public UocEcArrvalAcceptanceRspBo dealEcArrvalAcceptance(UocEcArrvalAcceptanceReqBo reqBo) {
        // 入参校验
        validateArg(reqBo);
        // 是否有未完结的售后
        List<UocAfOrder> uocAfOrders = validateAfOrderUnfinished(reqBo.getSaleOrderId());
        // 校验销售单明细的采购数量=到货数量+拒收数量才能验收
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.getCollectCountImplOrderItem(uocSaleOrderItemQryBo);
        UocSaleOrderItem uocSaleOrderItem = uocSaleOrderDo.getSaleOrderItems().get(0);
        if (uocSaleOrderItem.getPurchaseCount().compareTo(uocSaleOrderItem.getArriveCount().add(uocSaleOrderItem.getRefuseCount()).add(uocSaleOrderItem.getReturnCount())) != 0) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "存在不能验收的数据");
        }
        Date nowDate = new Date();
        List<UocCreateInspOrderReqShipBo> shipOrderList = new ArrayList<>();
        //创建验收单相关信息
        UocInspOrderDo uocInspOrderDo = convertInspOrderDo(reqBo, nowDate, shipOrderList, uocAfOrders);
        iUocInspOrderModel.createInspOrder(uocInspOrderDo);
        // 更新发货单验收信息
        updateShipOrderInspInfo(reqBo, nowDate);
        // 更新发货单明细验收信息
        updateShipOrderItemInspInfo(reqBo, nowDate);
        // 更新销售单明细验收信息
        updateSaleOrderItemInspInfo(reqBo, nowDate);
        // 修改销售单状态
        modifySaleOrderState(reqBo);
        //创建订单结算关联数据
        this.createOrderSettleRelInfo(reqBo, uocInspOrderDo.getInspOrderId());
        // 设置出参
        UocEcArrvalAcceptanceRspBo uocEcArrvalAcceptanceRspBo = UocRu.success(UocEcArrvalAcceptanceRspBo.class);
        uocEcArrvalAcceptanceRspBo.setInspOrderId(uocInspOrderDo.getInspOrderId());
        uocEcArrvalAcceptanceRspBo.setShipOrderList(shipOrderList);
        // 提交任务
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo =
                new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(reqBo.getTaskId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(11111l);
        uocCommonDo.setOrderId(reqBo.getOrderId());
        iUocCommonModel.dealTask(uocCommonDo);
        return uocEcArrvalAcceptanceRspBo;
    }

    /**
     * 更新销售单状态，如发货单存在拒收则销售单为部分验收，否则全部验收
     */
    private void modifySaleOrderState(UocEcArrvalAcceptanceReqBo reqBo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocShipOrderDo> shipOrderDos = iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);

        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId() + "");
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_YS_YS);
        //电商不支持部分验收，都是整单验收
//        shipOrderDos.forEach(uocShipOrderDo -> {
//            if (!UocStateConstants.ShipOrder.FH_FH_YS.equals(uocShipOrderDo.getShipOrderState())) {
//                uocSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_YS_BFYS);
//            }
//        });
        iUocSaleOrderModel.updateSaleStatusAndProCode(uocSaleOrderDo);
    }

    /**
     * 创建订单结算关联数据
     *
     * @param reqBo
     * @param inspOrderId
     */
    private void createOrderSettleRelInfo(UocEcArrvalAcceptanceReqBo reqBo, Long inspOrderId) {
        UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
        querySaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        querySaleOrderDo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(querySaleOrderDo);
        if (null != saleOrderMain) {
            //生产服务费结算关联数据
            this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.SERVICE_CHARGE);
            if (UocConstant.ModelSettle.MY.equals(saleOrderMain.getModelSettle())) {
                //贸易模式：
                //生成普通开票关联数据
                this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.COMMON_INVOICE);
                //生成上游开票关联数据
                this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.UP_INVOICE);
            } else if (UocConstant.ModelSettle.CH.equals(saleOrderMain.getModelSettle())) {
                //撮合模式：
                //生成下游撮合开票关联数据
                this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.CH_INVOICE);
            } else {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR,
                        "生产订单结算关联数据失败：错误的结算模式");
            }
        } else {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "生产订单结算关联数据失败：查询销售单单为空");
        }
    }

    /**
     * 生成外部关联数据
     *
     * @param reqBo
     * @param inspOrderId
     * @param relType
     */
    private void createRelInfo(UocEcArrvalAcceptanceReqBo reqBo, Long inspOrderId, Integer relType) {
        UocOrderRel createOrderRel = new UocOrderRel();
        //设置数据id
        createOrderRel.setId(IdUtil.nextId());
        //设置关联状态
        createOrderRel.setRelStatus(UocDicConstant.REL_STATUS.UN_SUBMITTED);
        //设置关联类型
        createOrderRel.setRelType(relType);
        //设置订单ID
        createOrderRel.setOrderId(reqBo.getOrderId());
        //设置关联对象id
        createOrderRel.setObjId(inspOrderId);
        //设置关联对象类型
        createOrderRel.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        this.iUocOrderModel.createRelInfo(createOrderRel);
    }


    /**
     * 更新销售单明细验收信息
     */
    private void updateSaleOrderItemInspInfo(UocEcArrvalAcceptanceReqBo reqBo, Date nowDate) {
        UocSaleOrderDo uocSaleOrderDo1 = new UocSaleOrderDo();
        uocSaleOrderDo1.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo1.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo1.setUpdateTime(nowDate);
        uocSaleOrderDo1.setUpdateOperId(reqBo.getUserId().toString());
        iUocSaleOrderModel.modifySaleOrderItemInspCountEqualArrivalCount(uocSaleOrderDo1);
    }

    /**
     * 更新发货单明细验收信息
     */
    private void updateShipOrderItemInspInfo(UocEcArrvalAcceptanceReqBo reqBo, Date nowDate) {
        UocShipOrderDo uocShipOrderDo1 = new UocShipOrderDo();
        uocShipOrderDo1.setOrderId(reqBo.getOrderId());
        uocShipOrderDo1.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderDo1.setUpdateOperId(reqBo.getUserId().toString());
        uocShipOrderDo1.setUpdateTime(nowDate);
        iUocShipOrderModel.modifyShipOrderItemInspCountEqualArrivalCount(uocShipOrderDo1);
    }

    /**
     * 更新发货单验收信息
     */
    private void updateShipOrderInspInfo(UocEcArrvalAcceptanceReqBo reqBo, Date nowDate) {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderId(reqBo.getOrderId());
        uocShipOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocShipOrderDo.setUpdateTime(nowDate);
        uocShipOrderDo.setInspOperId(reqBo.getUserId().toString());
        uocShipOrderDo.setInspOperName(reqBo.getName());
        uocShipOrderDo.setInspTime(nowDate);
        uocShipOrderDo.setInspOperPhone(reqBo.getCellphone());
        iUocShipOrderModel.modifyShipOrderMain(uocShipOrderDo);

        // 更新发货单状态
        UocShipOrderDo uocShipOrderDo1 = new UocShipOrderDo();
        uocShipOrderDo1.setOrderId(reqBo.getOrderId());
        uocShipOrderDo1.setSaleOrderId(reqBo.getSaleOrderId());
        iUocShipOrderModel.modifyShipOrderStatus(uocShipOrderDo1);
    }

    /**
     * 转换验收单领域参数
     */
    private UocInspOrderDo convertInspOrderDo(UocEcArrvalAcceptanceReqBo reqBo, Date nowDate,
                                              List<UocCreateInspOrderReqShipBo> shipOrderList, List<UocAfOrder> uocAfOrders) {
        // 查询销售单主体信息
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "查询验收单为空");
        }
        // 查询发货单
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocShipOrderDo> uocShipOrderDoList = iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        // 查询发货单明细
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        // 拼装验收单信息
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setOrderId(reqBo.getOrderId());
        uocInspOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocInspOrderDo.setInspOrderId(IdUtil.nextId());
        uocInspOrderDo.setInspOrderNo(getInspOrderNo(uocSaleOrderDo));
        uocInspOrderDo.setInspOrderState(UocStateConstants.InspOrder.YS_YS_YS);
        uocInspOrderDo.setInspOper(reqBo.getName());
        uocInspOrderDo.setCreateOperId(reqBo.getUserId().toString());
        uocInspOrderDo.setCreateTime(nowDate);
        uocInspOrderDo.setInvoiceTag(UocConstant.INVOICE_TAG.NO);
        uocInspOrderDo.setInspOperPhone(reqBo.getCellphone());
        uocInspOrderDo.setTenantId(reqBo.getTenantId());

        // 要减去售后完成的钱
        if ( !CollectionUtils.isEmpty(uocAfOrders) ) {
            BigDecimal afterPurTotalFee = uocAfOrders.stream().map(UocAfOrder::getRetTotalPurchaseFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal afterSaleTotalFee = uocAfOrders.stream().map(UocAfOrder::getRetTotalSaleFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            uocInspOrderDo.setTotalPurchaseFee(uocSaleOrderDo.getTotalPurchaseFee().subtract(afterPurTotalFee));
            uocInspOrderDo.setTotalSaleFee(uocSaleOrderDo.getTotalSaleFee().subtract(afterSaleTotalFee));
        } else {
            uocInspOrderDo.setTotalPurchaseFee(uocSaleOrderDo.getTotalPurchaseFee());
            uocInspOrderDo.setTotalSaleFee(uocSaleOrderDo.getTotalSaleFee());
        }

        // 拼装发货验收关系
        List<UocShipInspRel> uocShipInspRelList = new ArrayList<>();
        uocShipOrderDoList.forEach(uocShipOrderDo1 -> {
            // 拼装ES数据同步需要信息
            UocCreateInspOrderReqShipBo bo = new UocCreateInspOrderReqShipBo();
            bo.setShipOrderId(uocShipOrderDo1.getShipOrderId());
            shipOrderList.add(bo);

            UocShipInspRel uocShipInspRel = UocRu.js(uocInspOrderDo, UocShipInspRel.class);
            uocShipInspRel.setId(IdUtil.nextId());
            uocShipInspRel.setShipOrderId(uocShipOrderDo1.getShipOrderId());
            uocShipInspRel.setRemark(null);
            uocShipInspRelList.add(uocShipInspRel);
        });
        // 拼装验收单明细
        List<UocInspOrderItem> uocInspOrderItemList = new ArrayList<>();
        uocShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
            UocInspOrderItem uocInspOrderItem = UocRu.js(uocInspOrderDo, UocInspOrderItem.class);
            uocInspOrderItem.setInspOrderItemId(IdUtil.nextId());
            BigDecimal inspCount = uocShipOrderItem.getSendCount();
            if (null != uocShipOrderItem.getRefuseCount()) {
                inspCount = inspCount.subtract(uocShipOrderItem.getRefuseCount());
            }
            if (null != uocShipOrderItem.getReturnCount()) {
                inspCount = inspCount.subtract(uocShipOrderItem.getReturnCount());
            }
            log.info("验收数量：{}", inspCount);
            uocInspOrderItem.setInspCount(inspCount);
            uocInspOrderItem.setRemainInspCount(inspCount);
            uocInspOrderItem.setShipOrderItemId(uocShipOrderItem.getShipOrderItemId());
            uocInspOrderItem.setSaleOrderItemId(uocShipOrderItem.getSaleOrderItemId());
            uocInspOrderItem.setUnitName(uocShipOrderItem.getUnitName());
            uocInspOrderItem.setRemark(null);
            uocInspOrderItemList.add(uocInspOrderItem);
        });
        uocInspOrderDo.setUocShipInspRelList(uocShipInspRelList);
        uocInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
        return uocInspOrderDo;
    }

    /**
     * 获取验收单编号
     */
    private String getInspOrderNo(UocSaleOrderDo uocSaleOrderDo) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setOrderSource(uocSaleOrderDo.getOrderSource());
        return iUocInspOrderModel.getInspOrderNo(uocInspOrderDo).getInspOrderNo();
    }

    /**
     * 入参校验
     */
    private void validateArg(UocEcArrvalAcceptanceReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID为空");
        }
    }

    private List<UocAfOrder> validateAfOrderUnfinished(Long saleOrderId) {
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setSaleOrderId(saleOrderId);
        List<UocAfOrder> afOrderList = iUocAfOrderModel.getAfOrderList(uocAfOrderQryBo);
        // 如果没有售后单则直接返回
        if (!CollectionUtils.isEmpty(afOrderList)) {
            // 校验未完成的订单
            afOrderList.forEach(afOrder -> {
                if (!Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.COMPLATE)
                        && !Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.CANCEL)
                        && !Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.APPROVAL_NOT_PASS)) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "存在未完结的售后单，不能进行验收");
                }
            });
        }
        return afOrderList;
    }
}
