package com.tydic.dyc.oc.model.order.sub;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题:UocOrderInterLog
 * 说明:订单外部接口日志（其它中心或电商）领域对象
 * 时间:2022-02-21 19:10
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocOrderInterLog implements Serializable {
	private static final long serialVersionUID =  9082599844206281868L;

	@DocField(value = "id")
	private Long id;

	@DocField(value = "单据id                          单据类型为1=订单时，不填")
	private Long objId;

	@DocField(value = "单据类型:1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单     99.其他")
	private Integer objType;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "接口流水")
	private String interSn;

	@DocField(value = "接口编码")
	private String interCode;

	@DocField(value = "流程正反向标志             1 正向             2 反向")
	private Integer flowFlag;

	@DocField(value = "入参报文")
	private String inContent;

	@DocField(value = "出参报文")
	private String outContent;

	@DocField(value = "调用次数")
	private Integer callCount;

	@DocField(value = "调用时间")
	private Date callTime;

	@DocField(value = "调用时间 开始")
	private Date callTimeStart;

	@DocField(value = "调用时间 结束")
	private Date callTimeEnd;

	@DocField(value = "远端返回时间")
	private Date retTime;

	@DocField(value = "远端返回时间 开始")
	private Date retTimeStart;

	@DocField(value = "远端返回时间 结束")
	private Date retTimeEnd;

	@DocField(value = "调用状态")
	private String callState;

	@DocField(value = "异常编码")
	private String errCode;

	@DocField(value = "异常描述")
	private String errDetail;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "创建工号")
	private String createLoginId;

	

}
