package com.tydic.dyc.oc.model.order.sub;

import com.tydic.dyc.base.bo.BaseExtendBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqAgrBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderPlanBO;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocOrderItem
 * 说明:销售订单明细
 * 时间:2022-02-21 19:10
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocOrderItem extends BaseExtendBo {
	private static final long serialVersionUID =  -4840136198335619491L;

	@DocField(value = "订单明细id")
	private Long orderItemId;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "明细类型             1 商品sku             2 物资             3 项目")
	private Integer itemType;

	@DocField(value = "明细状态")
	private String orderItemState;

	@DocField(value = "商品id")
	private String commodityId;

	@DocField(value = "商品名称")
	private String commodityName;

	@DocField(value = "商品类型ID")
	private String commodityTypeId;

	@DocField(value = "商品类型名称")
	private String commodityTypeName;

	@DocField(value = "外部单品ID")
	private String extSkuId;

	@DocField(value = "单品ID")
	private String skuId;

	@DocField(value = "单品编码")
	private String skuCode;

	@DocField(value = "单品名称")
	private String skuName;

	@DocField(value = "供应商ID")
	private String supplierId;

	@DocField(value = "供应商名称")
	private String supplierName;

	@DocField(value = "供应商联系人")
	private String supRelaName;

	@DocField(value = "供应商联系电话")
	private String supRelaMobile;

	@DocField(value = "店铺ID")
	private String supplierShopId;

	@DocField(value = "店铺名称")
	private String supplierShopName;

	@DocField(value = "销售金额")
	private BigDecimal saleFee;

	@DocField(value = "采购金额")
	private BigDecimal purchaseFee;

	@DocField(value = "单品来源      1 自营单品   2 电商导入   3 协议生成    ")
	private Integer skuSource;

	@DocField(value = "采购金额")
	private BigDecimal purchasePrice;

	@DocField(value = "采购金额")
	private BigDecimal salePrice;

	@DocField(value = "采购数量")
	private BigDecimal purchaseCount;

	@DocField(value = "运费")
	private BigDecimal transFee;

	@DocField(value = "应付金额")
	private BigDecimal payFee;

	@DocField(value = "积分优惠金额")
	private BigDecimal integralDisFee;

	@DocField(value = "活动优惠金额")
	private BigDecimal actDisFee;

	@DocField(value = "其它优惠金额")
	private BigDecimal otherDisFee;

	@DocField(value = "实付金额")
	private BigDecimal usedFee;

	@DocField(value = "实付积分")
	private BigDecimal usedIntegral;

	@DocField(value = "币种")
	private String currencyType;

	@DocField(value = "税金")
	private String taxPrice;

	@DocField(value = "税率")
	private String tax;

	@DocField(value = "预计发货时间")
	private Date preSendTime;

	@DocField(value = "预计交货时间")
	private Date preOfferTime;

	@DocField(value = "计量单位")
	private String unitName;

	@DocField(value = "结算计量单位")
	private String settleUnit;

	@DocField(value = "外部电商主订单id")
	private String imOrderId;

	@DocField(value = "外部电商子订单id")
	private String imSubOrderId;

	@DocField(value = "到货周期")
	private String arrivalTime;

	@DocField(value = "加价率")
	private Double markUpRate;

	@DocField(value = "商品服务费 ")
	private String serPrice;

	@DocField("计划id")
	private String planId;

	@DocField("计划明细id")
	private String planItemId;

	@DocField(value = "计划编号")
	private String planNo;

	@DocField(value = "计划明细编号")
	private String planItemNo;

	@DocField(value = "超验百分比，下单时保存（协议、无协议）")
	private Integer inspectionExcessPercent;

	@DocField(value = "税务编码")
	private String taxId;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "协议经办人id（配送专责），协议商品必传")
	private String proDeliveryId;

	@DocField(value = "协议经办人名字（配送专责），协议商品必传")
	private String proDeliveryName;

	@DocField(value = "协议id")
	private String agreementId;

	@DocField(value = "协议编号")
	private String agreementNo;

	@DocField("协议bo，协议商品必传（根据协议id是否为空来判断）")
	private UocOrderAgreement agrBo;

	@DocField(value = "sku物料id")
	private String skuMaterialId;

	@DocField(value = "sku物料编码")
	private String skuMaterialCode;

	@DocField(value = "sku外部单品id")
	private String skuExtSkuId;

	@DocField(value = "sku品牌id")
	private Long skuBrandId;

	@DocField(value = "单品品牌名称")
	private String skuBrandName;

	@DocField(value = "sku明细id")
	private String skuItemId;

	@DocField(value = "sku物料名称")
	private String skuMaterialName;

	@DocField(value = "sku物料类型名称")
	private String skuMaterialTypeName;

	@DocField(value = "sku物料类型id")
	private String skuMaterialTypeId;

	@DocField(value = "型号")
	private String model;

	@DocField(value = "规格")
	private String spec;

	@DocField(value = "材质")
	private String texture;

	@DocField(value = "图号")
	private String figure;

	@DocField(value = "一级类目")
	private Long l1catalog;

	@DocField(value = "二级类目")
	private Long l2catalog;

	@DocField(value = "三级类目")
	private Long l3catalog;

	@DocField(value = "一级类目名称")
	private String l1catalogName;

	@DocField(value = "二级类目名称")
	private String l2catalogName;

	@DocField(value = "三级类目名称")
	private String l3catalogName;

	@DocField(value = "退货时间，空代表不支持")
	private Integer rejectAllowDate;

	@DocField(value = "换货时间，空代表不支持")
	private Integer exchangeAllowDate;

	@DocField(value = "维修时间，空代表不支持")
	private Integer maintainAllowDate;

	@DocField(value = "sku单品主图url")
	private String skuMainPicUrl;


	@DocField("商品json字符串，商品查询回原样数据，订单保存，以备未来使用")
	private String commJsonStr;


	@DocField("订单明细扩展")
	private List<UocOrderItemMap> itemMapList;
    
    
    @DocField(value = "销售单明细扩展")
    private List<UocSaleItemMap> saleItemMapList;
    
    
	@DocField("订单明细-商品-扩展")
	private List<UocOrderItemSnapshotMap> commSnapshotExtList;

	@DocField("订单延保信息")
	private List<UocOrderItemEw> ewList;
    
    //商品编码
    @DocField("商品编码")
    private String commodityCode;
    
    @DocField("比选单号")
    private String cmpOrderNo;
    
    @DocField(value = "未比选原因")
    private String noCmpReason;

    @DocField(value = "供货周期")
	private String deliveryTimeDate;

	@DocField(value = "计量单位位数")
	private String unitDigit;
    
    /**
     * 商品支持售后返回方式
     */
    private List<Integer> serverReturnTypeList;
    
    //商品关联计划明细列表
    private List<UocOrderPlanBO> orderPlanBOList;
}
