package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author WangJiuXin
 * @date 2023/6/20
 * @decr  新变更确认/拒绝（验收单维度）服务实现
 **/
@HTServiceImpl
public class UocChngOrderConfirmOrRefuseForInspServiceImpl implements UocChngOrderConfirmOrRefuseForInspService{
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    private static final Integer OP_FLAG_CONFIRM = 1;

    private static final Integer OP_FLAG_REFUSE = 0;

    private static final Integer CHNG_TYPE_ADD = 1;

    private static final Integer CHNG_TYPE_SUBTRACT = 2;

    @Override
    public UocChngOrderConfirmOrRefuseForInspRspBo dealConfirmOrRefuse(UocChngOrderConfirmOrRefuseForInspReqBo reqBo) {
        UocChngOrderConfirmOrRefuseForInspRspBo rspBo = UocRu.success(UocChngOrderConfirmOrRefuseForInspRspBo.class);
        validateArg(reqBo);
        String operId = reqBo.getUserId().toString();
        Date now = new Date();
        //查询变更明细
        List<UocChngOrderItemObj> uocChngOrderItemObjList = getListChngOrderItemObj(reqBo);
        //批量更新变更主体信息:主要是uoc_chng_order状态
        iUocChngOrderModel.modifyBatchChngOrderState(convertChngOrderDo(reqBo, now, operId));
        Map<Integer, List<UocChngOrderItemObj>> chngItems = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getChngType));

        List<UocChngOrderItemObj> uocChngNums = chngItems.get(UocConstant.BUSI_TYPE.NUM);

        //数量变更
        if (!CollectionUtil.isEmpty(uocChngNums)) {
            if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
                confirm(reqBo, operId, now, uocChngNums);
            }
            if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
                refuse(reqBo, operId, now, uocChngNums);
            }
        }
        reqBo.getChngOrderList().forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            // 提交任务
            UocCommonDo uocCommonDo = new UocCommonDo();
            List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(uocChngOrderConfirmOrRefuseReqItemBo.getTaskId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(11111L);
            uocCommonDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            iUocCommonModel.dealTask(uocCommonDo);
        });
        dealMap(reqBo, now);
        //封装出参对象 (查询销售单明细 ，验收单明细)
        buildSyncRsp(reqBo,rspBo,uocChngOrderItemObjList);
        return rspBo;
    }

    /**
     * 处理拒绝
     * @param reqBo
     * @param operId
     * @param now
     * @param uocChngOrderItemObjList
     */
    private void refuse(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        iUocSaleOrderModel.modifyItemChngCountRefuse(convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
        // 验收单明细异常变更数量更新为0
        iUocInspOrderModel.modifyItemChngCountRefuse(convertInspOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
    }

    /**
     * 处理确认
     * @param reqBo
     * @param operId
     * @param now
     * @param uocChngOrderItemObjList
     */
    private void confirm(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        for (UocChngOrderItemObj uocChngOrderItemObj : uocChngOrderItemObjList) {
            if (uocChngOrderItemObj.getAddOrSubtractType().equals(CHNG_TYPE_ADD)){
                //增加剩余验收数量，变更在途数量 = 0
                iUocInspOrderModel.modifyItemChngCountConfirmAdd(convertInspOrderDoForSingle(reqBo, now, operId, uocChngOrderItemObj));
            } else if(uocChngOrderItemObj.getAddOrSubtractType().equals(CHNG_TYPE_SUBTRACT)){
                //减少验收数量
                iUocInspOrderModel.modifyItemChngCountConfirmReduce(convertInspOrderDoForSingle(reqBo, now, operId, uocChngOrderItemObj));
            }
        }
        iUocSaleOrderModel.modifyItemChngCountRefuse(convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
    }
   private void chngInspFee(List<UocChngOrderItemObj> uocChngOrderItemObjList,UocChngOrderConfirmOrRefuseForInspReqBo reqBO) {
        Map<String, List<UocChngOrderItemObj>> listMap = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getRemark));

        listMap.forEach((k, v) -> {
            BigDecimal totalSaleFee = v.stream().map(UocChngOrderItemObj::getChngFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalPurchaseFee = v.stream().map(UocChngOrderItemObj::getChngPurchaseFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            UocInspOrderDo orderDo = new UocInspOrderDo();
            orderDo.setInspOrderId(Long.parseLong(k));
            orderDo.setTotalSaleFee(totalSaleFee);
            orderDo.setTotalPurchaseFee(totalPurchaseFee);
            iUocInspOrderModel.modifyBatchItemInspConfirm(orderDo);
        });
    }

    private UocInspOrderDo convertInspOrderDoForSingle(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now, String operId, UocChngOrderItemObj uocChngOrderItemObj) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setInspOrderItemsIdList(Arrays.asList(uocChngOrderItemObj.getInspOrderItemId()));
        uocInspOrderDo.setOrderIdList(Arrays.asList(uocChngOrderItemObj.getOrderId()));
        //验收变更数量
        uocInspOrderDo.setInspCount(uocChngOrderItemObj.getChngNum().negate());
        uocInspOrderDo.setUpdateTime(now);
        uocInspOrderDo.setUpdateOperId(operId);
        return uocInspOrderDo;
    }
    /**
     * 查询验收单信息信息
     * @param reqBo
     * @param now
     * @param operId
     * @param uocChngOrderItemObjList
     * @return
     */
    private UocInspOrderDo convertInspOrderDo(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setInspOrderItemsIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getInspOrderItemId).collect(Collectors.toList()));
        uocInspOrderDo.setOrderIdList(orderIdList);
        uocInspOrderDo.setUpdateTime(now);
        uocInspOrderDo.setUpdateOperId(operId);
        return uocInspOrderDo;
    }
    /**
     * 查询执行单信息
     */
    private UocSaleOrderDo convertSaleOrderDo(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setUpdateOperId(operId);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList()));
        uocSaleOrderDo.setSaleOrderItemsIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList()));
        return uocSaleOrderDo;
    }

    /**
     * 组装变更单信息
     */
    private List<UocChngOrderDo> convertChngOrderDo(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now, String operId) {
        String state = getState(reqBo);
        return reqBo.getChngOrderList().stream().map(uocChngOrderConfirmOrRefuseReqItemBo -> {
            UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
            uocChngOrderDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            uocChngOrderDo.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
            uocChngOrderDo.setChngOrderState(state);
            uocChngOrderDo.setUpdateTime(now);
            uocChngOrderDo.setUpdateOperId(operId);
            uocChngOrderDo.setUpdateOperName(reqBo.getName());
            uocChngOrderDo.setRejectReason(reqBo.getRejectRemark());
            return uocChngOrderDo;
        }).collect(Collectors.toList());
    }

    /**
     * 获取对应状态
     */
    private String getState(UocChngOrderConfirmOrRefuseForInspReqBo reqBo) {
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            return UocStateConstants.ChngOrder.NUM.CHNG_CHNG_JJ;
        }
        return UocStateConstants.ChngOrder.NUM.CHNG_CHNG_QR;
    }



    /**
     * 查询变更对象明细信息
     */
    private List<UocChngOrderItemObj> getListChngOrderItemObj(UocChngOrderConfirmOrRefuseForInspReqBo reqBo){
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
        UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
        uocChngOrderItemObjQryBo.setChngOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList()));
        uocChngOrderItemObjQryBo.setOrderIdList(orderIdList);
        List<UocChngOrderItemObj> uocChngOrderItemObjList = iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
        if (CollectionUtils.isEmpty(uocChngOrderItemObjList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "查询变更明细对象为空");
        }
        return uocChngOrderItemObjList;
    }

    private void validateArg(UocChngOrderConfirmOrRefuseForInspReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (!OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) && !OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参操作只支持确认或拒绝为空");
        }
        if (CollectionUtils.isEmpty(reqBo.getChngOrderList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息列表不能为空");
        }
        reqBo.getChngOrderList().forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            if (null == uocChngOrderConfirmOrRefuseReqItemBo.getOrderId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息的订单ID不能为空");
            }
            if (null == uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息的变更单ID不能为空");
            }
        });
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID不能为空");
        }
        List<UocChngOrderConfirmOrRefuseReqItemBo> chngOrderList = reqBo.getChngOrderList();
        chngOrderList.forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {

            if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList())) {
                uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性对象ID不能为空");
                    }
                    if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性编码不能为空");
                    }
                });
            }
            if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList())) {
                uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
                    if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型不能为空");
                    }
                    if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型仅支持新增和修改");
                    }
                    if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                        if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，对象ID不能为空");
                        }
                        if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，属性编码不能为空");
                        }
                    }
                    if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                        if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，对象ID不能为空");
                        }
                        if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性编码不能为空");
                        }
                        if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldValue())) {
                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性值不能为空");
                        }
                    }
                });
            }
        });
    }

    /**
     * 扩展属性处理
     */
    private void dealMap(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, Date now) {
        List<UocChngOrderConfirmOrRefuseReqItemBo> chngOrderList = reqBo.getChngOrderList();
        chngOrderList.forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList())) {
                UocChngOrderDo delChngOrderDo = new UocChngOrderDo();
                List<UocChngOrderMap> extParallelBoList = new ArrayList<>();
                uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                    UocChngOrderMap uocChngOrderMap = new UocChngOrderMap();
                    uocChngOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
                    uocChngOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
                    uocChngOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
                    uocChngOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                    uocChngOrderMap.setUpdateTime(now);
                    extParallelBoList.add(uocChngOrderMap);
                });
                delChngOrderDo.setUocChngOrderMapList(extParallelBoList);
                iUocChngOrderModel.updateInvalid(delChngOrderDo);
            }
            if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList())) {
                UocChngOrderDo add = new UocChngOrderDo();
                UocChngOrderDo modify = new UocChngOrderDo();
                List<UocChngOrderMap> addList = new ArrayList<>();
                List<UocChngOrderMap> modifyList = new ArrayList<>();
                uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
                    if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
                        UocChngOrderMap addShipOrderMap = new UocChngOrderMap();
                        addShipOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
                        addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                        addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
                        addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                        addShipOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
                        addShipOrderMap.setId(IdUtil.nextId());
                        addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                        addShipOrderMap.setCreateTime(now);
                        addList.add(addShipOrderMap);
                    } else {
                        UocChngOrderMap updateShipOrderMap = new UocChngOrderMap();
                        updateShipOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
                        updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                        updateShipOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
                        updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                        updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                        updateShipOrderMap.setUpdateTime(now);
                        modifyList.add(updateShipOrderMap);
                    }
                });
                if (!CollectionUtils.isEmpty(addList)) {
                    add.setUocChngOrderMapList(addList);
                    iUocChngOrderModel.addChngOrderMap(add);
                }
                if (!CollectionUtils.isEmpty(modifyList)) {
                    modify.setUocChngOrderMapList(modifyList);
                    iUocChngOrderModel.updateBatchValue(modify);
                }
            }
            UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
            uocChngOrderDo.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
            uocChngOrderDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            uocChngOrderDo.setChngOrderState(OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())?UocStateConstants.ChngOrder.NUM.CHNG_CHNG_QR:UocStateConstants.ChngOrder.NUM.CHNG_CHNG_JJ);
            uocChngOrderDo.setUpdateTime(now);
            uocChngOrderDo.setUpdateOperId(reqBo.getUserId().toString());
            iUocChngOrderModel.updateChngOrderMain(uocChngOrderDo);
        });
    }

    private void buildSyncRsp(UocChngOrderConfirmOrRefuseForInspReqBo reqBo, UocChngOrderConfirmOrRefuseForInspRspBo rspBo, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> saleOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList());
        List<Long> inspOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getInspOrderItemId).collect(Collectors.toList());

        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIds);
        List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        rspBo.getSaleOrderIdList().addAll(saleOrderItemList.stream().map(x -> x.getSaleOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));

        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setInspOrderItemIdList(inspOrderItemIds);
        UocInspOrderDo uocInspOrderDo = iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
        rspBo.setInspOrderIdLists(uocInspOrderDo.getUocInspOrderItemList().stream().map(x -> x.getInspOrderId()+"").distinct().collect(Collectors.toList()));
        rspBo.getInspOrderIdList().addAll(uocInspOrderDo.getUocInspOrderItemList().stream().map(x -> x.getInspOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));

        reqBo.getChngOrderList().forEach(x->{
            rspBo.getChngOrderIdList().add(x.getChngOrderId() + "-" + x.getOrderId());
        });
    }

}
